/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.art;

import com.android.tools.perflib.vmtrace.TraceAction;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class CaptureNodeConstructor {
    private final CaptureNodeModel myTopLevelNodeModel;
    private final List<CaptureNode> myTopLevelNodes = new ArrayList<CaptureNode>();
    @Nullable
    private CaptureNode myCurrentNode;
    private CaptureNode myTopLevelNode;

    CaptureNodeConstructor(CaptureNodeModel captureNodeModel) {
        this.myTopLevelNodeModel = captureNodeModel;
    }

    void addTraceAction(CaptureNodeModel captureNodeModel, TraceAction action, int threadTime, int globalTime) {
        if (action == TraceAction.METHOD_ENTER) {
            this.enterMethod(captureNodeModel, threadTime, globalTime);
        } else {
            this.exitMethod(captureNodeModel, threadTime, globalTime);
        }
    }

    private void enterMethod(CaptureNodeModel captureNodeModel, int threadTime, int globalTime) {
        CaptureNode node = new CaptureNode(captureNodeModel);
        node.setStartGlobal(globalTime);
        node.setStartThread(threadTime);
        if (this.myCurrentNode == null) {
            this.myTopLevelNodes.add(node);
        } else {
            this.myCurrentNode.addChild(node);
        }
        this.myCurrentNode = node;
    }

    private void exitMethod(CaptureNodeModel captureNodeModel, long threadTime, long globalTime) {
        if (this.myCurrentNode != null) {
            if (this.myCurrentNode.getData() != captureNodeModel) {
                String msg = String.format("Error during call stack reconstruction. Attempt to exit from method %s while in method %s", this.myCurrentNode.getData().getId(), captureNodeModel.getId());
                throw new RuntimeException(msg);
            }
            this.myCurrentNode.setEndGlobal(globalTime);
            this.myCurrentNode.setEndThread(threadTime);
            this.myCurrentNode = this.myCurrentNode.getParent();
        } else {
            CaptureNode node = new CaptureNode(captureNodeModel);
            for (CaptureNode topLevel : this.myTopLevelNodes) {
                node.addChild(topLevel);
            }
            this.myTopLevelNodes.clear();
            this.myTopLevelNodes.add(node);
            node.setEndGlobal(globalTime);
            node.setEndThread(threadTime);
            long entryThreadTime = threadTime - 1L;
            long entryGlobalTime = globalTime - 1L;
            if (node.getChildCount() > 0) {
                CaptureNode first = (CaptureNode)node.getFirstChild();
                assert (first != null);
                entryThreadTime = Math.max(first.getStartThread() - 1L, 0L);
                entryGlobalTime = Math.max(first.getStartGlobal() - 1L, 0L);
            }
            node.setStartGlobal(entryGlobalTime);
            node.setStartThread(entryThreadTime);
        }
    }

    private void exitMethod(CaptureNodeModel captureNodeModel, long entryThreadTime, long entryGlobalTime, @Nullable List<CaptureNode> children) {
        long lastExitGlobalTime;
        long lastExitThreadTime;
        if (children == null || children.isEmpty()) {
            lastExitThreadTime = entryThreadTime + 1L;
            lastExitGlobalTime = entryGlobalTime + 1L;
        } else {
            CaptureNode last = children.get(children.size() - 1);
            lastExitThreadTime = last.getEndThread() + 1L;
            lastExitGlobalTime = last.getEndGlobal() + 1L;
        }
        this.exitMethod(captureNodeModel, lastExitThreadTime, lastExitGlobalTime);
    }

    private void fixUpCallStacks() {
        if (this.myTopLevelNode != null) {
            return;
        }
        while (this.myCurrentNode != null) {
            this.exitMethod(this.myCurrentNode.getData(), this.myCurrentNode.getStartThread(), this.myCurrentNode.getStartGlobal(), this.myCurrentNode.getChildren());
        }
        this.exitMethod(this.myTopLevelNodeModel, 0L, 0L, this.myTopLevelNodes);
        assert (this.myTopLevelNodes.size() == 1);
        this.myTopLevelNode = this.myTopLevelNodes.get(0);
    }

    public CaptureNode getTopLevel() {
        this.fixUpCallStacks();
        return this.myTopLevelNode;
    }
}

