/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.TabbedToolbar;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChart;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class CpuAnalysisPanel
extends AspectObserver {
    private final TabbedToolbar myTabs;
    private final JBTabbedPane myTabView;
    private final JPanel myPanel;
    private final CpuCaptureStage myStage;
    private final StudioProfilersView myProfilersView;
    private CpuAnalysisModel mySelectedModel;
    private ViewBinder<StudioProfilersView, CpuAnalysisTabModel, CpuAnalysisTab> myTabViewsBinder;

    public CpuAnalysisPanel(@NotNull StudioProfilersView view, @NotNull CpuCaptureStage stage) {
        if (view == null) {
            CpuAnalysisPanel.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuAnalysisPanel.$$$reportNull$$$0(1);
        }
        this.myTabView = new JBTabbedPane();
        this.myPanel = new JPanel(new BorderLayout());
        this.myStage = stage;
        this.myProfilersView = view;
        JLabel tabsTitle = new JLabel("Analysis");
        tabsTitle.setBorder(JBUI.Borders.empty((int)5));
        this.myTabs = new TabbedToolbar((JComponent)tabsTitle);
        this.setupBindings();
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)CpuCaptureStage.Aspect.ANALYSIS_MODEL_UPDATED, this::updateComponents);
        this.myTabs.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)1, (int)0));
        this.myPanel.add((Component)this.myTabs, "North");
        this.myPanel.add((Component)this.myTabView, "Center");
        this.myTabView.setTabComponentInsets((Insets)JBUI.insets((int)0));
        this.myTabView.addChangeListener((ChangeListener)new TabChangeListener());
    }

    private void setupBindings() {
        this.myTabViewsBinder = new ViewBinder();
        this.myTabViewsBinder.bind(CpuAnalysisChartModel.class, CpuAnalysisChart::new);
        this.myTabViewsBinder.bind(CpuAnalysisTabModel.class, CpuAnalysisSummaryTab::new);
    }

    @NotNull
    @VisibleForTesting
    JBTabbedPane getTabView() {
        JBTabbedPane jBTabbedPane = this.myTabView;
        if (jBTabbedPane == null) {
            CpuAnalysisPanel.$$$reportNull$$$0(2);
        }
        return jBTabbedPane;
    }

    @NotNull
    @VisibleForTesting
    TabbedToolbar getTabs() {
        TabbedToolbar tabbedToolbar = this.myTabs;
        if (tabbedToolbar == null) {
            CpuAnalysisPanel.$$$reportNull$$$0(3);
        }
        return tabbedToolbar;
    }

    private void updateComponents() {
        this.myTabs.clearTabs();
        List<CpuAnalysisModel> models = this.myStage.getAnalysisModels();
        if (models.isEmpty()) {
            return;
        }
        for (CpuAnalysisModel model : models) {
            this.myTabs.addTab(model.getName(), () -> this.onSelectAnalysis(model));
        }
        this.onSelectAnalysis(models.get(models.size() - 1));
    }

    private void onSelectAnalysis(@NotNull CpuAnalysisModel<?> model) {
        if (model == null) {
            CpuAnalysisPanel.$$$reportNull$$$0(4);
        }
        this.mySelectedModel = model;
        this.myTabView.removeAll();
        model.getTabModels().forEach(tabModel -> {
            String typeName = tabModel.getTabType().getName();
            this.myTabView.insertTab(typeName, null, (Component)new JPanel(), typeName, this.myTabView.getTabCount());
        });
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CpuAnalysisPanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onSelectAnalysis";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TabChangeListener
    implements ChangeListener {
        private int myLastSelectedIndex = -1;

        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int newIndex = CpuAnalysisPanel.this.myTabView.getSelectedIndex();
            if (newIndex == this.myLastSelectedIndex || CpuAnalysisPanel.this.mySelectedModel == null) {
                return;
            }
            if (this.myLastSelectedIndex >= 0 && this.myLastSelectedIndex < CpuAnalysisPanel.this.myTabView.getTabCount()) {
                CpuAnalysisPanel.this.myTabView.setComponentAt(this.myLastSelectedIndex, (Component)new JPanel());
            }
            if (newIndex >= 0 && newIndex < CpuAnalysisPanel.this.myTabView.getTabCount()) {
                CpuAnalysisPanel.this.myTabView.setComponentAt(newIndex, (Component)CpuAnalysisPanel.this.myTabViewsBinder.build((Object)CpuAnalysisPanel.this.myProfilersView, CpuAnalysisPanel.this.mySelectedModel.getTabModelAt(newIndex)));
            }
            this.myLastSelectedIndex = newIndex;
        }
    }
}

