/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import java.util.Collection;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class CpuAnalysisModel<T> {
    private final String myName;
    private final String myMultiSelectNameFormat;
    private int myMultiSelectItemCount;
    private final SortedMap<CpuAnalysisTabModel.Type, CpuAnalysisTabModel<T>> myTabModels;

    public CpuAnalysisModel(@NotNull String name) {
        if (name == null) {
            CpuAnalysisModel.$$$reportNull$$$0(0);
        }
        this(name, name);
    }

    public CpuAnalysisModel(@NotNull String name, @NotNull String multiSelectNameFormat) {
        if (name == null) {
            CpuAnalysisModel.$$$reportNull$$$0(1);
        }
        if (multiSelectNameFormat == null) {
            CpuAnalysisModel.$$$reportNull$$$0(2);
        }
        this.myTabModels = new TreeMap<CpuAnalysisTabModel.Type, CpuAnalysisTabModel<T>>();
        this.myName = name;
        this.myMultiSelectItemCount = 1;
        this.myMultiSelectNameFormat = multiSelectNameFormat;
    }

    @NotNull
    public String getName() {
        String string = this.myMultiSelectItemCount < 2 ? this.myName : String.format(Locale.getDefault(), this.myMultiSelectNameFormat, this.myMultiSelectItemCount);
        if (string == null) {
            CpuAnalysisModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void addTabModel(CpuAnalysisTabModel<T> tabModel) {
        this.myTabModels.put(tabModel.getTabType(), tabModel);
    }

    @NotNull
    public Iterable<CpuAnalysisTabModel<T>> getTabModels() {
        Collection<CpuAnalysisTabModel<T>> collection = this.myTabModels.values();
        if (collection == null) {
            CpuAnalysisModel.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public int getTabSize() {
        return this.myTabModels.size();
    }

    @NotNull
    public CpuAnalysisTabModel<T> getTabModelAt(int index) throws IndexOutOfBoundsException {
        if (index >= this.myTabModels.size()) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        for (CpuAnalysisTabModel<T> tabModel : this.myTabModels.values()) {
            if (count == index) {
                CpuAnalysisTabModel<T> cpuAnalysisTabModel = tabModel;
                if (cpuAnalysisTabModel == null) {
                    CpuAnalysisModel.$$$reportNull$$$0(5);
                }
                return cpuAnalysisTabModel;
            }
            ++count;
        }
        throw new IllegalStateException();
    }

    @NotNull
    public CpuAnalysisModel<T> mergeWith(@NotNull CpuAnalysisModel<T> anotherModel) {
        if (anotherModel == null) {
            CpuAnalysisModel.$$$reportNull$$$0(6);
        }
        anotherModel.myTabModels.forEach((type, tabModel) -> {
            if (this.myTabModels.containsKey(type)) {
                ((CpuAnalysisTabModel)this.myTabModels.get(type)).getDataSeries().addAll(tabModel.getDataSeries());
            } else {
                this.myTabModels.put((CpuAnalysisTabModel.Type)((Object)type), (CpuAnalysisTabModel<T>)tabModel);
            }
        });
        ++this.myMultiSelectItemCount;
        CpuAnalysisModel cpuAnalysisModel = this;
        if (cpuAnalysisModel == null) {
            CpuAnalysisModel.$$$reportNull$$$0(7);
        }
        return cpuAnalysisModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiSelectNameFormat";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabModels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabModelAt";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

