/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.cpu.StatusPanelModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusPanel
extends JComponent {
    @NotNull
    private JLabel myDurationLabel;
    @NotNull
    private final String myStatus;
    @NotNull
    private final StatusPanelModel myModel;
    private final AspectObserver myObserver;
    private final JButton myAbortButton;

    public StatusPanel(@NotNull StatusPanelModel captureHandler, @NotNull String status, @Nullable String abortText) {
        if (captureHandler == null) {
            StatusPanel.$$$reportNull$$$0(0);
        }
        if (status == null) {
            StatusPanel.$$$reportNull$$$0(1);
        }
        this.myDurationLabel = new JLabel();
        this.myObserver = new AspectObserver();
        this.myModel = captureHandler;
        this.myStatus = status;
        this.myModel.getRange().addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::updateDuration);
        this.myAbortButton = abortText != null ? this.createAbortButton(abortText) : null;
        this.populateContent();
    }

    public void setAbortButtonEnabled(boolean enabled) {
        if (this.myAbortButton == null) {
            return;
        }
        this.myAbortButton.setEnabled(enabled);
    }

    private void populateContent() {
        JPanel mainPanel = new JPanel((LayoutManager)new TabularLayout("*,300px,*", "*,150px,*"));
        JPanel statusPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit,20px,Fit,*", "28px,Fit,Fit,Fit,Fit,*").setVGap(JBUI.scale((int)5)));
        statusPanel.setBorder(new LineBorder(ProfilerColors.CPU_CAPTURE_STATUS, 1));
        JLabel status = StatusPanel.createLabel("Status", true);
        JLabel actualStatus = StatusPanel.createLabel(this.myStatus, false);
        JLabel duration = StatusPanel.createLabel("Duration", true);
        JLabel technology = StatusPanel.createLabel("Type", true);
        JLabel actualTechnology = StatusPanel.createLabel(this.myModel.getConfigurationText(), false);
        statusPanel.add((Component)status, new TabularLayout.Constraint(1, 1));
        statusPanel.add((Component)actualStatus, new TabularLayout.Constraint(1, 3));
        statusPanel.add((Component)duration, new TabularLayout.Constraint(2, 1));
        statusPanel.add((Component)this.myDurationLabel, new TabularLayout.Constraint(2, 3));
        statusPanel.add((Component)technology, new TabularLayout.Constraint(3, 1));
        statusPanel.add((Component)actualTechnology, new TabularLayout.Constraint(3, 3));
        statusPanel.add((Component)this.createButtonPanel(), new TabularLayout.Constraint(4, 3, 1));
        mainPanel.add((Component)statusPanel, new TabularLayout.Constraint(1, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
    }

    private void updateDuration() {
        this.myDurationLabel.setText(this.getDurationText());
    }

    private static JLabel createLabel(String text, boolean isRightAligned) {
        JLabel label = new JLabel(text, isRightAligned ? 4 : 2);
        label.setFont(ProfilerFonts.STANDARD_FONT);
        label.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        label.setBorder((Border)JBUI.Borders.empty());
        return label;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("Fit", "4px,*"));
        if (this.myAbortButton != null) {
            panel.add((Component)this.myAbortButton, new TabularLayout.Constraint(1, 0));
        }
        return panel;
    }

    @VisibleForTesting
    JLabel getDurationLabel() {
        return this.myDurationLabel;
    }

    @NotNull
    private String getDurationText() {
        String string = TimeFormatter.getMultiUnitDurationString((long)TimeUnit.NANOSECONDS.toMicros((long)this.myModel.getRange().getLength()));
        if (string == null) {
            StatusPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    private JButton createAbortButton(@NotNull String abortText) {
        if (abortText == null) {
            StatusPanel.$$$reportNull$$$0(3);
        }
        JButton abortButton = new JButton(abortText);
        abortButton.addActionListener(event -> {
            this.myModel.abort();
            abortButton.setEnabled(false);
        });
        return abortButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/StatusPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abortText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/StatusPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDurationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAbortButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

