/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import org.jetbrains.annotations.NotNull;

public class CpuThreadInfo
implements Comparable<CpuThreadInfo> {
    private static final String RENDER_THREAD_NAME = "RenderThread";
    private final int myId;
    private final String myName;
    private final boolean myIsMainThread;

    public CpuThreadInfo(int threadId, String name, boolean isMainThread) {
        this.myId = threadId;
        this.myName = name;
        this.myIsMainThread = isMainThread;
    }

    public CpuThreadInfo(int threadId, String name) {
        this(threadId, name, false);
    }

    public int getId() {
        return this.myId;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CpuThreadInfo.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isMainThread() {
        return this.myIsMainThread;
    }

    public boolean isRenderThread() {
        return this.getName().equals(RENDER_THREAD_NAME);
    }

    @Override
    public int compareTo(@NotNull CpuThreadInfo o) {
        if (o == null) {
            CpuThreadInfo.$$$reportNull$$$0(1);
        }
        if (this.isMainThread()) {
            return -1;
        }
        if (o.isMainThread()) {
            return 1;
        }
        boolean thisIsRenderThread = this.isRenderThread();
        boolean otherIsRenderThread = o.isRenderThread();
        if (thisIsRenderThread && otherIsRenderThread) {
            return this.getId() - o.getId();
        }
        if (thisIsRenderThread) {
            return -1;
        }
        if (otherIsRenderThread) {
            return 1;
        }
        int nameResult = this.getName().compareTo(o.getName());
        if (nameResult == 0) {
            return this.getId() - o.getId();
        }
        return nameResult;
    }

    public String toString() {
        return this.getName() + ":" + this.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

