/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuMonitor;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.atrace.AtraceExporter;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfiler
extends StudioProfiler {
    @NotNull
    private final Map<Long, File> mySessionTraceFiles;

    public CpuProfiler(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.mySessionTraceFiles = new HashMap<Long, File>();
        this.registerImportedSessionListener();
        this.registerTraceImportHandler();
    }

    private void run() {
        Common.Session session = this.myProfilers.getSession();
        StreamingTimeline timeline = this.myProfilers.getTimeline();
        timeline.reset(session.getStartTimestamp(), session.getEndTimestamp());
        timeline.setIsPaused(true);
        assert (this.mySessionTraceFiles.containsKey(session.getSessionId()));
        if (this.myProfilers.getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()) {
            ProfilingConfiguration importConfig = new ProfilingConfiguration("Imported", Cpu.CpuTraceType.UNSPECIFIED_TYPE, Cpu.CpuTraceMode.UNSPECIFIED_MODE);
            this.myProfilers.setStage(CpuCaptureStage.create(this.myProfilers, importConfig, this.mySessionTraceFiles.get(session.getSessionId())));
        } else {
            this.myProfilers.setStage(new CpuProfilerStage(this.myProfilers, this.mySessionTraceFiles.get(session.getSessionId())));
        }
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfiler.class);
    }

    private void registerImportedSessionListener() {
        this.myProfilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.CPU_CAPTURE, this::run);
    }

    private void registerTraceImportHandler() {
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        sessionsManager.registerImportHandler("trace", file -> {
            long startTimestampEpochMs = System.currentTimeMillis();
            long startTimestampNs = StudioProfilers.getFileCreationTimestampNs(file, startTimestampEpochMs);
            if (sessionsManager.setSessionById(startTimestampNs)) {
                return;
            }
            long endTimestampNs = startTimestampNs + TimeUnit.MINUTES.toNanos(1L);
            if (this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
                sessionsManager.createImportedSession(file.getName(), Common.SessionData.SessionStarted.SessionType.CPU_CAPTURE, startTimestampNs, endTimestampNs, startTimestampEpochMs, Collections.emptyMap(), new Common.Event[0]);
                this.mySessionTraceFiles.put(startTimestampNs, (File)file);
            } else {
                Common.Session importedSession = sessionsManager.createImportedSessionLegacy(file.getName(), Common.SessionMetaData.SessionType.CPU_CAPTURE, startTimestampNs, endTimestampNs, startTimestampEpochMs);
                this.mySessionTraceFiles.put(importedSession.getSessionId(), (File)file);
                sessionsManager.update();
                sessionsManager.setSession(importedSession);
            }
            this.myProfilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.CPU_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
        });
    }

    @Nullable
    public File getTraceFile(Common.Session session) {
        return this.mySessionTraceFiles.get(session.getSessionId());
    }

    @Override
    public ProfilerMonitor newMonitor() {
        return new CpuMonitor(this.myProfilers);
    }

    @Override
    public void startProfiling(Common.Session session) {
        this.myProfilers.getClient().getCpuClient().startMonitoringApp(CpuProfiler.CpuStartRequest.newBuilder().setSession(session).build());
    }

    @Override
    public void stopProfiling(Common.Session session) {
        Cpu.CpuTraceInfo mostRecentTrace;
        List<Cpu.CpuTraceInfo> traces = CpuProfiler.getTraceInfoFromSession(this.myProfilers.getClient(), session, this.myProfilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled());
        Cpu.CpuTraceInfo cpuTraceInfo = mostRecentTrace = traces.isEmpty() ? null : traces.get(traces.size() - 1);
        if (mostRecentTrace != null && mostRecentTrace.getToTimestamp() == -1L) {
            CpuProfiler.stopTracing(this.myProfilers, session, mostRecentTrace.getConfiguration(), null);
        }
        this.myProfilers.getClient().getCpuClient().stopMonitoringApp(CpuProfiler.CpuStopRequest.newBuilder().setSession(session).build());
    }

    static void saveCaptureToFile(@NotNull StudioProfilers profilers, @NotNull Cpu.CpuTraceInfo info, @NotNull OutputStream outputStream) {
        block12: {
            if (profilers == null) {
                CpuProfiler.$$$reportNull$$$0(1);
            }
            if (info == null) {
                CpuProfiler.$$$reportNull$$$0(2);
            }
            if (outputStream == null) {
                CpuProfiler.$$$reportNull$$$0(3);
            }
            try {
                Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setId(String.valueOf(info.getTraceId())).build();
                Transport.BytesResponse traceResponse = profilers.getClient().getTransportClient().getBytes(traceRequest);
                if (info.getConfiguration().getUserOptions().getTraceType() == Cpu.CpuTraceType.ATRACE) {
                    File trace = FileUtil.createTempFile((String)String.format("cpu_trace_%d", info.getTraceId()), (String)".trace", (boolean)true);
                    try (FileOutputStream out = new FileOutputStream(trace);){
                        out.write(traceResponse.getContents().toByteArray());
                    }
                    AtraceExporter.export(trace, outputStream);
                    break block12;
                }
                FileUtil.copy((InputStream)new ByteArrayInputStream(traceResponse.getContents().toByteArray()), (OutputStream)outputStream);
            }
            catch (IOException exception) {
                CpuProfiler.getLogger().warn("Failed to export CPU trace file:\n" + exception);
            }
        }
    }

    @NotNull
    static String generateCaptureFileName(@NotNull Cpu.CpuTraceType profilerType) {
        if (profilerType == null) {
            CpuProfiler.$$$reportNull$$$0(4);
        }
        StringBuilder traceName = new StringBuilder(String.format("cpu-%s-", StringUtil.toLowerCase((String)profilerType.name())));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        traceName.append(LocalDateTime.now().format(formatter));
        String string = traceName.toString();
        if (string == null) {
            CpuProfiler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static List<Cpu.CpuTraceInfo> getTraceInfoFromRange(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs, boolean newPipeline) {
        if (client == null) {
            CpuProfiler.$$$reportNull$$$0(6);
        }
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(7);
        }
        if (rangeUs == null) {
            CpuProfiler.$$$reportNull$$$0(8);
        }
        long rangeMinNs = rangeUs.getMin() == -9.223372036854776E18 ? Long.MIN_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long rangeMaxNs = rangeUs.getMax() == 9.223372036854776E18 ? Long.MAX_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        List<Object> traceInfoList = new ArrayList<Cpu.CpuTraceInfo>();
        if (newPipeline) {
            Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.CPU_TRACE).setFromTimestamp(rangeMinNs).setToTimestamp(rangeMaxNs).build());
            traceInfoList = response.getGroupsList().stream().map(group -> {
                Cpu.CpuTraceInfo info;
                Common.Event event = group.getEvents(group.getEventsCount() - 1);
                Cpu.CpuTraceInfo cpuTraceInfo = info = event.getCpuTrace().hasTraceStarted() ? event.getCpuTrace().getTraceStarted().getTraceInfo() : event.getCpuTrace().getTraceEnded().getTraceInfo();
                if (info.equals((Object)Cpu.CpuTraceInfo.getDefaultInstance())) {
                    assert (group.getEventsCount() > 1);
                    info = group.getEvents(0).getCpuTrace().getTraceStarted().getTraceInfo();
                    if (info.getToTimestamp() == -1L) {
                        info = info.toBuilder().setToTimestamp(session.getEndTimestamp()).setStopStatus(Cpu.TraceStopStatus.newBuilder().setStatus(Cpu.TraceStopStatus.Status.APP_PROCESS_DIED)).build();
                    }
                }
                return info;
            }).sorted(Comparator.comparingLong(Cpu.CpuTraceInfo::getFromTimestamp)).collect(Collectors.toList());
        } else {
            CpuProfiler.GetTraceInfoResponse response = client.getCpuClient().getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(session).setFromTimestamp(rangeMinNs).setToTimestamp(rangeMaxNs).build());
            traceInfoList.addAll(response.getTraceInfoList().stream().collect(Collectors.toList()));
        }
        ArrayList<Cpu.CpuTraceInfo> arrayList = traceInfoList;
        if (arrayList == null) {
            CpuProfiler.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static Cpu.CpuTraceInfo getTraceInfoFromId(@NotNull StudioProfilers profilers, long traceId) {
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(10);
        }
        if (!profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Cpu.CpuTraceInfo cpuTraceInfo = Cpu.CpuTraceInfo.getDefaultInstance();
            if (cpuTraceInfo == null) {
                CpuProfiler.$$$reportNull$$$0(11);
            }
            return cpuTraceInfo;
        }
        Transport.GetEventGroupsResponse response = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setKind(Common.Event.Kind.CPU_TRACE).setGroupId(traceId).build());
        if (response.getGroupsCount() == 0) {
            Cpu.CpuTraceInfo cpuTraceInfo = Cpu.CpuTraceInfo.getDefaultInstance();
            if (cpuTraceInfo == null) {
                CpuProfiler.$$$reportNull$$$0(12);
            }
            return cpuTraceInfo;
        }
        Cpu.CpuTraceData data = response.getGroups(0).getEvents(response.getGroups(0).getEventsCount() - 1).getCpuTrace();
        if (data.hasTraceStarted()) {
            Cpu.CpuTraceInfo cpuTraceInfo = data.getTraceStarted().getTraceInfo();
            if (cpuTraceInfo == null) {
                CpuProfiler.$$$reportNull$$$0(13);
            }
            return cpuTraceInfo;
        }
        Cpu.CpuTraceInfo cpuTraceInfo = data.getTraceEnded().getTraceInfo();
        if (cpuTraceInfo == null) {
            CpuProfiler.$$$reportNull$$$0(14);
        }
        return cpuTraceInfo;
    }

    @NotNull
    public static List<Cpu.CpuTraceInfo> getTraceInfoFromSession(@NotNull ProfilerClient client, @NotNull Common.Session session, boolean newPipeline) {
        if (client == null) {
            CpuProfiler.$$$reportNull$$$0(15);
        }
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(16);
        }
        return CpuProfiler.getTraceInfoFromRange(client, session, new Range(-9.223372036854776E18, 9.223372036854776E18), newPipeline);
    }

    @NotNull
    public static Common.Event getTraceStatusEventFromId(@NotNull StudioProfilers profilers, long traceId) {
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(17);
        }
        if (!profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Common.Event event = Common.Event.getDefaultInstance();
            if (event == null) {
                CpuProfiler.$$$reportNull$$$0(18);
            }
            return event;
        }
        Transport.GetEventGroupsResponse response = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setKind(Common.Event.Kind.CPU_TRACE_STATUS).setGroupId(traceId).build());
        if (response.getGroupsCount() == 0) {
            Common.Event event = Common.Event.getDefaultInstance();
            if (event == null) {
                CpuProfiler.$$$reportNull$$$0(19);
            }
            return event;
        }
        Common.Event event = response.getGroups(0).getEvents(response.getGroups(0).getEventsCount() - 1);
        if (event == null) {
            CpuProfiler.$$$reportNull$$$0(20);
        }
        return event;
    }

    public static void stopTracing(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Cpu.CpuTraceConfiguration configuration, @Nullable Consumer<Cpu.TraceStopStatus> responseHandler) {
        if (profilers == null) {
            CpuProfiler.$$$reportNull$$$0(21);
        }
        if (session == null) {
            CpuProfiler.$$$reportNull$$$0(22);
        }
        if (configuration == null) {
            CpuProfiler.$$$reportNull$$$0(23);
        }
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Commands.Command stopCommand = Commands.Command.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setType(Commands.Command.CommandType.STOP_CPU_TRACE).setStopCpuTrace(Cpu.StopCpuTrace.newBuilder().setConfiguration(configuration).setNeedTraceResponse(responseHandler != null)).build();
            Transport.ExecuteResponse response2 = profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(stopCommand).build());
            if (responseHandler != null) {
                TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.CPU_TRACE_STATUS, profilers.getIdeServices().getMainExecutor(), event -> event.getCommandId() == response2.getCommandId(), () -> session.getStreamId(), () -> session.getPid(), event -> {
                    responseHandler.accept(event.getCpuTraceStatus().getTraceStopStatus());
                    return true;
                });
                profilers.getTransportPoller().registerListener(statusListener);
            }
        } else {
            CpuProfiler.CpuProfilingAppStopRequest request = CpuProfiler.CpuProfilingAppStopRequest.newBuilder().setTraceType(configuration.getUserOptions().getTraceType()).setTraceMode(configuration.getUserOptions().getTraceMode()).setAppName(configuration.getAppName()).setSession(session).setNeedTraceResponse(responseHandler != null).build();
            CompletableFuture<CpuProfiler.CpuProfilingAppStopResponse> future = CompletableFuture.supplyAsync(() -> profilers.getClient().getCpuClient().stopProfilingApp(request), profilers.getIdeServices().getPoolExecutor());
            if (responseHandler != null) {
                future.thenAcceptAsync(response -> responseHandler.accept(response.getStatus()), profilers.getIdeServices().getMainExecutor());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerType";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfiler";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 7: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeUs";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfiler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCaptureFileName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceInfoFromRange";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceInfoFromId";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceStatusEventFromId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveCaptureToFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateCaptureFileName";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTraceInfoFromRange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTraceInfoFromId";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTraceInfoFromSession";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTraceStatusEventFromId";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "stopTracing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

