/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuCellRenderer;
import com.android.tools.profilers.cpu.CpuKernelModel;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class CpuKernelCellRenderer
extends CpuCellRenderer<CpuKernelModel.CpuState, CpuThreadSliceInfo> {
    @NotNull
    private final CpuProfilerStage myStage;
    private final boolean myDebugRenderingEnabled;
    @VisibleForTesting
    final int myProcessId;

    public CpuKernelCellRenderer(@NotNull CpuProfilerStage stage, @NotNull FeatureConfig featureConfig, int processId, @NotNull JList<CpuKernelModel.CpuState> cpuStateList) {
        if (stage == null) {
            CpuKernelCellRenderer.$$$reportNull$$$0(0);
        }
        if (featureConfig == null) {
            CpuKernelCellRenderer.$$$reportNull$$$0(1);
        }
        if (cpuStateList == null) {
            CpuKernelCellRenderer.$$$reportNull$$$0(2);
        }
        super(cpuStateList);
        this.myStage = stage;
        this.myProcessId = processId;
        this.myDebugRenderingEnabled = featureConfig.isPerformanceMonitoringEnabled();
    }

    @Override
    @NotNull
    StateChart<CpuThreadSliceInfo> getChartForModel(@NotNull CpuKernelModel.CpuState model) {
        if (model == null) {
            CpuKernelCellRenderer.$$$reportNull$$$0(3);
        }
        StateChart stateChart = ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.getCpuId())).getChart();
        if (stateChart == null) {
            CpuKernelCellRenderer.$$$reportNull$$$0(4);
        }
        return stateChart;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends CpuKernelModel.CpuState> list, CpuKernelModel.CpuState value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("150px,*", "*"));
        panel.setBorder(ProfilerLayout.CPU_THREADS_BORDER);
        panel.setPreferredSize((Dimension)JBDimension.create((Dimension)panel.getPreferredSize()).withHeight(21));
        panel.setBackground(list.getBackground());
        this.myLabel.setText(String.format("CPU %d", value.getCpuId()));
        this.myLabel.setBackground(ProfilerColors.THREAD_LABEL_BACKGROUND);
        this.myLabel.setForeground(ProfilerColors.THREAD_LABEL_TEXT);
        JBEmptyBorder iconIndent = JBUI.Borders.emptyLeft((int)(StudioIcons.LayoutEditor.Menu.MENU.getIconWidth() + this.myLabel.getIconTextGap()));
        this.myLabel.setBorder(new CompoundBorder((Border)iconIndent, ProfilerLayout.CPU_THREADS_RIGHT_BORDER));
        int cpuId = value.getCpuId();
        StateChartModel<CpuThreadSliceInfo> model = value.getModel();
        StateChart<CpuThreadSliceInfo> stateChart = this.getOrCreateStateChart(cpuId, model);
        stateChart.setDrawDebugInfo(this.myDebugRenderingEnabled);
        stateChart.setOpaque(true);
        panel.add((Component)this.myLabel, new TabularLayout.Constraint(0, 0));
        panel.add((Component)stateChart, new TabularLayout.Constraint(0, 0, 2));
        return panel;
    }

    private StateChart<CpuThreadSliceInfo> getOrCreateStateChart(int cpuId, StateChartModel<CpuThreadSliceInfo> model) {
        if (this.myStateCharts.containsKey(cpuId) && ((CpuCellRenderer.StateChartData)this.myStateCharts.get(cpuId)).getModel().equals(model)) {
            return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(cpuId)).getChart();
        }
        StateChart stateChart = new StateChart(model, (StateChartColorProvider)new StateChartColorProvider<CpuThreadSliceInfo>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull CpuThreadSliceInfo value) {
                boolean isSelected;
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == CpuThreadSliceInfo.NULL_THREAD) {
                    Color color = ProfilerColors.DEFAULT_BACKGROUND;
                    if (color == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return color;
                }
                if (value.getProcessId() != CpuKernelCellRenderer.this.myProcessId) {
                    Color color = isMouseOver ? ProfilerColors.CPU_KERNEL_OTHER_HOVER : ProfilerColors.CPU_KERNEL_OTHER;
                    if (color == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return color;
                }
                boolean bl = isSelected = CpuKernelCellRenderer.this.myStage.getSelectedThread() == value.getId();
                if (isMouseOver) {
                    Color color = ProfilerColors.CPU_KERNEL_APP_HOVER;
                    if (color == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return color;
                }
                if (isSelected) {
                    Color color = ProfilerColors.CPU_KERNEL_APP_SELECTED;
                    if (color == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return color;
                }
                Color color = ProfilerColors.CPU_KERNEL_APP;
                if (color == null) {
                    1.$$$reportNull$$$0(5);
                }
                return color;
            }

            @NotNull
            public Color getFontColor(boolean isMouseOver, @NotNull CpuThreadSliceInfo value) {
                boolean isSelected;
                if (value == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (value == CpuThreadSliceInfo.NULL_THREAD) {
                    Color color = AdtUiUtils.DEFAULT_FONT_COLOR;
                    if (color == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return color;
                }
                if (value.getProcessId() != CpuKernelCellRenderer.this.myProcessId) {
                    Color color = isMouseOver ? ProfilerColors.CPU_KERNEL_OTHER_TEXT_HOVER : ProfilerColors.CPU_KERNEL_OTHER_TEXT;
                    if (color == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return color;
                }
                boolean bl = isSelected = CpuKernelCellRenderer.this.myStage.getSelectedThread() == value.getId();
                if (isMouseOver) {
                    Color color = ProfilerColors.CPU_KERNEL_APP_TEXT_HOVER;
                    if (color == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    return color;
                }
                if (isSelected) {
                    Color color = ProfilerColors.CPU_KERNEL_APP_TEXT_SELECTED;
                    if (color == null) {
                        1.$$$reportNull$$$0(10);
                    }
                    return color;
                }
                Color color = ProfilerColors.CPU_KERNEL_APP_TEXT;
                if (color == null) {
                    1.$$$reportNull$$$0(11);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/cpu/CpuKernelCellRenderer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/cpu/CpuKernelCellRenderer$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColor";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFontColor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getColor";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getFontColor";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, threadInfo -> threadInfo.getName());
        stateChart.setRenderMode(StateChart.RenderMode.TEXT);
        CpuCellRenderer.StateChartData<CpuThreadSliceInfo> data = new CpuCellRenderer.StateChartData<CpuThreadSliceInfo>(stateChart, model);
        stateChart.setHeightGap(0.0f);
        this.myStateCharts.put(cpuId, data);
        return stateChart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuStateList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuKernelCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuKernelCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChartForModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChartForModel";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

