/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureMetadata {
    private CaptureStatus myStatus;
    private long myCaptureDurationMs;
    private long myRecordDurationMs;
    private int myTraceFileSizeBytes;
    private long myParsingTimeMs;
    private int myStoppingTimeMs;
    @NotNull
    private ProfilingConfiguration myProfilingConfiguration;

    public CpuCaptureMetadata(@NotNull ProfilingConfiguration configuration) {
        if (configuration == null) {
            CpuCaptureMetadata.$$$reportNull$$$0(0);
        }
        this.myProfilingConfiguration = configuration;
    }

    public CaptureStatus getStatus() {
        return this.myStatus;
    }

    public void setStatus(CaptureStatus status) {
        this.myStatus = status;
    }

    public int getTraceFileSizeBytes() {
        return this.myTraceFileSizeBytes;
    }

    public void setTraceFileSizeBytes(int traceFileSizeBytes) {
        this.myTraceFileSizeBytes = traceFileSizeBytes;
    }

    public long getCaptureDurationMs() {
        return this.myCaptureDurationMs;
    }

    public void setCaptureDurationMs(long captureDurationMs) {
        this.myCaptureDurationMs = captureDurationMs;
    }

    public int getStoppingTimeMs() {
        return this.myStoppingTimeMs;
    }

    public void setStoppingTimeMs(int stoppingTimeMs) {
        this.myStoppingTimeMs = stoppingTimeMs;
    }

    public long getParsingTimeMs() {
        return this.myParsingTimeMs;
    }

    public void setParsingTimeMs(long parsingTimeMs) {
        this.myParsingTimeMs = parsingTimeMs;
    }

    public long getRecordDurationMs() {
        return this.myRecordDurationMs;
    }

    public void setRecordDurationMs(long recordDurationMs) {
        this.myRecordDurationMs = recordDurationMs;
    }

    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        ProfilingConfiguration profilingConfiguration = this.myProfilingConfiguration;
        if (profilingConfiguration == null) {
            CpuCaptureMetadata.$$$reportNull$$$0(1);
        }
        return profilingConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureMetadata";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CaptureStatus {
        SUCCESS,
        STOP_CAPTURING_FAILURE,
        PARSING_FAILURE,
        USER_ABORTED_PARSING,
        PREPROCESS_FAILURE,
        STOP_FAILED_NO_GOING_PROFILING,
        STOP_FAILED_APP_PROCESS_DIED,
        STOP_FAILED_APP_PID_CHANGED,
        STOP_FAILED_PROFILER_PROCESS_DIED,
        STOP_FAILED_STOP_COMMAND_FAILED,
        STOP_FAILED_STILL_PROFILING_AFTER_STOP,
        STOP_FAILED_CANNOT_START_WAITING,
        STOP_FAILED_WAIT_TIMEOUT,
        STOP_FAILED_WAIT_FAILED,
        STOP_FAILED_CANNOT_READ_WAIT_EVENT,
        STOP_FAILED_CANNOT_COPY_FILE,
        STOP_FAILED_CANNOT_FORM_FILE,
        STOP_FAILED_CANNOT_READ_FILE;


        public static CaptureStatus fromStopStatus(Cpu.TraceStopStatus.Status status) {
            switch (status) {
                case NO_ONGOING_PROFILING: {
                    return STOP_FAILED_NO_GOING_PROFILING;
                }
                case APP_PROCESS_DIED: {
                    return STOP_FAILED_APP_PROCESS_DIED;
                }
                case APP_PID_CHANGED: {
                    return STOP_FAILED_APP_PID_CHANGED;
                }
                case PROFILER_PROCESS_DIED: {
                    return STOP_FAILED_PROFILER_PROCESS_DIED;
                }
                case STOP_COMMAND_FAILED: {
                    return STOP_FAILED_STOP_COMMAND_FAILED;
                }
                case STILL_PROFILING_AFTER_STOP: {
                    return STOP_FAILED_STILL_PROFILING_AFTER_STOP;
                }
                case CANNOT_START_WAITING: {
                    return STOP_FAILED_CANNOT_START_WAITING;
                }
                case WAIT_TIMEOUT: {
                    return STOP_FAILED_WAIT_TIMEOUT;
                }
                case WAIT_FAILED: {
                    return STOP_FAILED_WAIT_FAILED;
                }
                case CANNOT_READ_WAIT_EVENT: {
                    return STOP_FAILED_CANNOT_READ_WAIT_EVENT;
                }
                case CANNOT_COPY_FILE: {
                    return STOP_FAILED_CANNOT_COPY_FILE;
                }
                case CANNOT_FORM_FILE: {
                    return STOP_FAILED_CANNOT_FORM_FILE;
                }
                case CANNOT_READ_FILE: {
                    return STOP_FAILED_CANNOT_READ_FILE;
                }
            }
            return SUCCESS;
        }
    }
}

