/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.DefaultTimeline;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.TraceParser;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCapture
implements ConfigurableDurationData {
    private final int myMainThreadId;
    @NotNull
    private ClockType myClockType;
    @NotNull
    private final Map<CpuThreadInfo, CaptureNode> myCaptureTrees;
    @NotNull
    private final Timeline myTimeline;
    private final boolean myCaptureSupportsDualClock;
    private final long myTraceId;
    private final Cpu.CpuTraceType myType;

    /*
     * WARNING - void declaration
     */
    public CpuCapture(@NotNull TraceParser parser, long traceId, Cpu.CpuTraceType cpuTraceType) {
        void type;
        if (parser == null) {
            CpuCapture.$$$reportNull$$$0(0);
        }
        this.myTimeline = new DefaultTimeline();
        this.myTraceId = traceId;
        this.myType = type;
        this.myTimeline.getDataRange().set(parser.getRange());
        this.myTimeline.getViewRange().set(parser.getRange());
        this.myCaptureSupportsDualClock = parser.supportsDualClock();
        this.myCaptureTrees = parser.getCaptureTrees();
        if (this.myCaptureTrees.isEmpty()) {
            throw new IllegalStateException("Trace file contained no CPU data.");
        }
        Map.Entry<CpuThreadInfo, CaptureNode> main = null;
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : this.myCaptureTrees.entrySet()) {
            if (entry.getKey().isMainThread()) {
                main = entry;
                break;
            }
            if (main != null && main.getValue().getDuration() >= entry.getValue().getDuration()) continue;
            main = entry;
        }
        this.myMainThreadId = ((CpuThreadInfo)main.getKey()).getId();
        CaptureNode mainNode = this.getCaptureNode(this.myMainThreadId);
        assert (mainNode != null);
        this.myClockType = mainNode.getClockType();
    }

    public int getMainThreadId() {
        return this.myMainThreadId;
    }

    @NotNull
    public Timeline getTimeline() {
        Timeline timeline = this.myTimeline;
        if (timeline == null) {
            CpuCapture.$$$reportNull$$$0(1);
        }
        return timeline;
    }

    @NotNull
    public Range getRange() {
        Range range = this.myTimeline.getDataRange();
        if (range == null) {
            CpuCapture.$$$reportNull$$$0(2);
        }
        return range;
    }

    @Nullable
    public CaptureNode getCaptureNode(int threadId) {
        return this.myCaptureTrees.entrySet().stream().filter(e -> ((CpuThreadInfo)e.getKey()).getId() == threadId).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @NotNull
    Set<CpuThreadInfo> getThreads() {
        Set<CpuThreadInfo> set = this.myCaptureTrees.keySet();
        if (set == null) {
            CpuCapture.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Collection<CaptureNode> getCaptureNodes() {
        Collection<CaptureNode> collection = this.myCaptureTrees.values();
        if (collection == null) {
            CpuCapture.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public boolean containsThread(int threadId) {
        return this.getCaptureNode(threadId) != null;
    }

    public long getDurationUs() {
        return (long)this.getRange().getLength();
    }

    public boolean getSelectableWhenMaxDuration() {
        return false;
    }

    public long getTraceId() {
        return this.myTraceId;
    }

    public boolean canSelectPartialRange() {
        return true;
    }

    public void updateClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuCapture.$$$reportNull$$$0(5);
        }
        if (this.myClockType == clockType) {
            return;
        }
        this.myClockType = clockType;
        for (CaptureNode tree : this.getCaptureNodes()) {
            CpuCapture.updateClockType(tree, clockType);
        }
    }

    private static void updateClockType(@Nullable CaptureNode node, @NotNull ClockType clockType) {
        if (clockType == null) {
            CpuCapture.$$$reportNull$$$0(6);
        }
        if (node == null) {
            return;
        }
        node.setClockType(clockType);
        for (CaptureNode child : node.getChildren()) {
            CpuCapture.updateClockType(child, clockType);
        }
    }

    public boolean isDualClock() {
        return this.myCaptureSupportsDualClock;
    }

    public Cpu.CpuTraceType getType() {
        return this.myType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCapture";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCapture";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateClockType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

