/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.energy;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.energy.PowerProfile;
import com.android.tools.datastore.poller.EnergyDataPoller;
import com.android.tools.profiler.proto.Cpu;
import com.google.common.primitives.Doubles;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class CpuConfig {
    @NotNull
    private final LogService myLogService;
    private final int[] myCpuCoreMinFreqInKhz;
    private final int[] myCpuCoreMaxFreqInKhz;
    private final int myBigCoreMaxFrequency;
    private final boolean myIsMinMaxCoreFreqValid;

    public CpuConfig(Cpu.CpuCoreConfigData cpuCoreConfigData, @NotNull LogService logService) {
        boolean isValidCpuCoreConfig;
        if (logService == null) {
            CpuConfig.$$$reportNull$$$0(0);
        }
        int coreConfigCount = cpuCoreConfigData.getCoreConfigsCount();
        this.myCpuCoreMinFreqInKhz = new int[coreConfigCount];
        this.myCpuCoreMaxFreqInKhz = new int[coreConfigCount];
        this.myLogService = logService;
        boolean[] myIsCpuCorePopulated = new boolean[coreConfigCount];
        boolean bl = isValidCpuCoreConfig = coreConfigCount > 0;
        if (isValidCpuCoreConfig) {
            for (Cpu.CpuCoreConfig config : cpuCoreConfigData.getCoreConfigsList()) {
                int core = config.getCore();
                if (core >= coreConfigCount || myIsCpuCorePopulated[core]) {
                    this.getLogger().debug(core > coreConfigCount ? String.format(Locale.US, "Core index %d is >= the number of configs (%d) reported.", core, coreConfigCount) : "Core index already populated.");
                    isValidCpuCoreConfig = false;
                    break;
                }
                myIsCpuCorePopulated[core] = true;
                int minFreq = config.getMinFrequencyInKhz();
                int maxFreq = config.getMaxFrequencyInKhz();
                if (minFreq <= 0 || minFreq >= maxFreq) {
                    this.getLogger().debug(minFreq <= 0 ? String.format(Locale.US, "Min frequency %d <= 0.", minFreq) : String.format(Locale.US, "Min frequency %d >= max frequency of %d.", minFreq, maxFreq));
                    isValidCpuCoreConfig = false;
                    break;
                }
                this.myCpuCoreMinFreqInKhz[core] = minFreq;
                this.myCpuCoreMaxFreqInKhz[core] = maxFreq;
            }
            this.myIsMinMaxCoreFreqValid = isValidCpuCoreConfig;
            if (this.myIsMinMaxCoreFreqValid) {
                int maxFrequency = 0;
                for (int coreMax : this.myCpuCoreMaxFreqInKhz) {
                    if (coreMax <= maxFrequency) continue;
                    maxFrequency = coreMax;
                }
                this.myBigCoreMaxFrequency = maxFrequency;
            } else {
                this.myBigCoreMaxFrequency = 0;
            }
        } else {
            this.getLogger().debug("No valid configs found!");
            this.myIsMinMaxCoreFreqValid = false;
            this.myBigCoreMaxFrequency = 0;
        }
    }

    @NotNull
    public PowerProfile.CpuCoreUsage[] getCpuCoreUsages(@NotNull Cpu.CpuUsageData prevUsageData, Cpu.CpuUsageData currUsageData) {
        int coreCount;
        if (prevUsageData == null) {
            CpuConfig.$$$reportNull$$$0(1);
        }
        if ((coreCount = currUsageData.getCoresCount()) != prevUsageData.getCoresCount()) {
            this.getLogger().info(String.format(Locale.US, "CPU config changing from %d to %d cores.", prevUsageData.getCoresCount(), coreCount));
            return new PowerProfile.CpuCoreUsage[0];
        }
        PowerProfile.CpuCoreUsage[] cpuCoresUtilization = new PowerProfile.CpuCoreUsage[coreCount];
        if (this.myIsMinMaxCoreFreqValid) {
            double system = currUsageData.getSystemCpuTimeInMillisec() - prevUsageData.getSystemCpuTimeInMillisec();
            double appSystemRatio = (double)(currUsageData.getAppCpuTimeInMillisec() - prevUsageData.getAppCpuTimeInMillisec()) / system;
            List coresUsageData = currUsageData.getCoresList();
            List prevCoresUsageData = prevUsageData.getCoresList();
            for (int i = 0; i < coreCount; ++i) {
                Cpu.CpuCoreUsageData currCore = (Cpu.CpuCoreUsageData)coresUsageData.get(i);
                Cpu.CpuCoreUsageData prevCore = (Cpu.CpuCoreUsageData)prevCoresUsageData.get(i);
                assert (i < this.myCpuCoreMinFreqInKhz.length);
                int minFreqKhz = this.myCpuCoreMinFreqInKhz[i];
                int maxFreqKhz = this.myCpuCoreMaxFreqInKhz[i];
                double elapsedCore = currCore.getElapsedTimeInMillisec() - prevCore.getElapsedTimeInMillisec();
                double corePercent = (double)(currCore.getSystemCpuTimeInMillisec() - prevCore.getSystemCpuTimeInMillisec()) / elapsedCore;
                cpuCoresUtilization[i] = new PowerProfile.CpuCoreUsage(currCore.getCore(), appSystemRatio, corePercent, minFreqKhz, maxFreqKhz, currCore.getFrequencyInKhz(), currCore.getFrequencyInKhz() != this.myBigCoreMaxFrequency);
            }
        } else {
            double elapsed = currUsageData.getElapsedTimeInMillisec() - prevUsageData.getElapsedTimeInMillisec();
            double appElapsedRatio = (double)(currUsageData.getAppCpuTimeInMillisec() - prevUsageData.getAppCpuTimeInMillisec()) / elapsed;
            double normalizedCoreShares = appElapsedRatio * (double)coreCount;
            for (int i = 0; i < coreCount; ++i) {
                cpuCoresUtilization[i] = new PowerProfile.CpuCoreUsage(i, Doubles.constrainToRange((double)normalizedCoreShares, (double)0.0, (double)1.0), 1.0, 0, 1, 1, false);
                normalizedCoreShares -= 1.0;
            }
        }
        if (cpuCoresUtilization == null) {
            CpuConfig.$$$reportNull$$$0(2);
        }
        return cpuCoresUtilization;
    }

    public boolean getIsMinMaxCoreFreqValid() {
        return this.myIsMinMaxCoreFreqValid;
    }

    @NotNull
    private LogService.Logger getLogger() {
        LogService.Logger logger = this.myLogService.getLogger(EnergyDataPoller.class);
        if (logger == null) {
            CpuConfig.$$$reportNull$$$0(3);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevUsageData";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/energy/CpuConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/energy/CpuConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuCoreUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCpuCoreUsages";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

