/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EventsTable
extends DataStoreTable<EventStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            EventsTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Events_Activity", "Id INTEGER NOT NULL", "Session INTEGER NOT NULL", "Data BLOB");
            this.createTable("Events_System", "Id INTEGER NOT NULL", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "Data BLOB");
            this.createUniqueIndex("Events_Activity", "Id", "Session");
            this.createUniqueIndex("Events_System", "Id", "Session");
        }
        catch (SQLException ex) {
            EventsTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(EventStatements.FIND_ACTIVITY, "SELECT Data from Events_Activity WHERE Id = ? AND Session = ?");
            this.createStatement(EventStatements.INSERT_ACTIVITY, "INSERT OR REPLACE INTO Events_Activity (Id, Session, Data) values (?, ?, ?)");
            this.createStatement(EventStatements.INSERT_SYSTEM, "INSERT OR REPLACE INTO Events_System (Id, Session, StartTime, EndTime, Data) values ( ?, ?, ?, ?, ?)");
            this.createStatement(EventStatements.QUERY_SYSTEM, "SELECT Data from Events_System WHERE Session = ? AND (EndTime >= ? OR EndTime = 0) AND StartTime < ?;");
            this.createStatement(EventStatements.QUERY_ACTIVITY, "SELECT Data from Events_Activity WHERE Session = ?");
        }
        catch (SQLException ex) {
            EventsTable.onError(ex);
        }
    }

    public EventProfiler.ActivityData findActivityDataOrNull(Common.Session session, long id) {
        try {
            ResultSet results = this.executeQuery(EventStatements.FIND_ACTIVITY, id, session.getSessionId());
            List<EventProfiler.ActivityData> datas = EventsTable.getActivityDataFromResultSet(results);
            if (!datas.isEmpty()) {
                return datas.get(0);
            }
        }
        catch (SQLException ex) {
            EventsTable.onError(ex);
        }
        return null;
    }

    public void insertOrReplace(long id, Common.Session session, EventProfiler.ActivityData activity) {
        this.execute(EventStatements.INSERT_ACTIVITY, id, session.getSessionId(), activity.toByteArray());
    }

    public List<EventProfiler.ActivityData> getActivityDataBySession(Common.Session session) {
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_ACTIVITY, session.getSessionId());
            return EventsTable.getActivityDataFromResultSet(results);
        }
        catch (SQLException ex) {
            EventsTable.onError(ex);
            return new ArrayList<EventProfiler.ActivityData>();
        }
    }

    public void insertOrReplace(long id, Common.Session session, EventProfiler.SystemData activity) {
        this.execute(EventStatements.INSERT_SYSTEM, id, session.getSessionId(), activity.getStartTimestamp(), activity.getEndTimestamp(), activity.toByteArray());
    }

    public List<EventProfiler.SystemData> getSystemDataByRequest(EventProfiler.EventDataRequest request) {
        ArrayList<EventProfiler.SystemData> events = new ArrayList<EventProfiler.SystemData>();
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_SYSTEM, request.getSession().getSessionId(), request.getStartTimestamp(), request.getEndTimestamp());
            while (results.next()) {
                EventProfiler.SystemData.Builder data = EventProfiler.SystemData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                events.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            EventsTable.onError(ex);
        }
        return events;
    }

    private static List<EventProfiler.ActivityData> getActivityDataFromResultSet(ResultSet results) {
        ArrayList<EventProfiler.ActivityData> activities = new ArrayList<EventProfiler.ActivityData>();
        try {
            while (results.next()) {
                EventProfiler.ActivityData.Builder data = EventProfiler.ActivityData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                activities.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            EventsTable.onError(ex);
        }
        return activities;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/android/tools/datastore/database/EventsTable", "initialize"));
    }

    public static enum EventStatements {
        FIND_ACTIVITY,
        INSERT_ACTIVITY,
        INSERT_SYSTEM,
        QUERY_SYSTEM,
        QUERY_ACTIVITY;

    }
}

