/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class DeviceProcessTable
extends DataStoreTable<Statements> {
    @Override
    public void prepareStatements() {
        try {
            for (Statements statement : Statements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            DeviceProcessTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("DevicesTable", "DeviceId INTEGER", "Data BLOB");
            this.createTable("ProcessesTable", "DeviceId INTEGER", "ProcessId INTEGER", "Name STRING NOT NULL", "State INTEGER", "StartTime INTEGER", "Arch STRING NOT NULL", "AgentStatus INTEGER");
            this.createUniqueIndex("DevicesTable", "DeviceId");
            this.createUniqueIndex("ProcessesTable", "DeviceId", "ProcessId");
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
    }

    @NotNull
    public Transport.GetDevicesResponse getDevices() {
        if (this.isClosed()) {
            Transport.GetDevicesResponse getDevicesResponse = Transport.GetDevicesResponse.getDefaultInstance();
            if (getDevicesResponse == null) {
                DeviceProcessTable.$$$reportNull$$$0(1);
            }
            return getDevicesResponse;
        }
        Transport.GetDevicesResponse.Builder responseBuilder = Transport.GetDevicesResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(Statements.SELECT_DEVICE, new Object[0]);
            while (results.next()) {
                responseBuilder.addDevice(Common.Device.parseFrom((byte[])results.getBytes(1)));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
        Transport.GetDevicesResponse getDevicesResponse = responseBuilder.build();
        if (getDevicesResponse == null) {
            DeviceProcessTable.$$$reportNull$$$0(2);
        }
        return getDevicesResponse;
    }

    @NotNull
    public Transport.GetProcessesResponse getProcesses(@NotNull Transport.GetProcessesRequest request) {
        if (request == null) {
            DeviceProcessTable.$$$reportNull$$$0(3);
        }
        if (this.isClosed()) {
            Transport.GetProcessesResponse getProcessesResponse = Transport.GetProcessesResponse.getDefaultInstance();
            if (getProcessesResponse == null) {
                DeviceProcessTable.$$$reportNull$$$0(4);
            }
            return getProcessesResponse;
        }
        Transport.GetProcessesResponse.Builder responseBuilder = Transport.GetProcessesResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(Statements.SELECT_PROCESSES, request.getDeviceId());
            while (results.next()) {
                long deviceId = results.getLong(1);
                int pid = results.getInt(2);
                String name = results.getString(3);
                int state = results.getInt(4);
                long startTimeNs = results.getLong(5);
                String arch = results.getString(6);
                Common.Process process = Common.Process.newBuilder().setDeviceId(deviceId).setPid(pid).setName(name).setState(Common.Process.State.forNumber((int)state)).setStartTimestampNs(startTimeNs).setAbiCpuArch(arch).build();
                responseBuilder.addProcess(process);
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
        Transport.GetProcessesResponse getProcessesResponse = responseBuilder.build();
        if (getProcessesResponse == null) {
            DeviceProcessTable.$$$reportNull$$$0(5);
        }
        return getProcessesResponse;
    }

    public void insertOrUpdateDevice(@NotNull Common.Device device) {
        if (device == null) {
            DeviceProcessTable.$$$reportNull$$$0(6);
        }
        this.execute(Statements.INSERT_DEVICE, device.getDeviceId(), device.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public void insertOrUpdateProcess(@NotNull long deviceId, @NotNull Common.Process process) {
        if (process == null) {
            DeviceProcessTable.$$$reportNull$$$0(7);
        }
        try {
            void process2;
            ResultSet results = this.executeQuery(Statements.SELECT_PROCESS_BY_ID, deviceId, process2.getPid());
            if (results.next()) {
                this.execute(Statements.UPDATE_PROCESS_STATE, process2.getStateValue(), deviceId, process2.getPid());
            } else {
                this.execute(Statements.INSERT_PROCESS, deviceId, process2.getPid(), process2.getName(), process2.getStateValue(), process2.getStartTimestampNs(), process2.getAbiCpuArch());
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateAgentStatus(@NotNull long devicId, @NotNull Common.Process process, @NotNull Common.AgentData agentData) {
        if (process == null) {
            DeviceProcessTable.$$$reportNull$$$0(8);
        }
        if (agentData == null) {
            DeviceProcessTable.$$$reportNull$$$0(9);
        }
        try {
            ResultSet results = this.executeQuery(Statements.FIND_AGENT_STATUS, devicId, process.getPid());
            if (results.next()) {
                void agentData2;
                this.execute(Statements.UPDATE_AGENT_STATUS, agentData2.getStatus().ordinal(), devicId, process.getPid());
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
    }

    @NotNull
    public Common.AgentData getAgentStatus(@NotNull Transport.AgentStatusRequest request) {
        if (request == null) {
            DeviceProcessTable.$$$reportNull$$$0(10);
        }
        Common.AgentData.Builder responseBuilder = Common.AgentData.newBuilder();
        try {
            ResultSet results = this.executeQuery(Statements.FIND_AGENT_STATUS, request.getDeviceId(), request.getPid());
            if (results.next()) {
                responseBuilder.setStatusValue(results.getInt(1));
            }
        }
        catch (SQLException ex) {
            DeviceProcessTable.onError(ex);
        }
        Common.AgentData agentData = responseBuilder.build();
        if (agentData == null) {
            DeviceProcessTable.$$$reportNull$$$0(11);
        }
        return agentData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/DeviceProcessTable";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/DeviceProcessTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcesses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProcesses";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateDevice";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertOrUpdateProcess";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateAgentStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAgentStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Statements {
        INSERT_DEVICE("INSERT OR REPLACE INTO [DevicesTable] (DeviceId, Data) values (?, ?)"),
        INSERT_PROCESS("INSERT OR REPLACE INTO [ProcessesTable] (DeviceId, ProcessId, Name, State, StartTime, Arch) values (?, ?, ?, ?, ?, ?)"),
        UPDATE_PROCESS_STATE("UPDATE [ProcessesTable] Set State = ? WHERE DeviceId = ? AND ProcessId = ?"),
        SELECT_PROCESSES("SELECT DeviceId, ProcessId, Name, State, StartTime, Arch from [ProcessesTable] WHERE DeviceId = ?"),
        SELECT_PROCESS_BY_ID("SELECT ProcessId from [ProcessesTable] WHERE DeviceId = ? AND ProcessId = ?"),
        SELECT_DEVICE("SELECT Data from [DevicesTable]"),
        FIND_AGENT_STATUS("SELECT AgentStatus from [ProcessesTable] WHERE DeviceId = ? AND ProcessId = ?"),
        UPDATE_AGENT_STATUS("UPDATE [ProcessesTable] SET AgentStatus = ? WHERE DeviceId = ? AND ProcessId = ?");

        @NotNull
        private final String mySqlStatement;

        private Statements(String sqlStatement) {
            if (sqlStatement == null) {
                Statements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                Statements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/DeviceProcessTable$Statements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/DeviceProcessTable$Statements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

