/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.EmptyResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class DataStoreTable<T extends Enum> {
    private static final Set<DataStoreTableErrorCallback> ERROR_CALLBACKS = ConcurrentHashMap.newKeySet();
    private Connection myConnection;
    private final ThreadLocal<Map<T, PreparedStatement>> myStatementMap = new ThreadLocal();
    private final ThreadLocal<Map<String, PreparedStatement>> myCustomQueryCache = new ThreadLocal();

    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            DataStoreTable.$$$reportNull$$$0(0);
        }
        this.myConnection = connection;
    }

    public abstract void prepareStatements();

    public static void addDataStoreErrorCallback(@NotNull DataStoreTableErrorCallback callback) {
        if (callback == null) {
            DataStoreTable.$$$reportNull$$$0(1);
        }
        ERROR_CALLBACKS.add(callback);
    }

    public static void removeDataStoreErrorCallback(@NotNull DataStoreTableErrorCallback callback) {
        if (callback == null) {
            DataStoreTable.$$$reportNull$$$0(2);
        }
        ERROR_CALLBACKS.remove(callback);
    }

    public boolean isClosed() {
        try {
            return this.myConnection.isClosed();
        }
        catch (SQLException ex) {
            return true;
        }
    }

    protected static void onError(Throwable t) {
        for (DataStoreTableErrorCallback callback : ERROR_CALLBACKS) {
            callback.onDataStoreError(t);
        }
    }

    @NotNull
    protected Map<T, PreparedStatement> getStatementMap() {
        if (this.myStatementMap.get() == null) {
            this.myStatementMap.set(new HashMap());
            this.prepareStatements();
        }
        Map<T, PreparedStatement> map = this.myStatementMap.get();
        if (map == null) {
            DataStoreTable.$$$reportNull$$$0(3);
        }
        return map;
    }

    protected void createTable(@NotNull String table, String ... columns) throws SQLException {
        if (table == null) {
            DataStoreTable.$$$reportNull$$$0(4);
        }
        this.myConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s ", table));
        StringBuilder statement = new StringBuilder();
        statement.append(String.format("CREATE TABLE %s", table));
        this.executeUniqueStatement(statement, columns);
    }

    protected void createUniqueIndex(@NotNull String table, String ... indexList) throws SQLException {
        if (table == null) {
            DataStoreTable.$$$reportNull$$$0(5);
        }
        StringBuilder statement = new StringBuilder();
        statement.append(String.format("CREATE UNIQUE INDEX IF NOT EXISTS idx_%s_pk ON %s", table, table));
        this.executeUniqueStatement(statement, indexList);
    }

    protected void createIndex(@NotNull String table, int indexId, String ... indexList) throws SQLException {
        if (table == null) {
            DataStoreTable.$$$reportNull$$$0(6);
        }
        StringBuilder statement = new StringBuilder();
        statement.append(String.format(Locale.US, "CREATE INDEX IF NOT EXISTS idx_%s_%d_pk ON %s", table, indexId, table));
        this.executeUniqueStatement(statement, indexList);
    }

    private void executeUniqueStatement(@NotNull StringBuilder statement, @NotNull String[] params) throws SQLException {
        if (statement == null) {
            DataStoreTable.$$$reportNull$$$0(7);
        }
        if (params == null) {
            DataStoreTable.$$$reportNull$$$0(8);
        }
        this.myConnection.createStatement().execute(String.format("%s ( %s )", statement, String.join((CharSequence)",", params)));
    }

    protected void createStatement(@NotNull T statement, @NotNull String stmt) throws SQLException {
        if (statement == null) {
            DataStoreTable.$$$reportNull$$$0(9);
        }
        if (stmt == null) {
            DataStoreTable.$$$reportNull$$$0(10);
        }
        this.getStatementMap().put(statement, this.myConnection.prepareStatement(stmt));
    }

    protected void createStatement(@NotNull T statement, @NotNull String stmt, int statementFlags) throws SQLException {
        if (statement == null) {
            DataStoreTable.$$$reportNull$$$0(11);
        }
        if (stmt == null) {
            DataStoreTable.$$$reportNull$$$0(12);
        }
        this.getStatementMap().put(statement, this.myConnection.prepareStatement(stmt, statementFlags));
    }

    protected <K> void executeBatch(@NotNull T statement, @NotNull List<K> batchParams, @NotNull Function<K, Object[]> paramConverter) {
        if (statement == null) {
            DataStoreTable.$$$reportNull$$$0(13);
        }
        if (batchParams == null) {
            DataStoreTable.$$$reportNull$$$0(14);
        }
        if (paramConverter == null) {
            DataStoreTable.$$$reportNull$$$0(15);
        }
        if (this.isClosed()) {
            return;
        }
        try {
            PreparedStatement stmt = this.getStatementMap().get(statement);
            batchParams.forEach(object -> {
                try {
                    this.applyParams(stmt, (Object[])paramConverter.apply(object));
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    DataStoreTable.onError(ex);
                }
            });
            int[] results = stmt.executeBatch();
            for (int i = 0; i < results.length; ++i) {
                if (results[i] != -3) continue;
                throw new SQLException(String.format("Failed to insert batch element %d with result %d", i, results[i]));
            }
        }
        catch (SQLException ex) {
            DataStoreTable.onError(ex);
        }
    }

    protected void execute(@NotNull T statement, Object ... params) {
        if (statement == null) {
            DataStoreTable.$$$reportNull$$$0(16);
        }
        if (this.isClosed()) {
            return;
        }
        try {
            PreparedStatement stmt = this.getStatementMap().get(statement);
            this.applyParams(stmt, params);
            stmt.execute();
            stmt.clearParameters();
        }
        catch (SQLException ex) {
            DataStoreTable.onError(ex);
        }
    }

    protected ResultSet executeQuery(@NotNull T statement, Object ... params) throws SQLException {
        if (statement == null) {
            DataStoreTable.$$$reportNull$$$0(17);
        }
        if (this.isClosed()) {
            return new EmptyResultSet();
        }
        PreparedStatement stmt = this.getStatementMap().get(statement);
        this.applyParams(stmt, params);
        return stmt.executeQuery();
    }

    protected ResultSet executeOneTimeQuery(@NotNull String sql, Object[] params) throws SQLException {
        Map<String, PreparedStatement> queryCache;
        if (sql == null) {
            DataStoreTable.$$$reportNull$$$0(18);
        }
        if (this.isClosed()) {
            return new EmptyResultSet();
        }
        if (this.myCustomQueryCache.get() == null) {
            this.myCustomQueryCache.set(new HashMap());
        }
        if (!(queryCache = this.myCustomQueryCache.get()).containsKey(sql)) {
            queryCache.put(sql, this.myConnection.prepareStatement(sql));
        }
        PreparedStatement statement = queryCache.get(sql);
        this.applyParams(statement, params);
        return statement.executeQuery();
    }

    protected void applyParams(@NotNull PreparedStatement statement, Object ... params) throws SQLException {
        if (statement == null) {
            DataStoreTable.$$$reportNull$$$0(19);
        }
        for (int i = 0; params != null && i < params.length; ++i) {
            if (params[i] == null) continue;
            if (params[i] instanceof String) {
                statement.setString(i + 1, (String)params[i]);
                continue;
            }
            if (params[i] instanceof Integer) {
                statement.setLong(i + 1, ((Integer)params[i]).intValue());
                continue;
            }
            if (params[i] instanceof Long) {
                statement.setLong(i + 1, (Long)params[i]);
                continue;
            }
            if (params[i] instanceof byte[]) {
                statement.setBytes(i + 1, (byte[])params[i]);
                continue;
            }
            if (params[i] instanceof Boolean) {
                statement.setBoolean(i + 1, (Boolean)params[i]);
                continue;
            }
            assert (false) : "No DataStoreTable support for arguments of type: " + params[i].getClass();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/DataStoreTable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "batchParams";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramConverter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/DataStoreTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDataStoreErrorCallback";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeDataStoreErrorCallback";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeUniqueStatement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createStatement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeBatch";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeQuery";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "executeOneTimeQuery";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "applyParams";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DataStoreTableErrorCallback {
        public void onDataStoreError(Throwable var1);
    }
}

