/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.model.bootstrap;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.spring.boot.cloud.SpringCloudBundle;
import com.intellij.spring.boot.cloud.library.SpringCloudLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.beans.CustomSetting;
import icons.SpringBootCloudIcons;

class SpringBootBootstrapConfigFileNameContributor
extends SpringBootModelConfigFileNameContributor {
    private static final Key<CustomSetting.STRING> SPRING_CLOUD_BOOTSTRAP_CONFIG_NAME_CUSTOM_SETTING_ID = Key.create((String)"spring_cloud_bootstrap_config_name");
    private static final Key<CustomSetting.STRING> SPRING_CLOUD_BOOTSTRAP_CONFIG_CUSTOM_FILES_ID = Key.create((String)"spring_cloud_bootstrap_config_custom_files");
    private static final String CONFIG_FILE_KEY = "spring.cloud.bootstrap.name";
    private static final String BOOTSTRAP_CONFIG_NAME_DEFAULT = "bootstrap";

    SpringBootBootstrapConfigFileNameContributor() {
        super(new SpringBootModelConfigFileNameContributor.CustomSettingDescriptor(SPRING_CLOUD_BOOTSTRAP_CONFIG_NAME_CUSTOM_SETTING_ID, SpringCloudBundle.message("spring.cloud.config.files.name.setting", CONFIG_FILE_KEY), BOOTSTRAP_CONFIG_NAME_DEFAULT), new SpringBootModelConfigFileNameContributor.CustomSettingDescriptor(SPRING_CLOUD_BOOTSTRAP_CONFIG_CUSTOM_FILES_ID, SpringCloudBundle.message("spring.cloud.custom.config.files.locations", new Object[0]), ""), new SpringBootModelConfigFileNameContributor.CustomizationPresentation(CONFIG_FILE_KEY, SpringCloudBundle.message("spring.cloud.config.files.section.title", new Object[0])), SpringBootCloudIcons.SpringCloud);
    }

    public boolean accept(SpringFileSet fileSet) {
        return fileSet.isAutodetected() && fileSet.getId().startsWith("bootstrap_");
    }

    public boolean accept(Module module) {
        return SpringCloudLibraryUtil.hasSpringCloudCommons(module);
    }
}

