/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.amazon;

import com.intellij.javaee.amazon.AmazonSqsResolver;
import com.intellij.javaee.jms.JmsMQUtils;
import com.intellij.microservices.mq.MQResolver;
import com.intellij.microservices.mq.MQResolverFactory;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.MQTypes;
import com.intellij.microservices.uast.callsites.ArgumentCallSiteCollector;
import com.intellij.microservices.uast.callsites.ArgumentPlace;
import com.intellij.microservices.uast.callsites.ConstructorArgument;
import com.intellij.microservices.uast.callsites.MethodArgument;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javaee/amazon/AmazonSqsResolver;", "Lcom/intellij/microservices/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "collector", "Lcom/intellij/microservices/uast/callsites/ArgumentCallSiteCollector;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/uast/callsites/ArgumentCallSiteCollector;)V", "supportedTypes", "", "Lcom/intellij/microservices/mq/MQType;", "getSupportedTypes", "()Ljava/util/List;", "getVariants", "", "Lcom/intellij/microservices/mq/MQTargetInfo;", "typeHint", "Companion", "Factory", "intellij.javaee.extensions"})
public final class AmazonSqsResolver
implements MQResolver {
    @NotNull
    private final List<MQType> supportedTypes;
    private final Project project;
    private final ArgumentCallSiteCollector collector;
    private static final ArgumentCallSiteCollector AMAZON_SQS_QUEUE_OPERATIONS;
    public static final Companion Companion;

    @NotNull
    public List<MQType> getSupportedTypes() {
        return this.supportedTypes;
    }

    @NotNull
    public Iterable<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)this.collector.getCallSitesSequence(this.project), (Function1)getVariants.1.INSTANCE));
    }

    public AmazonSqsResolver(@NotNull Project project, @NotNull ArgumentCallSiteCollector collector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        this.project = project;
        this.collector = collector;
        this.supportedTypes = CollectionsKt.listOf((Object)MQTypes.AMAZON_SQS_QUEUE_TYPE);
    }

    static {
        Companion = new Companion(null);
        AMAZON_SQS_QUEUE_OPERATIONS = new ArgumentCallSiteCollector("AMAZON_SQS_QUEUE_OPERATIONS", CollectionsKt.listOf((Object[])new ArgumentPlace[]{(ArgumentPlace)new ConstructorArgument("com.amazonaws.services.sqs.model.GetQueueUrlRequest", 0, 1, null, 8, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.model.GetQueueUrlRequest", CollectionsKt.listOf((Object[])new String[]{"setQueueName", "withQueueName"}), 0, 1, null, 16, null), (ArgumentPlace)new ConstructorArgument("com.amazonaws.auth.policy.resources.SQSQueueResource", 1, 2, null, 8, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.securityhub.model.AwsSqsQueueDetails", CollectionsKt.listOf((Object[])new String[]{"setQueueName", "withQueueName"}), 0, 1, null, 16, null), (ArgumentPlace)new ConstructorArgument("com.amazonaws.services.sqs.model.CreateQueueRequest", 0, 1, null, 8, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.model.CreateQueueRequest", CollectionsKt.listOf((Object[])new String[]{"setQueueName", "withQueueName"}), 0, 1, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AbstractAmazonSQSAsync", CollectionsKt.listOf((Object)"createQueueAsync"), 0, 1, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AbstractAmazonSQSAsync", CollectionsKt.listOf((Object)"createQueueAsync"), 0, 2, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AmazonSQSAsyncClient", CollectionsKt.listOf((Object)"createQueueAsync"), 0, 1, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AmazonSQSAsyncClient", CollectionsKt.listOf((Object)"createQueueAsync"), 0, 2, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AmazonSQSAsync", CollectionsKt.listOf((Object[])new String[]{"createQueueAsync", "getQueueUrlAsync"}), 0, 1, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AmazonSQSAsync", CollectionsKt.listOf((Object[])new String[]{"createQueueAsync", "getQueueUrlAsync"}), 0, 2, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AmazonSQSClient", CollectionsKt.listOf((Object[])new String[]{"createQueue", "getQueueUrl"}), 0, 1, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AmazonSQS", CollectionsKt.listOf((Object[])new String[]{"createQueue", "getQueueUrl"}), 0, 1, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.AbstractAmazonSQS", CollectionsKt.listOf((Object[])new String[]{"createQueue", "getQueueUrl"}), 0, 1, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient", CollectionsKt.listOf((Object[])new String[]{"createQueue", "createQueueAsync", "getQueueUrl", "getQueueUrlAsync"}), 0, 1, null, 16, null), (ArgumentPlace)new MethodArgument("com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient", CollectionsKt.listOf((Object[])new String[]{"createQueueAsync", "getQueueUrlAsync"}), 0, 2, null, 16, null)}), null, 4, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/javaee/amazon/AmazonSqsResolver$Factory;", "Lcom/intellij/microservices/mq/MQResolverFactory;", "()V", "forProject", "", "Lcom/intellij/microservices/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.extensions"})
    public static final class Factory
    implements MQResolverFactory {
        @NotNull
        public List<MQResolver> forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!JmsMQUtils.INSTANCE.isAmazonSqsAvailable(project)) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.listOf((Object)new AmazonSqsResolver(project, AMAZON_SQS_QUEUE_OPERATIONS));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/javaee/amazon/AmazonSqsResolver$Companion;", "", "()V", "AMAZON_SQS_QUEUE_OPERATIONS", "Lcom/intellij/microservices/uast/callsites/ArgumentCallSiteCollector;", "intellij.javaee.extensions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

