/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FUCounterUsageLogger {
    private static final int LOG_REGISTERED_DELAY_MIN = 1440;
    private static final int LOG_REGISTERED_INITIAL_DELAY_MIN = 5;
    private static final Logger LOG = Logger.getInstance(FUCounterUsageLogger.class);
    private static final FUCounterUsageLogger INSTANCE = new FUCounterUsageLogger();
    private final Map<String, EventLogGroup> myGroups = new HashMap<String, EventLogGroup>();

    @NotNull
    public static FUCounterUsageLogger getInstance() {
        FUCounterUsageLogger fUCounterUsageLogger = INSTANCE;
        if (fUCounterUsageLogger == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(0);
        }
        return fUCounterUsageLogger;
    }

    public FUCounterUsageLogger() {
        for (CounterUsageCollectorEP ep : CounterUsageCollectorEP.EP_NAME.getExtensionList()) {
            this.registerGroupFromEP(ep);
        }
        Extensions.getRootArea().getExtensionPoint(CounterUsageCollectorEP.EP_NAME).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CounterUsageCollectorEP>(){

            public void extensionAdded(@NotNull CounterUsageCollectorEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                FUCounterUsageLogger.this.registerGroupFromEP(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, null);
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.logRegisteredGroups(), 5L, 1440L, TimeUnit.MINUTES);
    }

    private void registerGroupFromEP(CounterUsageCollectorEP ep) {
        String id;
        if (ep.implementationClass == null && StringUtil.isNotEmpty((String)(id = ep.getGroupId()))) {
            this.register(new EventLogGroup(id, ep.version));
        }
    }

    public static List<FeatureUsagesCollector> instantiateCounterCollectors() {
        ArrayList<FeatureUsagesCollector> result = new ArrayList<FeatureUsagesCollector>();
        for (CounterUsageCollectorEP ep : (CounterUsageCollectorEP[])CounterUsageCollectorEP.EP_NAME.getExtensions()) {
            if (ep.implementationClass == null) continue;
            result.add((FeatureUsagesCollector)ep.instantiateClass(ep.implementationClass, ApplicationManager.getApplication().getPicoContainer()));
        }
        return result;
    }

    private void register(@NotNull EventLogGroup group) {
        if (group == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(1);
        }
        this.myGroups.put(group.getId(), group);
    }

    public void logRegisteredGroups() {
        for (EventLogGroup group : this.myGroups.values()) {
            FeatureUsageLogger.INSTANCE.log(group, "registered");
        }
        for (FeatureUsagesCollector collector : FUCounterUsageLogger.instantiateCounterCollectors()) {
            EventLogGroup group = collector.getGroup();
            if (group == null) continue;
            FeatureUsageLogger.INSTANCE.log(group, "registered");
        }
    }

    @Deprecated
    public void logEvent(@Nullable Project project, @NonNls @NotNull String groupId, @NonNls @NotNull String eventId) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(2);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(3);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            Map<String, Object> data = new FeatureUsageData().addProject(project).build();
            FeatureUsageLogger.INSTANCE.log(group, eventId, data);
        }
    }

    @Deprecated
    public void logEvent(@Nullable Project project, @NonNls @NotNull String groupId, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(4);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(5);
        }
        if (data == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(6);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.addProject(project).build());
        }
    }

    @Deprecated
    public void logEvent(@NonNls @NotNull String groupId, @NonNls @NotNull String eventId) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(7);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(8);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId);
        }
    }

    @Deprecated
    public void logEvent(@NonNls @NotNull String groupId, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(9);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(10);
        }
        if (data == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(11);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.build());
        }
    }

    @Nullable
    private EventLogGroup findRegisteredGroupById(@NotNull String groupId) {
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(12);
        }
        if (!this.myGroups.containsKey(groupId)) {
            LOG.error("Cannot record event because group '" + groupId + "' is not registered. To fix it add '<statistics.counterUsagesCollector groupId=\"" + groupId + "\" version=\"1\"/>' in plugin.xml");
            return null;
        }
        return this.myGroups.get(groupId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logEvent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredGroupById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

