/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.AccessorKind;
import org.jetbrains.kotlin.j2k.ClassKind;
import org.jetbrains.kotlin.j2k.ConstructorConverter;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.OverloadReducer;
import org.jetbrains.kotlin.j2k.PropertyInfo;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.ReferenceSearcherKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Class;
import org.jetbrains.kotlin.j2k.ast.ClassBody;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.LBrace;
import org.jetbrains.kotlin.j2k.ast.Member;
import org.jetbrains.kotlin.j2k.ast.PrimaryConstructor;
import org.jetbrains.kotlin.j2k.ast.PrimaryConstructorSignature;
import org.jetbrains.kotlin.j2k.ast.RBrace;
import org.jetbrains.kotlin.j2k.ast.SecondaryConstructor;
import org.jetbrains.kotlin.j2k.usageProcessing.AccessorToPropertyProcessing;
import org.jetbrains.kotlin.j2k.usageProcessing.MemberIntoObjectProcessing;
import org.jetbrains.kotlin.j2k.usageProcessing.ToObjectWithOnlyMethodsProcessing;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\f\u001a\u00020\rJ8\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/j2k/ClassBodyConverter;", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "classKind", "Lorg/jetbrains/kotlin/j2k/ClassKind;", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "(Lcom/intellij/psi/PsiClass;Lorg/jetbrains/kotlin/j2k/ClassKind;Lorg/jetbrains/kotlin/j2k/Converter;)V", "fieldsToDrop", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiField;", "convertBody", "Lorg/jetbrains/kotlin/j2k/ast/ClassBody;", "convertMember", "Lorg/jetbrains/kotlin/j2k/ast/Member;", "member", "Lcom/intellij/psi/PsiMember;", "constructorConverter", "Lorg/jetbrains/kotlin/j2k/ConstructorConverter;", "overloadReducer", "Lorg/jetbrains/kotlin/j2k/OverloadReducer;", "memberToPropertyInfo", "", "Lorg/jetbrains/kotlin/j2k/PropertyInfo;", "shouldGenerateCompanionObject", "", "convertedMembers", "kotlin.j2k.old"})
public final class ClassBodyConverter {
    private final HashSet<PsiField> fieldsToDrop;
    private final PsiClass psiClass;
    private final ClassKind classKind;
    private final Converter converter;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassBody convertBody() {
        Object it;
        void $this$filterTo$iv$iv;
        PsiMember memberToPropertyInfo;
        PsiMember psiMember = memberToPropertyInfo = this.converter.getPropertyDetectionCache().get(this.psiClass);
        boolean bl = false;
        Iterator<Map.Entry<PsiMember, PropertyInfo>> iterator = psiMember.entrySet().iterator();
        while (iterator.hasNext()) {
            void member;
            Map.Entry<PsiMember, PropertyInfo> entry;
            Map.Entry<PsiMember, PropertyInfo> entry2 = entry = iterator.next();
            boolean bl2 = false;
            psiMember = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            PropertyInfo propertyInfo = entry2.getValue();
            if (!(member instanceof PsiMethod)) continue;
            if (Intrinsics.areEqual((Object)member, (Object)propertyInfo.getGetMethod())) {
                this.converter.addUsageProcessing(new AccessorToPropertyProcessing((PsiMethod)member, AccessorKind.GETTER, propertyInfo.getName()));
                continue;
            }
            this.converter.addUsageProcessing(new AccessorToPropertyProcessing((PsiMethod)member, AccessorKind.SETTER, propertyInfo.getName()));
        }
        PsiMethod[] psiMethodArray = this.psiClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"psiClass.methods");
        PsiMethod[] $this$filter$iv = psiMethodArray;
        boolean $i$f$filter = false;
        PsiMethod[] propertyInfo = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            boolean bl3 = false;
            if (!(!memberToPropertyInfo.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        ReferenceSearcher referenceSearcher = this.converter.getReferenceSearcher();
        boolean bl4 = this.classKind.isOpen();
        Collection collection = list;
        OverloadReducer overloadReducer = new OverloadReducer(collection, bl4, referenceSearcher);
        ConstructorConverter constructorConverter2 = this.psiClass.getName() != null && !this.classKind.isObject() ? new ConstructorConverter(this.psiClass, this.converter, (Function1<? super PsiField, PropertyInfo>)((Function1)new Function1<PsiField, PropertyInfo>((Map)memberToPropertyInfo){
            final /* synthetic */ Map $memberToPropertyInfo;

            @NotNull
            public final PropertyInfo invoke(@NotNull PsiField field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                V v = this.$memberToPropertyInfo.get(field);
                Intrinsics.checkNotNull(v);
                return (PropertyInfo)v;
            }
            {
                this.$memberToPropertyInfo = map2;
                super(1);
            }
        }), overloadReducer) : null;
        LinkedHashMap<PsiElement, Member> convertedMembers = new LinkedHashMap<PsiElement, Member>();
        for (PsiElement element : this.psiClass.getChildren()) {
            Member converted;
            if (!(element instanceof PsiMember) || element instanceof PsiAnnotationMethod || this.classKind.isObject() && UtilsKt.isConstructor((PsiMember)element) || element instanceof PsiMethod && overloadReducer.shouldDropMethod((PsiMethod)element) || (converted = this.convertMember((PsiMember)element, constructorConverter2, overloadReducer, (Map<PsiMember, PropertyInfo>)memberToPropertyInfo)) == null) continue;
            convertedMembers.put(element, converted);
        }
        Iterable $this$forEach$iv = this.fieldsToDrop;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiField it2 = (PsiField)element$iv;
            boolean bl5 = false;
            convertedMembers.remove(it2);
        }
        LBrace lBrace = (LBrace)ElementKt.assignPrototype$default(new LBrace(), this.psiClass.getLBrace(), null, 2, null);
        RBrace rBrace = (RBrace)ElementKt.assignPrototype$default(new RBrace(), this.psiClass.getRBrace(), null, 2, null);
        if (this.classKind.isObject()) {
            boolean bl6;
            Set psiMembers;
            block21: {
                Set set = convertedMembers.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"convertedMembers.keys");
                psiMembers = set;
                Iterable $this$all$iv = psiMembers;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl6 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (PsiMember)element$iv;
                        boolean bl7 = false;
                        if (it instanceof PsiMethod) continue;
                        bl6 = false;
                        break block21;
                    }
                    bl6 = true;
                }
            }
            if (bl6) {
                this.converter.addUsageProcessing(new ToObjectWithOnlyMethodsProcessing(this.psiClass));
            } else {
                for (PsiMember psiMember2 : psiMembers) {
                    if (psiMember2.hasModifierProperty("private")) continue;
                    PsiMember psiMember3 = psiMember2;
                    Intrinsics.checkNotNullExpressionValue((Object)psiMember3, (String)"psiMember");
                    this.converter.addUsageProcessing(new MemberIntoObjectProcessing(psiMember3, "INSTANCE"));
                }
            }
            Collection collection2 = convertedMembers.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"convertedMembers.values");
            return new ClassBody(null, null, null, CollectionsKt.toList((Iterable)collection2), CollectionsKt.emptyList(), lBrace, rBrace, this.classKind);
        }
        boolean useCompanionObject = this.shouldGenerateCompanionObject((Map<PsiMember, ? extends Member>)convertedMembers);
        ArrayList<Member> members = new ArrayList<Member>();
        ArrayList<Member> companionObjectMembers = new ArrayList<Member>();
        PrimaryConstructorSignature primaryConstructorSignature = null;
        PrimaryConstructor primaryConstructor = null;
        Object object = convertedMembers;
        boolean bl8 = false;
        Iterator bl7 = object.entrySet().iterator();
        while (bl7.hasNext()) {
            void psiMember4;
            Object object2 = it = bl7.next();
            boolean bl9 = false;
            object = (PsiMember)object2.getKey();
            object2 = it;
            bl9 = false;
            Member member = (Member)object2.getValue();
            if (member instanceof PrimaryConstructor) {
                primaryConstructor = (PrimaryConstructor)member;
                boolean bl10 = primaryConstructorSignature == null;
                bl9 = false;
                boolean bl11 = false;
                if (_Assertions.ENABLED && !bl10) {
                    boolean bl12 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                primaryConstructorSignature = primaryConstructor.createSignature(this.converter);
                members.add(primaryConstructor.getInitializer());
                continue;
            }
            if (useCompanionObject && !(member instanceof Class) && !(psiMember4 instanceof PsiEnumConstant) && psiMember4.hasModifierProperty("static")) {
                companionObjectMembers.add(member);
                if (psiMember4.hasModifierProperty("private")) continue;
                Name name = SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT");
                String string = name.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpecialNames.DEFAULT_NAM\u2026MPANION_OBJECT.identifier");
                this.converter.addUsageProcessing(new MemberIntoObjectProcessing((PsiMember)psiMember4, string));
                continue;
            }
            members.add(member);
        }
        if (primaryConstructor != null && primaryConstructorSignature != null && this.classKind != ClassKind.ANONYMOUS_OBJECT && primaryConstructorSignature.getAnnotations().isEmpty() && primaryConstructorSignature.getAccessModifier() == null && primaryConstructorSignature.getParameterList().getParameters().isEmpty()) {
            boolean bl13;
            block22: {
                Iterable $this$none$iv = members;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl13 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Member it3 = (Member)element$iv;
                        boolean bl14 = false;
                        if (!(it3 instanceof SecondaryConstructor)) continue;
                        bl13 = false;
                        break block22;
                    }
                    bl13 = true;
                }
            }
            if (bl13) {
                primaryConstructorSignature = null;
            }
        }
        ConstructorConverter constructorConverter3 = constructorConverter2;
        return new ClassBody(primaryConstructor, primaryConstructorSignature, constructorConverter3 != null ? constructorConverter3.getBaseClassParams() : null, (List<? extends Member>)members, (List<? extends Member>)companionObjectMembers, lBrace, rBrace, this.classKind);
    }

    private final Member convertMember(PsiMember member, ConstructorConverter constructorConverter2, OverloadReducer overloadReducer, Map<PsiMember, PropertyInfo> memberToPropertyInfo) {
        PsiMember psiMember = member;
        if (psiMember instanceof PsiMethod) {
            PropertyInfo propertyInfo = memberToPropertyInfo.get(member);
            if (propertyInfo != null) {
                PropertyInfo propertyInfo2 = propertyInfo;
                boolean bl = false;
                boolean bl2 = false;
                PropertyInfo propertyInfo3 = propertyInfo2;
                boolean bl3 = false;
                if (propertyInfo3.getField() != null) {
                    return null;
                }
                return Intrinsics.areEqual((Object)member, (Object)propertyInfo3.getGetMethod()) || propertyInfo3.getGetMethod() == null ? this.converter.convertProperty(propertyInfo3, this.classKind) : null;
            }
            return this.converter.convertMethod((PsiMethod)member, (Set<PsiField>)this.fieldsToDrop, constructorConverter2, overloadReducer, this.classKind);
        }
        if (psiMember instanceof PsiField) {
            PropertyInfo propertyInfo = memberToPropertyInfo.get(member);
            Intrinsics.checkNotNull((Object)propertyInfo);
            PropertyInfo propertyInfo4 = propertyInfo;
            return this.converter.convertProperty(propertyInfo4, this.classKind);
        }
        if (psiMember instanceof PsiClass) {
            return this.converter.convertClass((PsiClass)member);
        }
        if (psiMember instanceof PsiClassInitializer) {
            return this.converter.convertInitializer((PsiClassInitializer)member);
        }
        throw (Throwable)new IllegalArgumentException("Unknown member: " + member);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldGenerateCompanionObject(Map<PsiMember, ? extends Member> convertedMembers) {
        boolean bl;
        block18: {
            boolean bl2;
            List nestedClasses;
            List companionObjectMembers;
            block16: {
                void $this$filterTo$iv$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                void $this$filterTo$iv$iv2;
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv = convertedMembers.keySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    PsiMember it = (PsiMember)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!UtilsKt.isConstructor(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List members = (List)destination$iv$iv;
                Iterable $this$filter$iv2 = members;
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    PsiMember it = (PsiMember)element$iv$iv;
                    boolean bl4 = false;
                    if (!(!(it instanceof PsiClass) && !(it instanceof PsiEnumConstant) && it.hasModifierProperty("static"))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                companionObjectMembers = (List)destination$iv$iv2;
                Iterable $this$filterIsInstance$iv = members;
                boolean $i$f$filterIsInstance = false;
                destination$iv$iv2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PsiClass)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                Iterable $this$filter$iv3 = (List)destination$iv$iv3;
                boolean $i$f$filter3 = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv3;
                destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PsiClass it = (PsiClass)element$iv$iv;
                    boolean bl5 = false;
                    if (!it.hasModifierProperty("static")) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                nestedClasses = (List)destination$iv$iv3;
                Iterable $this$all$iv = companionObjectMembers;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiMember it = (PsiMember)element$iv;
                        boolean bl6 = false;
                        if (it instanceof PsiMethod && it.hasModifierProperty("private")) continue;
                        bl2 = false;
                        break block16;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                Iterable $this$any$iv = nestedClasses;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl7;
                        block17: {
                            PsiClass nestedClass = (PsiClass)element$iv;
                            boolean bl8 = false;
                            Iterable $this$any$iv2 = companionObjectMembers;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl7 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    PsiMember it = (PsiMember)element$iv2;
                                    boolean bl9 = false;
                                    PsiMember psiMember = it;
                                    if (psiMember == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                                    }
                                    Collection<PsiMethodCallExpression> collection = ReferenceSearcherKt.findMethodCalls(this.converter.getReferenceSearcher(), (PsiMethod)psiMember, (PsiElement)nestedClass);
                                    boolean bl10 = false;
                                    if (!(!collection.isEmpty())) continue;
                                    bl7 = true;
                                    break block17;
                                }
                                bl7 = false;
                            }
                        }
                        if (!bl7) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public ClassBodyConverter(@NotNull PsiClass psiClass, @NotNull ClassKind classKind, @NotNull Converter converter) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)((Object)classKind), (String)"classKind");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.psiClass = psiClass;
        this.classKind = classKind;
        this.converter = converter;
        this.fieldsToDrop = new HashSet();
    }
}

