/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class ImportMavenProjectCommand
extends AbstractCommand {
    public static final String PREFIX = "%importMavenProject";
    private final Project myProject;

    public ImportMavenProjectCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(2);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        final MessageBusConnection appConnection = this.myProject.getMessageBus().connect();
        appConnection.subscribe(MavenImportListener.TOPIC, (Object)new MavenImportListener((ActionCallback)actionCallback){
            final /* synthetic */ ActionCallback val$actionCallback;
            {
                this.val$actionCallback = actionCallback;
            }

            public void importFinished(@NotNull Collection<MavenProject> importedProjects, @NotNull List<Module> newModules) {
                if (importedProjects == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newModules == null) {
                    1.$$$reportNull$$$0(1);
                }
                final MessageBusConnection projectConnection = ImportMavenProjectCommand.this.myProject.getMessageBus().connect();
                context.message("Import of maven project has been finished", ImportMavenProjectCommand.this.getLine());
                projectConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                    public void exitDumbMode() {
                        appConnection.disconnect();
                        projectConnection.disconnect();
                        context.message("Dumping mode after import has been finished", ImportMavenProjectCommand.this.getLine());
                        val$actionCallback.setDone();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "importedProjects";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newModules";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/performancePlugin/commands/ImportMavenProjectCommand$1";
                objectArray[2] = "importFinished";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> {
            MavenProjectsManager myProjectsManager = MavenProjectsManager.getInstance((Project)this.myProject);
            context.message("Import of the project has been started", this.getLine());
            myProjectsManager.forceUpdateAllProjectsOrFindAllAvailablePomFiles();
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(3);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/ImportMavenProjectCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/ImportMavenProjectCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

