/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.PatternBasedFileHyperlinkFilter;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserStacktraceFilters {
    public static final String PHANTOM_JS = "phantomjs";
    public static final String CHROME = "chrome";

    @Nullable
    public static AbstractFileHyperlinkFilter createFilter(@NotNull String browserName, @NotNull Project project, @Nullable String baseDir) {
        if (browserName == null) {
            BrowserStacktraceFilters.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BrowserStacktraceFilters.$$$reportNull$$$0(1);
        }
        if ((browserName = StringUtil.toLowerCase((String)browserName)).startsWith(CHROME) || browserName.startsWith("headlesschrome")) {
            return new ChromeStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("firefox")) {
            return new FirefoxStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("opera")) {
            return new ChromeStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith(PHANTOM_JS)) {
            return new PhantomStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("safari")) {
            return new PhantomStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("ie") || browserName.contains("internet explorer")) {
            return new IEStacktraceFilter(project, baseDir);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "browserName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters";
        objectArray[2] = "createFilter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PathSanitizerFilter
    extends PatternBasedFileHyperlinkFilter {
        private static final String WEBPACK_URL_PREFIX = "webpack:///";
        private static final String OLD_WEBPACK_URL_PREFIX = "webpack://";
        private static final String HTTP = "http://";
        private static final String HTTPS = "https://";
        private static final String ABSOLUTE = "/absolute/";
        private static final String[] COMMANDS = new String[]{"/base/", "/absolute/", "/_karma_webpack_/"};

        PathSanitizerFilter(@NotNull Project project, @Nullable String baseDir, @NotNull PatternBasedFileHyperlinkRawDataFinder finder) {
            if (project == null) {
                PathSanitizerFilter.$$$reportNull$$$0(0);
            }
            if (finder == null) {
                PathSanitizerFilter.$$$reportNull$$$0(1);
            }
            super(project, baseDir, finder);
        }

        @NotNull
        public List<FileHyperlinkRawData> parse(@NotNull String line) {
            if (line == null) {
                PathSanitizerFilter.$$$reportNull$$$0(2);
            }
            List parse = super.parse(line);
            ArrayList<FileHyperlinkRawData> result = new ArrayList<FileHyperlinkRawData>();
            for (FileHyperlinkRawData data : parse) {
                String normalizedFilePath = PathSanitizerFilter.normalizeLinkPrefix(data.getFilePath());
                result.add(new FileHyperlinkRawData(normalizedFilePath, data.getDocumentLine(), data.getDocumentColumn(), data.getHyperlinkStartInd(), data.getHyperlinkEndInd()));
            }
            ArrayList<FileHyperlinkRawData> arrayList = result;
            if (arrayList == null) {
                PathSanitizerFilter.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @NotNull
        private static String normalizeLinkPrefix(@NotNull String link) {
            int pathStartInd;
            if (link == null) {
                PathSanitizerFilter.$$$reportNull$$$0(4);
            }
            String webpackPrefix = null;
            if (((String)link).startsWith(WEBPACK_URL_PREFIX)) {
                webpackPrefix = WEBPACK_URL_PREFIX;
            } else if (((String)link).startsWith(OLD_WEBPACK_URL_PREFIX)) {
                webpackPrefix = OLD_WEBPACK_URL_PREFIX;
            }
            if (webpackPrefix != null) {
                if (((String)(link = ((String)link).substring(webpackPrefix.length()))).startsWith("~/")) {
                    link = "node_modules" + ((String)link).substring(1);
                }
            } else if ((((String)link).startsWith(HTTP) || ((String)link).startsWith(HTTPS)) && (pathStartInd = ((String)link).indexOf(47, HTTPS.length())) > 0) {
                String command = PathSanitizerFilter.findCommandStartingAt((String)link, pathStartInd);
                if (command != null) {
                    pathStartInd += command.length();
                    if (command.equals(ABSOLUTE)) {
                        --pathStartInd;
                    }
                } else {
                    ++pathStartInd;
                }
                link = ((String)link).substring(pathStartInd);
            }
            link = StringUtil.trimEnd((String)link, (String)"?");
            String string = link;
            if (string == null) {
                PathSanitizerFilter.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        private static String findCommandStartingAt(@NotNull String text, int startInd) {
            if (text == null) {
                PathSanitizerFilter.$$$reportNull$$$0(6);
            }
            for (String command : COMMANDS) {
                if (!StringUtil.startsWith((CharSequence)text, (int)startInd, (CharSequence)command)) continue;
                return command;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$PathSanitizerFilter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "link";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$PathSanitizerFilter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "normalizeLinkPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "normalizeLinkPrefix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findCommandStartingAt";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class IEStacktraceFilter
    extends PathSanitizerFilter {
        public static final PatternBasedFileHyperlinkRawDataFinder FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^\\s*at.*\\(([^)]*):(\\d+):(\\d+)\\)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        public IEStacktraceFilter(@NotNull Project project, @Nullable String baseDir) {
            if (project == null) {
                IEStacktraceFilter.$$$reportNull$$$0(0);
            }
            super(project, baseDir, FINDER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$IEStacktraceFilter", "<init>"));
        }
    }

    public static class PhantomStacktraceFilter
    extends PathSanitizerFilter {
        public static final PatternBasedFileHyperlinkRawDataFinder FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^[^@]*[^/]@(.*):(\\d+)(:\\d+)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*([^\\s].*):(\\d+):(\\d+)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^.* in (.*) \\(line (\\d+)\\)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE})});

        public PhantomStacktraceFilter(@NotNull Project project, @Nullable String baseDir) {
            if (project == null) {
                PhantomStacktraceFilter.$$$reportNull$$$0(0);
            }
            super(project, baseDir, FINDER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$PhantomStacktraceFilter", "<init>"));
        }
    }

    public static class FirefoxStacktraceFilter
    extends PathSanitizerFilter {
        public static final PatternBasedFileHyperlinkRawDataFinder FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^[^@]*@(.*):(\\d+)(:\\d+)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^.* in (.*) \\(line (\\d+)\\)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE})});

        public FirefoxStacktraceFilter(@NotNull Project project, @Nullable String baseDir) {
            if (project == null) {
                FirefoxStacktraceFilter.$$$reportNull$$$0(0);
            }
            super(project, baseDir, FINDER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$FirefoxStacktraceFilter", "<init>"));
        }
    }

    public static class ChromeStacktraceFilter
    extends PathSanitizerFilter {
        public static final PatternBasedFileHyperlinkRawDataFinder FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^\\s*at\\s+([^\\s(].*):(\\d+)(:\\d+)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*at\\s?.*\\(([^(]*):(\\d+)(:\\d+)\\)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^(?:\\s*>>)?\\s*at\\s+[^\\s(]*\\s(\\S+?):(\\d+)(:\\d+)?\\)\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        public ChromeStacktraceFilter(@NotNull Project project, @Nullable String baseDir) {
            if (project == null) {
                ChromeStacktraceFilter.$$$reportNull$$$0(0);
            }
            super(project, baseDir, FINDER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$ChromeStacktraceFilter", "<init>"));
        }
    }
}

