/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.type;

import javax.annotation.Nonnull;
import org.fest.reflect.type.TypeLoader;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

public final class Type {
    private final String name;

    @InternalApi
    public Type(@Nonnull String name) {
        this.name = Preconditions.checkNotNullOrEmpty((String)name);
    }

    public Class<?> load() {
        return new TypeLoader(Preconditions.checkNotNullOrEmpty((String)this.name), this.thisClassLoader()).load();
    }

    public <T> Class<? extends T> loadAs(@Nonnull Class<T> superType) {
        return new TypeLoader(Preconditions.checkNotNullOrEmpty((String)this.name), this.thisClassLoader()).loadAs(superType);
    }

    @Nonnull
    private ClassLoader thisClassLoader() {
        return (ClassLoader)Preconditions.checkNotNull((Object)this.getClass().getClassLoader());
    }

    public TypeLoader withClassLoader(@Nonnull ClassLoader classLoader) {
        return new TypeLoader(Preconditions.checkNotNullOrEmpty((String)this.name), classLoader);
    }
}

