/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.spi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCloudStreamSpiManager {
    public static SpringCloudStreamSpiManager getInstance() {
        return (SpringCloudStreamSpiManager)ApplicationManager.getApplication().getService(SpringCloudStreamSpiManager.class);
    }

    @NotNull
    public List<PropertiesFileImpl> getSpringBindersFiles(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            SpringCloudStreamSpiManager.$$$reportNull$$$0(0);
        }
        List list = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)includeTests, (String)"spring.binders", PropertiesFileImpl.class);
        if (list == null) {
            SpringCloudStreamSpiManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Map<String, List<PsiClass>> getBinders(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            SpringCloudStreamSpiManager.$$$reportNull$$$0(2);
        }
        HashMap<String, List<PsiClass>> result = new HashMap<String, List<PsiClass>>();
        PairProcessor collectProcessor = (property, psiClass) -> {
            List configClasses = result.computeIfAbsent(property.getKey(), key -> new SmartList());
            configClasses.add(psiClass);
            return true;
        };
        this.processClassesListValues(module, includeTests, (PairProcessor<IProperty, PsiClass>)collectProcessor);
        HashMap<String, List<PsiClass>> hashMap = result;
        if (hashMap == null) {
            SpringCloudStreamSpiManager.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    public void processClassesListValues(@NotNull Module module, boolean includeTests, @NotNull PairProcessor<IProperty, PsiClass> processor) {
        if (module == null) {
            SpringCloudStreamSpiManager.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            SpringCloudStreamSpiManager.$$$reportNull$$$0(5);
        }
        List<PropertiesFileImpl> configFiles = this.getSpringBindersFiles(module, includeTests);
        for (PropertiesFileImpl propertiesFile : configFiles) {
            for (IProperty property : propertiesFile.getProperties()) {
                if (SpringCloudStreamSpiManager.processClassReference(property, processor)) continue;
                return;
            }
        }
    }

    private static boolean processClassReference(IProperty property, PairProcessor<IProperty, PsiClass> processor) {
        String key = property.getKey();
        if (StringUtil.isEmptyOrSpaces((String)key)) {
            return true;
        }
        PropertyValueImpl valueElement = SpringCloudStreamSpiManager.getPropertyValuePsiElement(property);
        if (valueElement == null) {
            return true;
        }
        HashSet<JavaClassReferenceSet> processedClassReferenceSets = new HashSet<JavaClassReferenceSet>();
        for (PsiReference reference : valueElement.getReferences()) {
            PsiElement resolve;
            JavaClassReference lastReference;
            JavaClassReferenceSet set;
            if (!(reference instanceof JavaClassReference) || !processedClassReferenceSets.add(set = ((JavaClassReference)reference).getJavaClassReferenceSet()) || (lastReference = (JavaClassReference)ArrayUtil.getLastElement((Object[])set.getAllReferences())) == null || !((resolve = lastReference.resolve()) instanceof PsiClass) || processor.process((Object)property, (Object)((PsiClass)resolve))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PropertyValueImpl getPropertyValuePsiElement(@Nullable IProperty property) {
        if (!(property instanceof PropertyImpl)) {
            return null;
        }
        ASTNode valueNode = ((PropertyImpl)property).getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/cloud/stream/spi/SpringCloudStreamSpiManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/cloud/stream/spi/SpringCloudStreamSpiManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBindersFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBindersFiles";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBinders";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processClassesListValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

