/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.model.jam;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.cloud.stream.model.jam.Input;
import com.intellij.spring.boot.cloud.stream.model.jam.MessageChannel;
import com.intellij.spring.boot.cloud.stream.model.jam.Output;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.spring.model.utils.SpringModelUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class SpringCloudStreamMessageChannelReferenceConverter
extends SpringBeanReferenceJamConverter {
    public static final SpringCloudStreamMessageChannelReferenceConverter INSTANCE = new SpringCloudStreamMessageChannelReferenceConverter();

    private SpringCloudStreamMessageChannelReferenceConverter() {
        super(null);
    }

    public SpringBeanPointer fromString(@Nullable String s, JamStringAttributeElement<SpringBeanPointer> context) {
        SpringBeanPointer pointer = super.fromString(s, context);
        return SpringCloudStreamMessageChannelReferenceConverter.isDestinationSpecificErrorChannel(pointer) ? null : pointer;
    }

    public Collection<SpringBeanPointer> getVariants(JamStringAttributeElement<SpringBeanPointer> context) {
        Module module;
        PsiAnnotationMemberValue element = context.getPsiElement();
        if (element != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null) {
            boolean includeTests = ProjectRootsUtil.isInTestSource((PsiFile)element.getContainingFile());
            GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
            LinkedHashSet<SpringBeanPointer> variants = new LinkedHashSet<SpringBeanPointer>();
            variants.addAll(SpringCloudStreamMessageChannelReferenceConverter.findBoundChannels(Input.METHOD_META, "org.springframework.cloud.stream.annotation.Input", searchScope));
            variants.addAll(SpringCloudStreamMessageChannelReferenceConverter.findBoundChannels(Output.METHOD_META, "org.springframework.cloud.stream.annotation.Output", searchScope));
            List messageChannels = SpringIntegrationUtil.getMessageChannels((Module)module, () -> this.getSpringModel((PsiElement)element));
            for (SpringBeanPointer pointer : messageChannels) {
                if (SpringCloudStreamMessageChannelReferenceConverter.isDestinationSpecificErrorChannel(pointer)) continue;
                variants.add(pointer);
            }
            return variants;
        }
        return Collections.emptyList();
    }

    private static Collection<SpringBeanPointer> findBoundChannels(JamMethodMeta<? extends MessageChannel> meta, String annotation, GlobalSearchScope searchScope) {
        SpringModelUtils springModelUtils = SpringModelUtils.getInstance();
        BeanService beanService = BeanService.getInstance();
        return JamService.getJamService((Project)searchScope.getProject()).getJamMethodElements(meta, annotation, searchScope).stream().filter(channel -> springModelUtils.getSpringModelByBean((CommonSpringBean)channel) != SpringModel.UNKNOWN).map(arg_0 -> ((BeanService)beanService).createSpringBeanPointer(arg_0)).collect(Collectors.toList());
    }

    private static boolean isDestinationSpecificErrorChannel(SpringBeanPointer pointer) {
        CommonSpringBean bean;
        return pointer instanceof JamSpringBeanPointer && (bean = pointer.getSpringBean()) instanceof SpringImplicitBeanMarker && "Spring Cloud Stream".equals(((SpringImplicitBeanMarker)bean).getProviderName());
    }
}

