/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.config;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.microservices.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootCustomHintReferenceProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.cloud.stream.spi.SpringCloudStreamSpiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCloudStreamBinderHintReferenceProvider
extends HintReferenceProviderBase
implements SpringBootCustomHintReferenceProvider {
    private static final String ID = "springCloudStreamBinder";
    private static final String BINDINGS_KEY = "spring.cloud.stream.bindings";
    private static final String BINDER_PROPERTY = "binder";

    @NotNull
    public String getId() {
        return ID;
    }

    protected boolean canProcess(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        Module module;
        if (element == null) {
            SpringCloudStreamBinderHintReferenceProvider.$$$reportNull$$$0(0);
        }
        if (textRanges == null) {
            SpringCloudStreamBinderHintReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SpringCloudStreamBinderHintReferenceProvider.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return false;
        }
        MetaConfigKey key = (MetaConfigKey)context.get(SpringBootHintReferencesProvider.HINT_REFERENCES_CONFIG_KEY);
        if (key == null) {
            return false;
        }
        if (key.getName().equals(BINDINGS_KEY)) {
            String keyText = (String)context.get(SpringBootHintReferencesProvider.HINT_REFERENCES_CONFIG_KEY_TEXT);
            if (keyText == null) {
                return false;
            }
            MetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(module);
            return binder.bindsToKeyProperty(key, BINDER_PROPERTY, keyText) != null;
        }
        return true;
    }

    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        return new BinderHintReference(element, textRange);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "textRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/cloud/stream/config/SpringCloudStreamBinderHintReferenceProvider";
        objectArray[2] = "canProcess";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class BinderHintReference
    extends HintReferenceBase {
        BinderHintReference(@NotNull PsiElement element, TextRange rangeInElement) {
            if (element == null) {
                BinderHintReference.$$$reportNull$$$0(0);
            }
            super(element, rangeInElement);
        }

        @Nullable
        protected PsiElement doResolve() {
            PsiElement psiElement = this.getElement();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return null;
            }
            String value = this.getValue();
            Ref result = new Ref();
            PairProcessor processor = (property, psiClass) -> {
                if (value.equals(property.getKey()) && property instanceof PropertyImpl) {
                    result.set((Object)((PropertyImpl)property));
                    return false;
                }
                return true;
            };
            SpringCloudStreamSpiManager.getInstance().processClassesListValues(module, BinderHintReference.isInTestScope(module, psiElement), (PairProcessor<IProperty, PsiClass>)processor);
            return (PsiElement)result.get();
        }

        public Object @NotNull [] getVariants() {
            PsiElement psiElement = this.getElement();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    BinderHintReference.$$$reportNull$$$0(1);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            LinkedHashSet variants = new LinkedHashSet();
            PairProcessor processor = (property, psiClass) -> {
                variants.add(property);
                return true;
            };
            SpringCloudStreamSpiManager.getInstance().processClassesListValues(module, BinderHintReference.isInTestScope(module, psiElement), (PairProcessor<IProperty, PsiClass>)processor);
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                BinderHintReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private static boolean isInTestScope(Module module, PsiElement psiElement) {
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile == null) {
                return false;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            return ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(virtualFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/cloud/stream/config/SpringCloudStreamBinderHintReferenceProvider$BinderHintReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/cloud/stream/config/SpringCloudStreamBinderHintReferenceProvider$BinderHintReference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

