/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.intellij.CommonBundle;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbConnectionInfo;
import org.jetbrains.android.database.AndroidDbErrorReporter;
import org.jetbrains.android.database.AndroidDbUtil;
import org.jetbrains.android.database.AndroidRemoteDataBaseManager;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidUploadDatabaseAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AndroidUploadDatabaseAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidUploadDatabaseAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setVisible(project != null && !AndroidUploadDatabaseAction.getSelectedAndroidDataSources(e).isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidUploadDatabaseAction.$$$reportNull$$$0(1);
        }
        final Project project = e.getProject();
        assert (project != null);
        final List<AndroidDataSource> dataSources = AndroidUploadDatabaseAction.getSelectedAndroidDataSources(e);
        final AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge((Project)project);
        if (debugBridge == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message((String)"cannot.connect.to.adb.error", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, AndroidBundle.message((String)"android.db.uploading.progress.title", (Object[])new Object[0]), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (AndroidDataSource dataSource : dataSources) {
                    indicator.setText("Uploading " + dataSource.getName());
                    Object object = AndroidDbUtil.DB_SYNC_LOCK;
                    synchronized (object) {
                        AndroidUploadDatabaseAction.uploadDatabase(project, dataSource, indicator, debugBridge);
                    }
                    indicator.checkCanceled();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/database/AndroidUploadDatabaseAction$1", "run"));
            }
        });
    }

    @NotNull
    private static List<AndroidDataSource> getSelectedAndroidDataSources(AnActionEvent e) {
        Set dataSourceElements = DatabaseView.getSelectedElements((DataContext)e.getDataContext(), DbDataSource.class);
        if (dataSourceElements.isEmpty()) {
            List<AndroidDataSource> list = Collections.emptyList();
            if (list == null) {
                AndroidUploadDatabaseAction.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<AndroidDataSource> androidDataSources = new ArrayList<AndroidDataSource>();
        for (DbDataSource element : dataSourceElements) {
            DatabaseSystem delegate = element.getDelegate();
            if (!(delegate instanceof AndroidDataSource)) continue;
            androidDataSources.add((AndroidDataSource)delegate);
        }
        ArrayList<AndroidDataSource> arrayList = androidDataSources;
        if (arrayList == null) {
            AndroidUploadDatabaseAction.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void uploadDatabase(@NotNull Project project, @NotNull AndroidDataSource dataSource, @NotNull ProgressIndicator progress, @NotNull AndroidDebugBridge debugBridge) {
        if (project == null) {
            AndroidUploadDatabaseAction.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            AndroidUploadDatabaseAction.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            AndroidUploadDatabaseAction.$$$reportNull$$$0(6);
        }
        if (debugBridge == null) {
            AndroidUploadDatabaseAction.$$$reportNull$$$0(7);
        }
        Path localDbFilePath = Paths.get(dataSource.buildLocalDbFileOsPath(), new String[0]);
        AndroidDbErrorReporter errorReporter = new AndroidDbErrorReporter(project, dataSource, true);
        AndroidDbConnectionInfo dbConnectionInfo = AndroidDbUtil.checkDataSource(dataSource, debugBridge, errorReporter);
        if (dbConnectionInfo == null) {
            return;
        }
        IDevice device = dbConnectionInfo.getDevice();
        String packageName = dbConnectionInfo.getPackageName();
        String dbName = dbConnectionInfo.getDbName();
        String deviceId = AndroidDbUtil.getDeviceId(device);
        boolean external = dbConnectionInfo.isExternal();
        if (!Files.isRegularFile(localDbFilePath, new LinkOption[0]) || deviceId == null) {
            return;
        }
        String databaseRemoteDirPath = AndroidDbUtil.getDatabaseRemoteDirPath(packageName, external);
        String databaseRemoteFilePath = AndroidDbUtil.getDatabaseRemoteFilePath(packageName, dbName, external);
        AdbDeviceFileSystemService adbService = AdbDeviceFileSystemService.getInstance((Project)project);
        AdbDeviceFileSystem fileSystem = new AdbDeviceFileSystem(adbService, device);
        try {
            progress.setIndeterminate(false);
            DeviceFileEntry remoteDbDir = (DeviceFileEntry)fileSystem.getEntry(databaseRemoteDirPath).get();
            remoteDbDir.uploadFile(localDbFilePath, AndroidDbUtil.wrapAsFileTransferProgress(progress)).get();
            DeviceFileEntry remoteDbFile = (DeviceFileEntry)fileSystem.getEntry(databaseRemoteFilePath).get();
            String dbFingerprint = AndroidDbUtil.getFingerprint(remoteDbFile);
            AndroidRemoteDataBaseManager.MyDatabaseInfo dbInfo = AndroidRemoteDataBaseManager.getInstance().getDatabaseInfo(deviceId, packageName, dbName, external);
            if (dbInfo == null) {
                dbInfo = new AndroidRemoteDataBaseManager.MyDatabaseInfo();
            }
            dbInfo.fingerprint = dbFingerprint;
            AndroidRemoteDataBaseManager.getInstance().setDatabaseInfo(deviceId, packageName, dbName, dbInfo, external);
        }
        catch (Exception e) {
            String message = "Failed to upload local file " + localDbFilePath.toString() + " to device " + deviceId + ", remote path: " + databaseRemoteFilePath + ", reason: " + e.getMessage();
            errorReporter.reportError(message);
            LOG.warn(message, (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidUploadDatabaseAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugBridge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidUploadDatabaseAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAndroidDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "uploadDatabase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

