/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class AndroidDbErrorReporter {
    private volatile boolean myHasError;
    private final Project myProject;
    private final AndroidDataSource myDataSource;
    private final boolean myUpload;

    AndroidDbErrorReporter(@NotNull Project project, @NotNull AndroidDataSource dataSource, boolean upload) {
        if (project == null) {
            AndroidDbErrorReporter.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            AndroidDbErrorReporter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myUpload = upload;
    }

    public synchronized boolean hasError() {
        return this.myHasError;
    }

    public synchronized void reportError(@NotNull @Nls String message) {
        if (message == null) {
            AndroidDbErrorReporter.$$$reportNull$$$0(2);
        }
        this.myHasError = true;
        Notification notification = new Notification("Android Data Source Manager", "Data Source Synchronization Error", "Cannot " + (this.myUpload ? "upload" : "synchronize") + " '" + this.myDataSource.getName() + "': " + message, NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
    }

    public synchronized void reportInfo(@NotNull @Nls String message) {
        if (message == null) {
            AndroidDbErrorReporter.$$$reportNull$$$0(3);
        }
        Notification notification = new Notification("Android Data Source Manager", "Data Source Synchronization", "'" + this.myDataSource.getName() + "': " + message, NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/database/AndroidDbErrorReporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reportError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

