/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.BasicDataSourceManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import icons.AndroidIcons;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDataSourceConfigurable;
import org.jetbrains.android.database.AndroidDataSourceStorage;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDataSourceManager
extends BasicDataSourceManager<AndroidDataSource> {
    public static final String NOTIFICATION_GROUP_ID = "Android Data Source Manager";
    private final AndroidDataSourceStorage myStorage;

    public AndroidDataSourceManager(@NotNull Project project) {
        if (project == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(0);
        }
        super(project, AndroidDataSourceStorage.getInstance(project).getDataSources());
        this.myStorage = AndroidDataSourceStorage.getInstance(project);
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull AndroidDataSource element) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(1);
        }
        return DbImplUtil.getDatabaseDialect((Dbms)Dbms.SQLITE);
    }

    @Nullable
    public Language getQueryLanguage(@NotNull AndroidDataSource element) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(2);
        }
        return DbSqlUtil.findSqlDialect((Dbms)Dbms.SQLITE);
    }

    public void renameDataSource(@NotNull AndroidDataSource element, @NotNull String name) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(3);
        }
        if (name == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(4);
        }
        element.setName(name);
        this.updateDataSource((DasDataSource)element);
    }

    public void addDataSource(@NotNull AndroidDataSource dataSource) {
        if (dataSource == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(5);
        }
        this.myStorage.addDataSource(dataSource);
        this.attachDataSource((DasDataSource)dataSource);
    }

    public void removeDataSource(@NotNull AndroidDataSource element) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(6);
        }
        this.myStorage.removeDataSource(element);
        this.detachDataSource((DasDataSource)element);
    }

    @NotNull
    public Configurable createDataSourceEditor(@NotNull AndroidDataSource element) {
        if (element == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(7);
        }
        return new AndroidDataSourceConfigurable(this, this.myProject, element);
    }

    public AnAction getCreateDataSourceAction(final @NotNull Consumer<AndroidDataSource> consumer) {
        if (consumer == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(8);
        }
        if (!ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(AndroidFacet.ID)) {
            return null;
        }
        return new DumbAwareAction("Android SQLite", null, AndroidIcons.Android){

            public void actionPerformed(AnActionEvent e) {
                AndroidDataSource result = new AndroidDataSource();
                result.setName(this.getTemplatePresentation().getText());
                result.resolveDriver();
                consumer.consume((Object)result);
            }
        };
    }

    @NotNull
    public AndroidDataSource copyDataSource(@NotNull String newName, @NotNull AndroidDataSource copyFrom) {
        if (newName == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(9);
        }
        if (copyFrom == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(10);
        }
        AndroidDataSource result = copyFrom.copy(false);
        result.setName(newName);
        result.resolveDriver();
        AndroidDataSource androidDataSource = result;
        if (androidDataSource == null) {
            AndroidDataSourceManager.$$$reportNull$$$0(11);
        }
        return androidDataSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDataSourceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDataSourceManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getQueryLanguage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

