/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.builder.model.Variant;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDataSourceManager;
import org.jetbrains.android.database.AndroidDbUtil;
import org.jetbrains.android.database.AndroidSynchronizeHandler;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class AndroidDataSourceConfigurable
extends AbstractDataSourceConfigurable<AndroidDataSourceManager, AndroidDataSource>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(AndroidDataSourceConfigurable.class);
    private static final String[] DEFAULT_EXTERNAL_DB_PATTERNS = new String[]{"files/"};
    private DefaultComboBoxModel<AndroidSourceDevice> myDeviceComboBoxModel;
    private DatabaseNameComponent myNameComponent;
    private ComboBox<AndroidSourceDevice> myDeviceComboBox;
    private ComboBox<String> myPackageNameComboBox;
    private ComboBox<String> myDataBaseComboBox;
    private JPanel myPanel;
    private JPanel myConfigurationPanel;
    private JBRadioButton myExternalStorageRadioButton;
    private JBRadioButton myInternalStorageRadioButton;
    private final AndroidDebugBridge.IDeviceChangeListener myDeviceListener;
    private final AndroidDataSource myTempDataSource;
    private volatile ListenableFuture<?> latestDbListRequest;

    protected AndroidDataSourceConfigurable(@NotNull AndroidDataSourceManager manager, @NotNull Project project, @NotNull AndroidDataSource dataSource) {
        if (manager == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(2);
        }
        super((DataSourceManager)manager, (DasDataSource)dataSource, project);
        this.$$$setupUI$$$();
        this.myTempDataSource = dataSource.copy(true);
        this.myDeviceListener = new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceConnected(IDevice device) {
                AndroidDataSourceConfigurable.this.addDeviceToComboBoxIfNeeded(device);
            }

            public void deviceDisconnected(IDevice device) {
                AndroidDataSourceConfigurable.this.myDeviceComboBox.repaint();
            }

            public void deviceChanged(IDevice device, int changeMask) {
                if ((changeMask & 1) == changeMask) {
                    AndroidDataSourceConfigurable.this.addDeviceToComboBoxIfNeeded(device);
                }
            }
        };
    }

    @Nullable
    public JComponent createComponent() {
        this.myNameComponent = new DatabaseNameComponent((AbstractDatabaseConfigurable)this, this.myController, true);
        this.myPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myConfigurationPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myDeviceComboBox.setRenderer((ListCellRenderer)((Object)new DeviceCellRenderer(this)));
        this.myDeviceComboBox.setPreferredSize(new Dimension(JBUIScale.scale((int)300), this.myDeviceComboBox.getPreferredSize().height));
        this.myDeviceComboBox.addActionListener(e -> this.updateDbCombo());
        this.myPackageNameComboBox.addActionListener(e -> this.updateDbCombo());
        this.myExternalStorageRadioButton.addActionListener(e -> this.updateDbCombo());
        this.myInternalStorageRadioButton.addActionListener(e -> this.updateDbCombo());
        new UiNotifyConnector.Once((Component)this.myPanel, new Activatable(){

            public void showNotify() {
                AndroidDataSourceConfigurable.this.loadDevices();
                AndroidDataSourceConfigurable.this.updatePackageCombo();
                AndroidDataSourceConfigurable.this.registerDeviceListener();
            }
        });
        return this.myPanel;
    }

    @NotNull
    public AndroidDataSource getTempDataSource() {
        this.saveData(this.myTempDataSource);
        AndroidDataSource androidDataSource = this.myTempDataSource;
        if (androidDataSource == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return androidDataSource;
    }

    private void addDeviceToComboBoxIfNeeded(final @NotNull IDevice device) {
        if (device == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!device.isOnline()) {
                    return;
                }
                String deviceId = AndroidDbUtil.getDeviceId(device);
                if (deviceId == null || deviceId.length() == 0) {
                    return;
                }
                for (int i = 0; i < AndroidDataSourceConfigurable.this.myDeviceComboBoxModel.getSize(); ++i) {
                    AndroidSourceDevice element = AndroidDataSourceConfigurable.this.myDeviceComboBoxModel.getElementAt(i);
                    if (!element.deviceIdEquals(deviceId)) continue;
                    element.updateDevice(device);
                    AndroidDataSourceConfigurable.this.myDeviceComboBox.repaint();
                    return;
                }
                AndroidDataSourceConfigurable.this.myDeviceComboBoxModel.addElement(new AndroidSourceDevice(device, deviceId));
            }
        }, ModalityState.stateForComponent((Component)this.myPanel));
    }

    private void loadDevices() {
        AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge((Project)this.myProject);
        AndroidSourceDevice[] devices = bridge != null ? AndroidDataSourceConfigurable.getDevicesWithValidDeviceId(bridge) : new AndroidSourceDevice[]{};
        String deviceId = ((AndroidDataSource)this.myDataSource).getState().deviceId;
        DefaultComboBoxModel<AndroidSourceDevice> model = new DefaultComboBoxModel<AndroidSourceDevice>(devices);
        AndroidSourceDevice selectedItem = null;
        if (deviceId != null && deviceId.length() > 0) {
            for (AndroidSourceDevice device : devices) {
                if (!device.deviceIdEquals(deviceId)) continue;
                selectedItem = device;
                break;
            }
            if (selectedItem == null) {
                selectedItem = new AndroidSourceDevice(deviceId);
                model.addElement(selectedItem);
            }
        }
        this.myDeviceComboBoxModel = model;
        this.myDeviceComboBox.setModel(model);
        if (selectedItem != null) {
            this.myDeviceComboBox.setSelectedItem(selectedItem);
        }
    }

    @NotNull
    private static AndroidSourceDevice[] getDevicesWithValidDeviceId(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(5);
        }
        ArrayList<AndroidSourceDevice> result = new ArrayList<AndroidSourceDevice>();
        for (IDevice device : bridge.getDevices()) {
            String deviceId;
            if (!device.isOnline() || (deviceId = AndroidDbUtil.getDeviceId(device)) == null || deviceId.length() <= 0) continue;
            result.add(new AndroidSourceDevice(device, deviceId));
        }
        AndroidSourceDevice[] androidSourceDeviceArray = result.toArray(new AndroidSourceDevice[0]);
        if (androidSourceDeviceArray == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(6);
        }
        return androidSourceDeviceArray;
    }

    @RequiresEdt
    private void updateDbCombo() {
        if (!this.myPanel.isShowing()) {
            return;
        }
        IDevice selectedDevice = this.getSelectedDevice();
        String selectedPackage = this.getSelectedPackage();
        final boolean wasSelectedFromList = this.isSelectedFromList(this.myDataBaseComboBox);
        if (this.latestDbListRequest != null && !this.latestDbListRequest.isDone()) {
            this.latestDbListRequest.cancel(false);
        }
        final ListenableFuture<List<String>> futureDatabases = this.loadDatabases(selectedDevice, selectedPackage);
        this.latestDbListRequest = futureDatabases;
        Futures.addCallback(futureDatabases, (FutureCallback)new FutureCallback<List<String>>(){

            public void onSuccess(List<String> resultList) {
                if (AndroidDataSourceConfigurable.this.latestDbListRequest != futureDatabases) {
                    return;
                }
                String newSelectedDatabase = AndroidDataSourceConfigurable.this.getSelectedDatabase();
                String selectedItem = !wasSelectedFromList ? newSelectedDatabase : null;
                AndroidDataSourceConfigurable.this.setComboItemsAndSelection(resultList, selectedItem, AndroidDataSourceConfigurable.this.myDataBaseComboBox);
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    4.$$$reportNull$$$0(0);
                }
                String newSelectedDatabase = AndroidDataSourceConfigurable.this.getSelectedDatabase();
                AndroidDataSourceConfigurable.this.setComboItemsAndSelection(Collections.emptyList(), newSelectedDatabase, AndroidDataSourceConfigurable.this.myDataBaseComboBox);
                LOG.debug(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/android/database/AndroidDataSourceConfigurable$4", "onFailure"));
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void setComboItemsAndSelection(List<String> resultList, String selectedItem, ComboBox<String> comboBox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)comboBox.getModel();
        model.removeAllElements();
        if (selectedItem != null) {
            model.setSelectedItem(selectedItem);
        }
        resultList.forEach(model::addElement);
    }

    @NotNull
    private ListenableFuture<List<String>> loadDatabases(IDevice selectedDevice, String selectedPackage) {
        Object futureDatabases = this.myInternalStorageRadioButton.isSelected() ? (selectedDevice == null ? Futures.immediateFuture(Collections.emptyList()) : this.loadDatabasesFromInternalStorage(selectedDevice, selectedPackage)) : Futures.immediateFuture(Arrays.asList(DEFAULT_EXTERNAL_DB_PATTERNS));
        ListenableFuture<List<String>> listenableFuture = futureDatabases;
        if (listenableFuture == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(7);
        }
        return listenableFuture;
    }

    private boolean isSelectedFromList(@NotNull ComboBox<String> comboBox) {
        String currentValue;
        if (comboBox == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(8);
        }
        return StringUtil.isEmpty((String)(currentValue = (String)comboBox.getEditor().getItem())) || ((DefaultComboBoxModel)comboBox.getModel()).getIndexOf(currentValue) >= 0;
    }

    @NotNull
    private String getSelectedPackage() {
        String string = (String)this.myPackageNameComboBox.getEditor().getItem();
        if (string == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private String getSelectedDatabase() {
        String string = (String)this.myDataBaseComboBox.getEditor().getItem();
        if (string == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(10);
        }
        return string;
    }

    @RequiresEdt
    private void updatePackageCombo() {
        if (!this.myPanel.isShowing()) {
            return;
        }
        String selectedPackage = this.getSelectedPackage();
        boolean wasSelectedFromList = this.isSelectedFromList(this.myPackageNameComboBox);
        List<String> packages = this.loadPackageList();
        String selectedItem = !wasSelectedFromList ? selectedPackage : null;
        this.setComboItemsAndSelection(packages, selectedItem, this.myPackageNameComboBox);
    }

    private List<String> loadPackageList() {
        HashSet<String> mainPackages = new HashSet<String>();
        HashSet extraPackages = new HashSet();
        for (AndroidFacet facet : ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID)) {
            String aPackage;
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get((AndroidFacet)facet);
            if (androidModuleModel != null) {
                IdeAndroidProject androidProject = androidModuleModel.getAndroidProject();
                for (Variant variant : androidProject.getVariants()) {
                    mainPackages.add(variant.getMainArtifact().getApplicationId());
                    if (variant.getExtraAndroidArtifacts() == null) continue;
                    variant.getExtraAndroidArtifacts().forEach(artifact -> extraPackages.add(artifact.getApplicationId()));
                }
                continue;
            }
            Manifest manifest = Manifest.getMainManifest((AndroidFacet)facet);
            if (manifest == null || (aPackage = manifest.getPackage().getStringValue()) == null || aPackage.length() <= 0) continue;
            mainPackages.add(aPackage);
        }
        if (mainPackages.isEmpty() && extraPackages.isEmpty()) {
            return Collections.emptyList();
        }
        extraPackages.removeAll(mainPackages);
        ArrayList<String> packages = new ArrayList<String>(mainPackages.size() + extraPackages.size());
        packages.addAll(mainPackages);
        packages.addAll(extraPackages);
        return packages;
    }

    @NotNull
    private ListenableFuture<List<String>> loadDatabasesFromInternalStorage(@NotNull IDevice device, @NotNull String packageName) {
        if (device == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(12);
        }
        AdbDeviceFileSystemService fileSystemService = AdbDeviceFileSystemService.getInstance((Project)this.getProject());
        AdbDeviceFileSystem remoteFileSystem = new AdbDeviceFileSystem(fileSystemService, device);
        String dbPath = AndroidDbUtil.getInternalDatabasesRemoteDirPath(packageName);
        ListenableFuture remoteDatabasesPath = remoteFileSystem.getEntry(dbPath);
        ListenableFuture remoteFiles = Futures.transformAsync((ListenableFuture)remoteDatabasesPath, p -> p.getEntries(), (Executor)PooledThreadExecutor.INSTANCE);
        ListenableFuture listenableFuture = Futures.transform((ListenableFuture)remoteFiles, l -> l.stream().map(DeviceFileEntry::getName).filter(name -> !name.endsWith("-journal")).collect(Collectors.toList()), (Executor)PooledThreadExecutor.INSTANCE);
        if (listenableFuture == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(13);
        }
        return listenableFuture;
    }

    @Nullable
    private IDevice getSelectedDevice() {
        AndroidSourceDevice item = (AndroidSourceDevice)this.myDeviceComboBox.getSelectedItem();
        if (item == null || item.device == null) {
            return null;
        }
        return item.device;
    }

    private String getSelectedDeviceId() {
        Object item = this.myDeviceComboBox.getSelectedItem();
        if (item == null) {
            return null;
        }
        assert (item instanceof AndroidSourceDevice);
        return ((AndroidSourceDevice)item).deviceId;
    }

    public void saveData(@NotNull AndroidDataSource dataSource) {
        if (dataSource == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(14);
        }
        this.myNameComponent.save((AbstractDataSource)dataSource);
        AndroidDataSource.State state = dataSource.getState();
        state.deviceId = this.getSelectedDeviceId();
        state.packageName = this.getSelectedPackage();
        state.databaseName = this.getSelectedDatabase();
        state.external = this.myExternalStorageRadioButton.isSelected();
        dataSource.resetUrl();
    }

    public void apply() {
        this.saveData((AndroidDataSource)this.myDataSource);
        this.myNameComponent.apply((AbstractDataSource)this.myDataSource);
        if (DbImplUtil.canConnectTo((LocalDataSource)((LocalDataSource)this.myDataSource))) {
            AndroidSynchronizeHandler.doSynchronize(this.myProject, Collections.singletonList((AndroidDataSource)this.myDataSource));
        }
        if (this.isNewDataSource()) {
            ((AndroidDataSourceManager)this.myManager).addDataSource((AndroidDataSource)this.myDataSource);
        }
    }

    protected void reset(@NotNull AndroidDataSource o) {
        if (o == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(15);
        }
        AndroidDataSource.State state = o.getState();
        this.myNameComponent.reset((AbstractDataSource)o, null);
        this.myInternalStorageRadioButton.setSelected(!state.external);
        this.myExternalStorageRadioButton.setSelected(state.external);
        this.myPackageNameComboBox.getEditor().setItem(StringUtil.notNullize((String)state.packageName));
        this.myDataBaseComboBox.getEditor().setItem(StringUtil.notNullize((String)state.databaseName));
    }

    private void registerDeviceListener() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceListener);
    }

    public void dispose() {
        if (this.latestDbListRequest != null && !this.latestDbListRequest.isDone()) {
            this.latestDbListRequest.cancel(false);
        }
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceListener);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    @Nls
    public String getDisplayName() {
        return this.myNameComponent.getNameValue();
    }

    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        AndroidDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((AndroidDataSource)this.myDataSource).getName())) {
            return true;
        }
        return !tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource) || this.myNameComponent.isModified();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDataSourceConfigurable";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridge";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDataSourceConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevicesWithValidDeviceId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDatabases";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPackage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDatabase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDatabasesFromInternalStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDeviceToComboBoxIfNeeded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDevicesWithValidDeviceId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedFromList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadDatabasesFromInternalStorage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myConfigurationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "");
        jPanel.putClientProperty("html.disable", Boolean.FALSE);
        jPanel2.add((Component)jPanel, "Center");
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Device:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceComboBox = comboBox3 = new ComboBox();
        jPanel.add((Component)comboBox3, new GridConstraints(0, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Package name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageNameComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Database:");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDataBaseComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel.add((Component)comboBox, new GridConstraints(3, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Storage:");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myInternalStorageRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        jBRadioButton2.setText("Internal");
        jPanel.add((Component)jBRadioButton2, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myExternalStorageRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("External");
        jPanel.add((Component)jBRadioButton, new GridConstraints(2, 2, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class DeviceCellRenderer
    extends ColoredListCellRenderer<AndroidSourceDevice> {
        private static final boolean SHOW_SERIAL = false;
        private static final String EMPTY_TEXT = "No Connected Devices";
        private final DeviceNamePropertiesProvider deviceNamePropertiesProvider;

        DeviceCellRenderer(Disposable parent) {
            this.deviceNamePropertiesProvider = new DeviceNamePropertiesFetcher((FutureCallback)new FutureCallback<DeviceNameProperties>(){

                public void onSuccess(DeviceNameProperties result) {
                    AndroidDataSourceConfigurable.this.myDeviceComboBox.repaint();
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/android/database/AndroidDataSourceConfigurable$DeviceCellRenderer$1", "onFailure"));
                }
            }, parent);
        }

        protected void customizeCellRenderer(@NotNull JList list, AndroidSourceDevice value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                DeviceCellRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                this.append(EMPTY_TEXT, SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value.device != null) {
                DeviceRenderer.renderDeviceName((IDevice)value.device, (DeviceNameProperties)this.deviceNamePropertiesProvider.get(value.device), (ColoredTextContainer)this, (boolean)false);
            } else {
                this.append(value.deviceId, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/android/database/AndroidDataSourceConfigurable$DeviceCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class AndroidSourceDevice {
        @NotNull
        final String deviceId;
        @Nullable
        IDevice device;

        AndroidSourceDevice(@NotNull String deviceId) {
            if (deviceId == null) {
                AndroidSourceDevice.$$$reportNull$$$0(0);
            }
            this.deviceId = deviceId;
            this.device = null;
        }

        AndroidSourceDevice(@NotNull IDevice device, @NotNull String deviceId) {
            if (device == null) {
                AndroidSourceDevice.$$$reportNull$$$0(1);
            }
            if (deviceId == null) {
                AndroidSourceDevice.$$$reportNull$$$0(2);
            }
            this.device = device;
            this.deviceId = deviceId;
        }

        public boolean deviceIdEquals(String otherDeviceId) {
            return this.deviceId.equals(otherDeviceId);
        }

        public void updateDevice(IDevice device) {
            this.device = device;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deviceId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "device";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/database/AndroidDataSourceConfigurable$AndroidSourceDevice";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

