/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.DynamicBundle;
import com.intellij.j2ee.webSphere.configuration.WebSphereCell;
import com.intellij.j2ee.webSphere.configuration.WebSphereLibertyFilesProvider;
import com.intellij.j2ee.webSphere.configuration.WebSphereNode;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfile;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfileUtil;
import com.intellij.j2ee.webSphere.configuration.WebSphereServerConfiguration;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereRunConfigurationEditorBase;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.run.configuration.PredefinedLogFilesListener;
import com.intellij.javaee.appServers.run.configuration.PredefinedLogFilesProviderEditor;
import com.intellij.javaee.appServers.run.configuration.ServerModelBase;
import com.intellij.javaee.appServers.run.configuration.view.JavaeeRunConfigurationEditorUtil;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboBoxFieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSphereLocalRunConfigurationEditor
extends WebSphereRunConfigurationEditorBase
implements PredefinedLogFilesProviderEditor {
    private final EventDispatcher<PredefinedLogFilesListener> myDispatcher;
    private JPanel myMainPanel;
    private JPanel myProfilePathPanel;
    private final ComboBoxFieldPanel myProfilePath;
    private JLabel myProfilePathLabel;
    private JComboBox myCellBox;
    private JComboBox myNodeBox;
    private JComboBox myServerBox;
    private JTextField myUsernameField;
    private JPasswordField myPasswordField;
    private JLabel myCellLabel;
    private JLabel myNodeLabel;
    private JLabel myUsernameLabel;
    private JLabel myPasswordLabel;
    private WebSphereCell mySelectedCell;
    private WebSphereNode mySelectedNode;
    private String mySelectedProfilePath;

    public WebSphereLocalRunConfigurationEditor() {
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(PredefinedLogFilesListener.class);
        this.myProfilePath = new ComboBoxFieldPanel();
        this.myProfilePath.setBrowseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)WebSphereLocalRunConfigurationEditor.this.myMainPanel, null, null);
                if (virtualFile != null) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    WebSphereLocalRunConfigurationEditor.this.myProfilePath.setText(file.getAbsolutePath());
                    WebSphereLocalRunConfigurationEditor.this.onProfileChanged();
                }
            }
        });
        this.myProfilePath.createComponent();
        this.myProfilePathLabel.setLabelFor(this.myProfilePath.getComboBox());
        this.myProfilePathPanel.setLayout(new BorderLayout());
        this.myProfilePathPanel.add((Component)this.myProfilePath, "Center");
        this.myProfilePath.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSphereLocalRunConfigurationEditor.this.onProfileChanged();
            }
        });
        this.myCellBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSphereLocalRunConfigurationEditor.this.onCellChanged();
            }
        });
        this.myNodeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSphereLocalRunConfigurationEditor.this.onNodeChanged();
            }
        });
        this.myServerBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebSphereLocalRunConfigurationEditor.this.refreshLogFiles();
            }
        });
    }

    private void refreshLogFiles() {
        try {
            ((PredefinedLogFilesListener)this.myDispatcher.getMulticaster()).predefinedLogFilesChanged((CommonModel)this.getSnapshot());
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    protected void resetEditorFrom(@NotNull CommonModel commonModel) {
        if (commonModel == null) {
            WebSphereLocalRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        WebSphereModel model = (WebSphereModel)commonModel.getServerModel();
        this.myProfilePath.setText(FileUtil.toSystemDependentName((String)model.PROFILE_PATH));
        this.myUsernameField.setText(model.USERNAME);
        this.resetPasswordFrom((ServerModelBase)model, this.myPasswordField, this.myPasswordLabel);
        WebSphereLocalRunConfigurationEditor.selectByName(this.myCellBox, model.CELL_NAME);
        WebSphereLocalRunConfigurationEditor.selectByName(this.myNodeBox, model.NODE_NAME);
        WebSphereLocalRunConfigurationEditor.selectByName(this.myServerBox, model.SERVER_NAME);
    }

    private static void selectByName(JComboBox comboBox, String name) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object item = comboBox.getItemAt(i);
            if (item == null || !item.toString().equals(name)) continue;
            comboBox.setSelectedIndex(i);
            return;
        }
    }

    @Override
    protected JComponent[] getLibertyExcludedComponents() {
        return new JComponent[]{this.myProfilePathLabel, this.myProfilePathPanel, this.myNodeLabel, this.myNodeBox, this.myCellLabel, this.myCellBox, this.myUsernameLabel, this.myUsernameField, this.myPasswordLabel, this.myPasswordField};
    }

    @Override
    protected void onVersionChanged(@Nullable ApplicationServer server, @Nullable WebSphereVersion version, boolean libertyProfile) {
        JComboBox comboBox = this.myProfilePath.getComboBox();
        comboBox.removeAllItems();
        this.myServerBox.removeAllItems();
        if (version == null) {
            return;
        }
        if (libertyProfile) {
            for (String serverName : new WebSphereLibertyFilesProvider(server).getServerNames()) {
                this.myServerBox.addItem(serverName);
            }
        } else {
            WebSphereProfile[] profiles = WebSphereProfileUtil.getProfiles(version);
            ArrayList<String> profilePaths = new ArrayList<String>();
            for (WebSphereProfile profile : profiles) {
                profilePaths.add(profile.getLocation().getAbsolutePath());
            }
            Collections.sort(profilePaths);
            for (String profilePath : profilePaths) {
                comboBox.addItem(profilePath);
            }
            WebSphereLocalRunConfigurationEditor.setSelectedItemIfSingle(comboBox);
            boolean profilesSupported = version.isProfilesSupported();
            this.myProfilePath.setVisible(profilesSupported);
            this.myProfilePathLabel.setVisible(profilesSupported);
            if ((!profilesSupported || "".equals(this.myProfilePath.getText())) && profilePaths.size() == 1) {
                this.myProfilePath.setText((String)profilePaths.get(0));
            }
        }
    }

    private static void setSelectedItemIfSingle(JComboBox comboBox) {
        if (comboBox.getItemCount() == 1) {
            comboBox.setSelectedItem(comboBox.getItemAt(0));
        }
    }

    private void onProfileChanged() {
        WebSphereProfile profile;
        String profilePath = this.myProfilePath.getText();
        if (this.mySelectedProfilePath != null && this.mySelectedProfilePath.equals(profilePath)) {
            return;
        }
        this.mySelectedProfilePath = profilePath;
        this.myCellBox.removeAllItems();
        WebSphereVersion version = this.getVersion();
        if (version != null && (profile = WebSphereProfileUtil.createProfile(version, new File(profilePath))) != null) {
            WebSphereCell[] cells;
            for (WebSphereCell cell : cells = profile.getCells()) {
                this.myCellBox.addItem(cell);
            }
            WebSphereLocalRunConfigurationEditor.setSelectedItemIfSingle(this.myCellBox);
        }
    }

    private void onCellChanged() {
        WebSphereCell cell = (WebSphereCell)this.myCellBox.getSelectedItem();
        if (this.mySelectedCell != null && this.mySelectedCell.equals(cell)) {
            return;
        }
        this.mySelectedCell = cell;
        this.myNodeBox.removeAllItems();
        if (cell != null) {
            WebSphereNode[] nodes;
            for (WebSphereNode node : nodes = cell.getNodes()) {
                this.myNodeBox.addItem(node);
            }
            WebSphereLocalRunConfigurationEditor.setSelectedItemIfSingle(this.myNodeBox);
        }
    }

    private void onNodeChanged() {
        WebSphereNode node = (WebSphereNode)this.myNodeBox.getSelectedItem();
        if (this.mySelectedNode != null && this.mySelectedNode.equals(node)) {
            return;
        }
        this.mySelectedNode = node;
        this.myServerBox.removeAllItems();
        if (node != null) {
            WebSphereServerConfiguration[] servers;
            for (WebSphereServerConfiguration serverConfiguration : servers = node.getServers()) {
                this.myServerBox.addItem(serverConfiguration);
            }
            WebSphereLocalRunConfigurationEditor.setSelectedItemIfSingle(this.myServerBox);
        }
    }

    protected void applyEditorTo(@NotNull CommonModel commonModel) throws ConfigurationException {
        if (commonModel == null) {
            WebSphereLocalRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        WebSphereModel webSphereModel = (WebSphereModel)commonModel.getServerModel();
        webSphereModel.PROFILE_PATH = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)this.myProfilePath.getText()));
        webSphereModel.CELL_NAME = WebSphereLocalRunConfigurationEditor.getSelectedItem(this.myCellBox);
        webSphereModel.NODE_NAME = WebSphereLocalRunConfigurationEditor.getSelectedItem(this.myNodeBox);
        webSphereModel.SERVER_NAME = WebSphereLocalRunConfigurationEditor.getSelectedItem(this.myServerBox);
        webSphereModel.USERNAME = this.myUsernameField.getText();
        JavaeeRunConfigurationEditorUtil.applyPasswordTo((ServerModelBase)webSphereModel, (JPasswordField)this.myPasswordField);
    }

    private static String getSelectedItem(JComboBox cellBox) {
        Object selectedItem = cellBox.getSelectedItem();
        return selectedItem == null ? "" : selectedItem.toString();
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            WebSphereLocalRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void addListener(PredefinedLogFilesListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(PredefinedLogFilesListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2ee/webSphere/runDebug/configuration/WebSphereLocalRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2ee/webSphere/runDebug/configuration/WebSphereLocalRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JLabel jLabel3;
        JComboBox jComboBox3;
        JLabel jLabel4;
        JPanel jPanel;
        JLabel jLabel5;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/WebSphereBundle", WebSphereLocalRunConfigurationEditor.class).getString("group.local.run.title"), (int)0, (int)0, null, null));
        this.myProfilePathLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/WebSphereBundle", WebSphereLocalRunConfigurationEditor.class).getString("label.run.configuration.profile.path.text"));
        jPanel2.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProfilePathPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCellLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/WebSphereBundle", WebSphereLocalRunConfigurationEditor.class).getString("label.run.configuration.cell.text"));
        jPanel2.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCellBox = jComboBox3 = new JComboBox();
        jPanel2.add(jComboBox3, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(70, -1), null));
        this.myNodeLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WebSphereBundle", WebSphereLocalRunConfigurationEditor.class).getString("label.run.configuration.node.text"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNodeBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/WebSphereBundle", WebSphereLocalRunConfigurationEditor.class).getString("label.run.configuration.server.text"));
        jPanel2.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myUsernameLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WebSphereBundle", WebSphereLocalRunConfigurationEditor.class).getString("label.run.configuration.username.text"));
        jPanel2.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(70, -1), null));
        this.myPasswordLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WebSphereBundle", WebSphereLocalRunConfigurationEditor.class).getString("label.run.configuration.password.text"));
        jPanel2.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(70, -1), null));
        jLabel4.setLabelFor(jComboBox3);
        jLabel3.setLabelFor(jComboBox2);
        jLabel6.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

