/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.j2ee.webSphere.admin.WebSphereAdminLibertyServerImpl;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereProfileHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereStartupExecutable;
import com.intellij.javaee.appServers.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.admin.JavaeeAdminClientImpl;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.util.SystemInfo;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public abstract class WebSphereLibertyHandler
implements WebSphereProfileHandler {
    @NonNls
    public static final String DEBUG_ENV_VARIABLE = "JVM_ARGS";
    private final WebSphereModel myServerModel;

    public WebSphereLibertyHandler(WebSphereModel serverModel) {
        this.myServerModel = serverModel;
    }

    protected final WebSphereModel getServerModel() {
        return this.myServerModel;
    }

    @Override
    public boolean isDetectableServerPort() {
        return false;
    }

    @Override
    public void updateChangedFiles(Set<String> paths) {
    }

    @Override
    public ExecutableObject createStartupExecutable() {
        JavaeeParameters params = new JavaeeParameters();
        this.getScriptParameters(params, "run");
        return new ColoredCommandLineExecutableObject(params.get(), null){

            public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
                WebSphereStartupExecutable.patchDebugEnvVar(envVariables, WebSphereLibertyHandler.DEBUG_ENV_VARIABLE);
                return super.createProcessHandler(workingDirectory, envVariables);
            }
        };
    }

    @Override
    public void getShutdownParameters(JavaeeParameters params, boolean debug) {
        this.getScriptParameters(params, "stop");
    }

    private void getScriptParameters(JavaeeParameters params, String command) {
        @NonNls String script = SystemInfo.isWindows ? "server.bat" : "server";
        params.add(this.myServerModel.getLibertyConfigAccessor().getScriptPath(script));
        params.add(new String[]{command});
        params.add(new String[]{this.myServerModel.SERVER_NAME});
    }

    @Override
    public JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        return new JavaeeAdminClientImpl((JavaeeAdmin)new WebSphereAdminLibertyServerImpl(this.myServerModel.getLibertyConfigAccessor(), this.isLocalhost()));
    }

    protected final boolean isLocalhost() {
        return JavaeeServerInstanceImpl.isLocalhost((CommonModel)this.myServerModel.getCommonModel());
    }

    @Override
    public String getDebugEnvVarName() {
        return DEBUG_ENV_VARIABLE;
    }
}

