/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view;

import com.intellij.facet.Facet;
import com.intellij.ide.SelectInContext;
import com.intellij.javaee.module.components.FacetUrl;
import com.intellij.javaee.module.view.FrameworkSelectInTarget;
import com.intellij.javaee.module.view.SelectInTargetUtil;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.jpa.view.JpaClassUrl;
import com.intellij.jpa.view.JpaView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JpaSelectInTarget
extends FrameworkSelectInTarget {
    protected static final Logger LOG = Logger.getInstance((String)JpaSelectInTarget.class.getName());

    private static Object[] getPathToSelect(SelectInContext context) {
        Object selector = context.getSelectorInFile();
        if (!(selector instanceof PsiElement)) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        PsiElement element = (PsiElement)selector;
        if (!element.isValid()) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        PsiClass aClass = SelectInTargetUtil.getClassSelected((PsiElement)element);
        ArrayList<Object> treePath = new ArrayList<Object>();
        Project project = context.getProject();
        if (aClass != null) {
            if (PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass).length > 0) {
                ContainerUtil.addAll(treePath, (Object[])JpaClassUrl.getPath(aClass));
            }
        } else if (element.getContainingFile() instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)element.getContainingFile();
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile, DomElement.class);
            DomElement rootElement = fileElement != null ? fileElement.getRootElement() : null;
            PersistenceMappings mappings = rootElement instanceof PersistenceMappings ? (PersistenceMappings)rootElement : null;
            for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets((Project)project)) {
                PersistencePackage unit;
                ConfigFile configFile = (ConfigFile)ContainerUtil.find((Object[])facet.getDescriptors(), file -> file.getPsiFile() == xmlFile);
                if (configFile != null) {
                    ContainerUtil.addAll(treePath, (Object[])FacetUrl.getPath((Facet)((Facet)facet)));
                    treePath.add(xmlFile);
                    break;
                }
                if (mappings == null || (unit = (PersistencePackage)ContainerUtil.find((Iterable)facet.getPersistenceUnits(), unit1 -> facet.getDefaultEntityMappings(unit1).contains(mappings) || PersistenceCommonUtil.getDomEntityMappings(PersistenceMappings.class, (PersistencePackage)unit1, (PersistenceFacet)facet).contains(mappings))) == null) continue;
                ContainerUtil.addAll(treePath, (Object[])FacetUrl.getPath((Facet)((Facet)facet)));
                treePath.add(unit);
                treePath.add(xmlFile);
            }
        }
        return ArrayUtil.toObjectArray(treePath);
    }

    public boolean canSelect(SelectInContext context) {
        return JpaSelectInTarget.getPathToSelect(context).length > 0;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        JpaView.select(context.getProject(), JpaSelectInTarget.getPathToSelect(context), requestFocus);
    }

    public String getToolWindowId() {
        return "Persistence";
    }

    public float getWeight() {
        return 3.0f;
    }

    @NotNull
    protected String getPresentableName() {
        String string = JpaFacetType.getInstance().getPresentableName();
        if (string == null) {
            JpaSelectInTarget.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/view/JpaSelectInTarget", "getPresentableName"));
    }
}

