/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.util;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.common.persistence.JpaAnnotationConstants;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.common.persistence.mapping.CascadeType;
import com.intellij.javaee.model.common.persistence.mapping.CascadeTypeMode;
import com.intellij.javaee.model.common.persistence.mapping.EntityMappings;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.Property;
import com.intellij.javaee.model.xml.persistence.mapping.InheritanceType;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaVersion;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFrameworkSupportProvider;
import com.intellij.jpa.model.annotations.mapping.EntityListenerImpl;
import com.intellij.jpa.model.annotations.mapping.PersistentObjectImpl;
import com.intellij.jpa.model.xml.impl.converters.ClassConverterBase;
import com.intellij.jpa.orm.OrmResolveConverters;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.jvm.JvmElement;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.source.JvmDeclarationSearch;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceInheritanceType;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.model.PersistenceQueryParam;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentCollectionAttribute;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.JdbcTypesUtil;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.GenericValueUtil;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.ReadOnlyGenericValue;
import gnu.trove.THashSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JTextArea;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastUtils;

public final class JpaUtil {
    @NonNls
    public static final String HIBERNATE_PREFIX = "org.hibernate.";
    @NonNls
    public static final String ECLIPSE_PREFIX = "org.eclipse.persistence.";

    private JpaUtil() {
    }

    @NotNull
    public static JpaVersion getJpaVersion(JpaFacet facet) {
        XmlTag tag;
        XmlFile xmlFile;
        XmlDocument document;
        Persistence root = facet.getPersistenceRoot();
        if (root != null && (document = (xmlFile = DomService.getInstance().getContainingFile((DomElement)root)).getDocument()) != null && (tag = document.getRootTag()) != null && tag.isValid()) {
            String namespace = tag.getNamespace();
            if ("http://java.sun.com/xml/ns/persistence".equals(namespace)) {
                String version = tag.getAttributeValue("version");
                if ("2.0".equals(version)) {
                    JpaVersion jpaVersion = JpaVersion.JPA_2_0;
                    if (jpaVersion == null) {
                        JpaUtil.$$$reportNull$$$0(0);
                    }
                    return jpaVersion;
                }
                JpaVersion jpaVersion = JpaVersion.JPA_1_0;
                if (jpaVersion == null) {
                    JpaUtil.$$$reportNull$$$0(1);
                }
                return jpaVersion;
            }
            if ("http://xmlns.jcp.org/xml/ns/persistence".equals(namespace)) {
                String version = tag.getAttributeValue("version");
                if ("2.1".equals(version)) {
                    JpaVersion jpaVersion = JpaVersion.JPA_2_1;
                    if (jpaVersion == null) {
                        JpaUtil.$$$reportNull$$$0(2);
                    }
                    return jpaVersion;
                }
            } else if ("http://xmlns.jcp.org/xml/ns/persistence".equals(namespace)) {
                String version = tag.getAttributeValue("version");
                if ("2.2".equals(version)) {
                    JpaVersion jpaVersion = JpaVersion.JPA_2_2;
                    if (jpaVersion == null) {
                        JpaUtil.$$$reportNull$$$0(3);
                    }
                    return jpaVersion;
                }
            } else if ("https://jakarta.ee/xml/ns/persistence".equals(namespace)) {
                JpaVersion jpaVersion = JpaVersion.JPA_3_0;
                if (jpaVersion == null) {
                    JpaUtil.$$$reportNull$$$0(4);
                }
                return jpaVersion;
            }
        }
        if (JavaLibraryUtils.hasLibraryClass((Module)facet.getModule(), (String)JpaAnnotationConstants.ELEMENT_COLLECTION_ANNO.jakarta())) {
            JpaVersion jpaVersion = JpaVersion.JPA_3_0;
            if (jpaVersion == null) {
                JpaUtil.$$$reportNull$$$0(5);
            }
            return jpaVersion;
        }
        JpaVersion jpaVersion = JpaUtil.areJpa20ClassesAvailable(facet.getModule()) ? JpaVersion.JPA_2_0 : JpaVersion.JPA_1_0;
        if (jpaVersion == null) {
            JpaUtil.$$$reportNull$$$0(6);
        }
        return jpaVersion;
    }

    public static boolean areJpa20ClassesAvailable(@NotNull Module module) {
        if (module == null) {
            JpaUtil.$$$reportNull$$$0(7);
        }
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)JpaAnnotationConstants.ELEMENT_COLLECTION_ANNO.javax());
    }

    public static LibraryInfo[] getJpaLibraryInfos(JpaVersion version) {
        return LibrariesDownloadAssistant.getLibraryInfos((URL)JavaeeVersion.class.getResource("/resources/versions/jpa.xml"), (String)version.getValue());
    }

    public static boolean hasRoles(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        CommonProcessors.FindFirstProcessor firstProcessor = new CommonProcessors.FindFirstProcessor();
        PersistenceRoleHolder.getInstance((Project)psiClass.getProject()).processAllRoles(psiClass, (Processor)firstProcessor);
        return firstProcessor.isFound();
    }

    @Nullable
    public static <T> PersistenceClassRole getFirstPersistenceRoleWithClass(PsiClass aClass, Class<T> requiredClass) {
        boolean isObject = ReflectionUtil.isAssignable(PersistentObject.class, requiredClass);
        boolean isListener = ReflectionUtil.isAssignable(PersistenceListener.class, requiredClass);
        return (PersistenceClassRole)ContainerUtil.find((Object[])PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass), role -> {
            PersistenceListener object = role.getType() == PersistenceClassRoleEnum.ENTITY_LISTENER && isListener ? role.getEntityListener() : (isObject ? role.getPersistentObject() : null);
            return object != null && ReflectionUtil.isAssignable((Class)requiredClass, object.getClass());
        });
    }

    public static <T extends PersistentObject> List<T> getPersistentObjectsOfClass(PsiClass aClass, Class<T> requiredClass) {
        return ContainerUtil.mapNotNull((Object[])PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass), (Function)((NullableFunction)role -> {
            PersistentObject object = role.getPersistentObject();
            return object != null && ReflectionUtil.isAssignable((Class)requiredClass, object.getClass()) ? (PersistentObject)requiredClass.cast(object) : null;
        }));
    }

    @Nullable
    public static <T extends PersistentObject> T getFirstPersistentObjectOfClass(PsiClass aClass, Class<T> requiredClass) {
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass)) {
            PersistentObject object = role.getPersistentObject();
            PersistentObject result = (PersistentObject)ModelMergerUtil.getImplementation((Object)object, requiredClass);
            if (result == null) continue;
            return (T)result;
        }
        return null;
    }

    @Nullable
    public static JpaFacet getJpaFacet(@Nullable Module module) {
        return module == null ? null : JpaFacet.getInstance((Module)module);
    }

    @Nullable
    public static PsiType findType(PersistentAttribute attribute, Function<? super PersistentAttribute, ? extends PsiType> defaultTypeProvider) {
        PsiMember member = attribute.getPsiMember();
        if (member != null) {
            return PropertyUtilBase.getPropertyType((PsiMember)member);
        }
        PsiType defaultType = (PsiType)defaultTypeProvider.fun((Object)attribute);
        if (defaultType != null) {
            return defaultType;
        }
        AttributeType attributeType = JpaUtil.getAttributeType(attribute);
        if (attributeType.accepts(PersistentAttributeType.AttributeComponent.SINGLE, PersistentAttributeType.ComponentType.BASIC)) {
            GenericDomValue domValue;
            String columnName;
            PsiManager psiManager = attribute.getPsiManager();
            List columns = attribute.getAttributeModelHelper().getMappedColumns();
            if (columns.size() == 1 && columns.get(0) instanceof GenericDomValue && !StringUtil.isEmpty((String)(columnName = (domValue = (GenericDomValue)columns.get(0)).getStringValue()))) {
                JavaPsiFacade psiFacade;
                PsiClass aClass;
                String javaType;
                List variants = OrmResolveConverters.ColumnResolverImpl.getColumnVariants((DomElement)domValue, FunctionUtil.id());
                DbColumn tableFieldData = ORMReferencesUtil.findIgnoreCase(variants, columnName, ORMReferencesUtil.COLUMN_MAPPER);
                String string = javaType = tableFieldData == null ? null : JdbcTypesUtil.getJavaType((DasColumn)tableFieldData, (boolean)true, (DatabaseDialect)DbImplUtil.getDatabaseDialect((DbElement)tableFieldData), null);
                if (javaType != null && (aClass = (psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject())).findClass(javaType, ProjectScope.getAllScope((Project)psiManager.getProject()))) != null) {
                    return psiFacade.getElementFactory().createType(aClass);
                }
            }
        }
        return null;
    }

    @Nullable
    public static String getQualifiedName(PersistentObject obj) {
        if (obj == null) {
            return null;
        }
        String value = obj.getClazz().getStringValue();
        return JpaUtil.getQualifiedName(obj, value);
    }

    @Nullable
    public static String getQualifiedName(PersistentObject obj, String name) {
        PersistenceMappings mappings;
        if (obj == null) {
            return null;
        }
        if (name != null && name.indexOf(46) > -1) {
            return name;
        }
        DomElement element = (DomElement)ModelMergerUtil.getImplementation((Object)obj, DomElement.class);
        if (element != null && (mappings = (PersistenceMappings)DomUtil.getParentOfType((DomElement)element, PersistenceMappings.class, (boolean)true)) != null) {
            String packageName = mappings.getPackage().getStringValue();
            return ClassConverterBase.getQualifiedClassName(name, packageName);
        }
        return name;
    }

    @NotNull
    public static List<PersistenceUnit> getPersistenceUnits(@Nullable Module module) {
        Persistence persistence;
        JpaFacet facet = JpaUtil.getJpaFacet(module);
        Persistence persistence2 = persistence = facet == null ? null : facet.getMergedPersistenceRoot();
        if (persistence == null) {
            List<PersistenceUnit> list = Collections.emptyList();
            if (list == null) {
                JpaUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = persistence.getPersistenceUnits();
        if (list == null) {
            JpaUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static boolean processEntityMappings(PersistenceFacet facet, Processor<? super EntityMappings> processor) {
        for (PersistencePackage unit : facet.getPersistenceUnits()) {
            for (PersistenceMappings mappings : ModelMergerUtil.getImplementations((Object)facet.getEntityMappings(unit))) {
                if (!(mappings instanceof EntityMappings) || processor.process((Object)((EntityMappings)mappings))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<PersistentObject> getPersistentObjects(PersistenceMappings mappings) {
        return new ArrayList<PersistentObject>(PersistenceCommonUtil.queryPersistentObjects((PersistenceMappings)mappings).findAll());
    }

    public static void ensureMappingsIncluded(PersistenceUnit persistenceUnit, PersistenceMappings entityMappings) {
        PsiFile containingFile = entityMappings.getContainingFile();
        if (JamCommonUtil.isPlainXmlFile((PsiElement)containingFile)) {
            if (!GenericValueUtil.containsValue((Collection)persistenceUnit.getMappingFiles(), (Object)containingFile)) {
                persistenceUnit.addMappingFile().setValue((Object)containingFile);
            }
        } else if (JpaUtil.isExcludeUnlistedClasses(persistenceUnit)) {
            for (PersistentObject persistentObject : PersistenceCommonUtil.queryPersistentObjects((PersistenceMappings)entityMappings)) {
                JpaUtil.ensureClassIncluded(persistenceUnit, persistentObject, null);
            }
        }
    }

    public static boolean isExcludeUnlistedClasses(@NotNull PersistenceUnit persistenceUnit) {
        GenericDomValue excludeUnlistedClasses;
        if (persistenceUnit == null) {
            JpaUtil.$$$reportNull$$$0(10);
        }
        if (!DomUtil.hasXml((DomElement)(excludeUnlistedClasses = persistenceUnit.getExcludeUnlistedClasses()))) {
            return false;
        }
        String value = excludeUnlistedClasses.getStringValue();
        return value == null || Boolean.valueOf(value) != false;
    }

    public static void ensureClassIncluded(PersistenceUnit persistenceUnit, @Nullable PersistentObject persistentObject, @Nullable PsiClass aClass) {
        PsiFile containingFile;
        assert (persistentObject != null || aClass != null);
        PsiFile psiFile2 = containingFile = persistentObject == null ? null : persistentObject.getContainingFile();
        if (JamCommonUtil.isPlainXmlFile((PsiElement)containingFile)) {
            if (!GenericValueUtil.containsValue((Collection)persistenceUnit.getMappingFiles(), (Object)containingFile)) {
                persistenceUnit.addMappingFile().setValue((Object)containingFile);
            }
        } else {
            PsiClass psiClass = aClass != null ? aClass : (PsiClass)persistentObject.getClazz().getValue();
            String stringValue = persistentObject == null ? null : persistentObject.getClazz().getStringValue();
            if (!GenericValueUtil.containsString((Collection)persistenceUnit.getClasses(), (String)(psiClass == null ? stringValue : psiClass.getQualifiedName()))) {
                GenericDomValue value = persistenceUnit.addClass();
                if (psiClass == null) {
                    value.setStringValue(stringValue);
                } else {
                    value.setValue((Object)psiClass);
                }
            }
        }
    }

    public static boolean isPersistentObject(PsiType type, PersistenceClassRoleEnum objectType) {
        PsiClass psiClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
            if (role.getType() != objectType) continue;
            return true;
        }
        return false;
    }

    public static boolean isBasicPersistentAttributeType(PsiType type, boolean isLob) {
        PsiClass psiClass;
        if (type == null) {
            return false;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)type)) {
            return true;
        }
        String text = type.getCanonicalText();
        if (Arrays.asList("java.math.BigInteger", "java.math.BigDecimal", "java.util.Calendar", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "java.io.Serializable", "java.lang.Object", "byte[]", "java.lang.Byte[]", "char[]", "java.lang.Character[]").contains(text)) {
            return true;
        }
        if (isLob && ("java.sql.Blob".equals(text) || "java.sql.Clob".equals(text))) {
            return true;
        }
        PsiClass psiClass2 = psiClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
        if (psiClass != null) {
            PsiClass serializableClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("java.io.Serializable", ProjectScope.getAllScope((Project)psiClass.getProject()));
            if (serializableClass != null && psiClass.isInheritor(serializableClass, true)) {
                return true;
            }
            if (psiClass.isInterface() && isLob) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAttributeName(PsiNameHelper nameHelper, String name) {
        return nameHelper.isIdentifier(name) && !"class".equals(name);
    }

    @NotNull
    public static List<? extends PersistenceQueryParam> getQueryParams(final PersistenceQuery query) {
        final PsiElement queryElement = JpaUtil.getQueryElement(query);
        if (queryElement == null) {
            List list = Collections.emptyList();
            if (list == null) {
                JpaUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        Map<String, PsiElement> map = JpaUtil.getQueryParamsMap(queryElement);
        if (map == null || map.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                JpaUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<1> list = new ArrayList<1>();
        for (final String name : map.keySet()) {
            final PsiElement paramElement = map.get(name);
            list.add(new PersistenceQueryParam(){

                public GenericValue<String> getName() {
                    return ReadOnlyGenericValue.getInstance((Object)name);
                }

                public GenericValue<PsiType> getType() {
                    return AnnotationGenericValue.nullInstance();
                }

                public boolean isValid() {
                    return queryElement.isValid() && paramElement.isValid();
                }

                public XmlTag getXmlTag() {
                    return null;
                }

                public PsiManager getPsiManager() {
                    return query.getPsiManager();
                }

                @Nullable
                public Module getModule() {
                    return query.getModule();
                }

                public PsiElement getIdentifyingPsiElement() {
                    return queryElement;
                }

                @Nullable
                public PsiFile getContainingFile() {
                    return query.getContainingFile();
                }
            });
        }
        ArrayList<1> arrayList = list;
        if (arrayList == null) {
            JpaUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement getQueryElement(PersistenceQuery query) {
        Object queryElement;
        GenericValue queryValue;
        GenericValue genericValue = queryValue = query == null ? null : query.getQuery();
        if (queryValue instanceof JamAttributeElement) {
            PsiAnnotationMemberValue element = ((JamAttributeElement)queryValue).getPsiElement();
            if (element instanceof PsiReferenceExpression) {
                PsiElement value = ((PsiReferenceExpression)element).resolve();
                PsiExpression initializer = value instanceof PsiVariable ? ((PsiVariable)value).getInitializer() : null;
                queryElement = initializer instanceof PsiLiteralExpression ? initializer : null;
            } else {
                queryElement = element instanceof PsiLiteral ? element : null;
            }
        } else {
            queryElement = queryValue instanceof GenericDomValue ? DomUtil.getValueElement((GenericDomValue)((GenericDomValue)queryValue)) : null;
        }
        return queryElement;
    }

    @Nullable
    public static Map<String, PsiElement> getQueryParamsMap(PsiElement element) {
        PsiElement first;
        List list;
        PsiLanguageInjectionHost host;
        if (element instanceof PsiLanguageInjectionHost) {
            host = (PsiLanguageInjectionHost)element;
        } else if (element instanceof XmlTag) {
            XmlText[] texts = ((XmlTag)element).getValue().getTextElements();
            XmlText targetText = texts.length > 0 ? texts[0] : null;
            for (XmlText text : texts) {
                if (text.getText().trim().length() <= 0) continue;
                targetText = text;
            }
            host = (PsiLanguageInjectionHost)targetText;
        } else {
            host = null;
        }
        if (host != null && (list = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host)) != null && !list.isEmpty() && (first = (PsiElement)((Pair)list.get(0)).getFirst()) instanceof QlFile) {
            return ((QlFile)first).getParameterDeclarations();
        }
        return null;
    }

    public static Collection<String> getCascadeTypes(CascadeType cascadeType) {
        return ContainerUtil.map2Set((Collection)CascadeTypeMode.addCascadeTypes((CascadeType)cascadeType, EnumSet.noneOf(CascadeTypeMode.class)), cascadeTypeMode -> cascadeTypeMode.getDisplayName());
    }

    public static <T extends PsiReference> boolean processReferencesOfType(PsiReference[] references, Class<T> referenceClass, Processor<? super T> processor) {
        for (PsiReference reference : references) {
            if (!(ReflectionUtil.isAssignable(referenceClass, reference.getClass()) ? !processor.process(referenceClass.cast(reference)) : reference instanceof PsiMultiReference && !JpaUtil.processReferencesOfType(((PsiMultiReference)reference).getReferences(), referenceClass, processor))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T extends PsiReference> T findReferenceOfType(PsiReference[] references, Class<T> referenceClass) {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        JpaUtil.processReferencesOfType(references, referenceClass, processor);
        return (T)((PsiReference)processor.getFoundValue());
    }

    public static Pair<EditorTextField, QlFile> createQlEditor(Project project, String initialText, final boolean oneLineMode, Language language, QlModel qlModel, final @Nullable Processor<? super EditorEx> editorConfigurator) {
        QlFile qlFile = (QlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.ql", language, (CharSequence)initialText);
        qlFile.putUserData(QlFile.PERSISTENCE_MODEL_KEY, qlModel);
        EditorTextField editorTextField = new EditorTextField(PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)qlFile), project, qlFile.getFileType(), false, oneLineMode){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setVerticalScrollbarVisible(true);
                editor.getComponent().setPreferredSize(new JTextArea(10, 50).getPreferredSize());
                if (!oneLineMode) {
                    editor.setContextMenuGroupId("CutCopyPasteGroup");
                }
                if (editorConfigurator != null) {
                    editorConfigurator.process((Object)editor);
                }
                return editor;
            }

            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                    return this.getEditor();
                }
                return super.getData(dataId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/jpa/util/JpaUtil$2", "getData"));
            }
        };
        editorTextField.setFontInheritedFromLAF(false);
        return Pair.create((Object)editorTextField, (Object)qlFile);
    }

    @Nullable
    public static VirtualFile chooseXmlFile(Module module, ConfigFileMetaData metaData, Class<?> domClass, @Nls String title, ConfigFile ... existing) {
        THashSet existingFiles = new THashSet();
        for (ConfigFile configFile : existing) {
            ContainerUtil.addIfNotNull((Collection)existingFiles, (Object)configFile.getVirtualFile());
        }
        return JpaUtil.chooseXmlFile(module, metaData.getDefaultVersion().getTemplateName(), domClass, title, (Collection<VirtualFile>)existingFiles);
    }

    @Nullable
    public static VirtualFile chooseXmlFile(Module module, String templateName, Class<?> domClass, @Nls String title, Collection<VirtualFile> existingFiles) {
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])JpaUtil.chooseXmlFiles(module, templateName, domClass, title, existingFiles, false));
    }

    public static VirtualFile @NotNull [] chooseXmlFiles(final Module module, String templateName, final Class<?> domClass, @Nls String title, final Collection<VirtualFile> existingFiles, boolean chooseMultiple) {
        if (!PackageUtil.checkSourceRootsConfigured((Module)module)) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                JpaUtil.$$$reportNull$$$0(14);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        final ProjectFileIndex fileIndex = ProjectRootManagerEx.getInstanceEx((Project)module.getProject()).getFileIndex();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, chooseMultiple){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (fileIndex.isExcluded(file)) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE)) {
                    return false;
                }
                if (existingFiles.contains(file)) {
                    return false;
                }
                return JamCommonUtil.getRootElement((PsiFile)PsiManager.getInstance((Project)module.getProject()).findFile(file), (Class)domClass) != null;
            }
        };
        THashSet modules = new THashSet();
        ModuleUtilCore.getDependencies((Module)module, (Set)modules);
        descriptor.setRoots(ContainerUtil.concat((List)ContainerUtil.map((Collection)modules, module1 -> Arrays.asList(ModuleRootManager.getInstance((Module)module1).getSourceRoots()))));
        descriptor.withTreeRootVisible(true);
        descriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)module);
        descriptor.setTitle(title);
        descriptor.putUserData(FileChooserKeys.NEW_FILE_TYPE, (Object)XmlFileType.INSTANCE);
        FileTemplate template = FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate(templateName);
        descriptor.putUserData(FileChooserKeys.NEW_FILE_TEMPLATE_TEXT, (Object)template.getText());
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)module.getProject(), null);
        if (virtualFileArray == null) {
            JpaUtil.$$$reportNull$$$0(15);
        }
        return virtualFileArray;
    }

    @Nullable
    public static <T> T getOrChooseElement(Module module, ConfigFileContainer descriptorsContainer, ConfigFileMetaData metaData, Class<T> elementClass, @Nls String newDialogTitle, boolean forceNew) {
        VirtualFile file;
        if (module == null || module.isDisposed()) {
            return null;
        }
        ConfigFile existingFile = descriptorsContainer.getConfigFile(metaData);
        if (!forceNew && existingFile != null) {
            file = existingFile.getVirtualFile() != null ? existingFile.getVirtualFile() : (VirtualFile)WriteAction.compute(() -> ConfigFileFactory.getInstance().createFile(module.getProject(), existingFile.getUrl(), metaData.getDefaultVersion(), false));
        } else {
            file = JpaUtil.chooseXmlFile(module, metaData, elementClass, newDialogTitle, descriptorsContainer.getConfigFiles());
            if (file != null) {
                descriptorsContainer.getConfiguration().addConfigFile(metaData, file.getUrl());
            }
        }
        if (file == null) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)module.getProject()).findFile(file);
        return (T)JamCommonUtil.getRootElement((PsiFile)psiFile2, elementClass);
    }

    public static AttributeType getAttributeType(PersistentAttribute domAttr) {
        return AttributeType.getAttributeType((PersistentAttribute)domAttr);
    }

    @Nullable
    public static PersistenceInheritanceType getPersistenceInheritanceType(InheritanceType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case JOINED: {
                return PersistenceInheritanceType.JOINED;
            }
            case SINGLE_TABLE: {
                return PersistenceInheritanceType.SINGLE_TABLE;
            }
            case TABLE_PER_CLASS: {
                return PersistenceInheritanceType.TABLE_PER_CLASS;
            }
        }
        throw new AssertionError(type);
    }

    @Nullable
    public static String findPersistenceUnitProperty(@NotNull PersistencePackage unit, @NotNull String propertyName, @Nullable String propertyAlias) {
        if (unit == null) {
            JpaUtil.$$$reportNull$$$0(16);
        }
        if (propertyName == null) {
            JpaUtil.$$$reportNull$$$0(17);
        }
        Properties properties = unit.getModelHelper().getPersistenceUnitProperties();
        for (String name : properties.stringPropertyNames()) {
            if (!Objects.equals(propertyName, name) && !Objects.equals(propertyAlias, name)) continue;
            return properties.getProperty(name);
        }
        return null;
    }

    public static Property setPersistenceUnitProperty(@NotNull PersistenceUnit unit, @NotNull String propertyName, @Nullable String propertyAlias, String value) {
        Property property;
        if (unit == null) {
            JpaUtil.$$$reportNull$$$0(18);
        }
        if (propertyName == null) {
            JpaUtil.$$$reportNull$$$0(19);
        }
        Property existingProperty = null;
        for (Property property2 : unit.getProperties().getProperties()) {
            String name = (String)property2.getName().getValue();
            if (!Comparing.strEqual((String)propertyName, (String)name) && !Comparing.strEqual((String)propertyAlias, (String)name)) continue;
            existingProperty = property2;
            break;
        }
        Property property3 = property = existingProperty == null ? unit.getProperties().addProperty() : existingProperty;
        if (existingProperty == null) {
            property.getName().setStringValue(propertyName);
        }
        if (value == null) {
            property.undefine();
        } else {
            property.getValue().setStringValue(value);
        }
        return property;
    }

    public static boolean isHibernateProvider(@NotNull JpaFacet facet) {
        Persistence root;
        if (facet == null) {
            JpaUtil.$$$reportNull$$$0(20);
        }
        if ((root = facet.getPersistenceRoot()) != null) {
            for (PersistenceUnit unit : root.getPersistenceUnits()) {
                if (!JpaUtil.isHibernateProvider((PersistenceFacet)facet, (PersistencePackage)unit)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHibernateProvider(@Nullable PersistenceFacet facet, @Nullable PersistencePackage unit) {
        return JpaUtil.isHibernate(JpaUtil.findJpaProvider(facet, unit, true), facet == null ? null : facet.getModule());
    }

    public static boolean isHibernate(@Nullable JpaImplementationProvider provider, @Nullable Module module) {
        String className = provider == null ? null : provider.getProviderClassName(module);
        return className != null && className.startsWith(HIBERNATE_PREFIX);
    }

    public static boolean isHibernateProvider(@NotNull PersistenceClassRole role) {
        if (role == null) {
            JpaUtil.$$$reportNull$$$0(21);
        }
        return role.getFacet().getQlLanguage() == JpqlLanguage.HQL || JpaUtil.isHibernateProvider(role.getFacet(), role.getPersistenceUnit());
    }

    public static boolean isEclipseLinkProvider(@NotNull JpaFacet facet) {
        Persistence root;
        if (facet == null) {
            JpaUtil.$$$reportNull$$$0(22);
        }
        if ((root = facet.getPersistenceRoot()) != null) {
            for (PersistenceUnit unit : root.getPersistenceUnits()) {
                if (!JpaUtil.isEclipseLinkProvider((PersistenceFacet)facet, (PersistencePackage)unit)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEclipseLinkProvider(@Nullable PersistenceFacet facet, @Nullable PersistencePackage unit) {
        return JpaUtil.isEclipseLink(JpaUtil.findJpaProvider(facet, unit, true), facet == null ? null : facet.getModule());
    }

    public static boolean isEclipseLink(@Nullable JpaImplementationProvider provider, @Nullable Module module) {
        String className = provider == null ? null : provider.getProviderClassName(module);
        return className != null && className.startsWith(ECLIPSE_PREFIX);
    }

    @Nullable
    public static JpaImplementationProvider findJpaProvider(@Nullable PersistenceFacet facet, PersistencePackage unit, boolean checkConfiguredProperties) {
        if (unit == null) {
            return null;
        }
        List providers = JpaImplementationProvider.EP_NAME.getExtensionList();
        String providerClassName = unit.getModelHelper().getPersistenceProviderName();
        if (providerClassName != null) {
            for (JpaImplementationProvider provider : providers) {
                if (!providerClassName.equals(provider.getProviderClassName(facet == null ? null : facet.getModule()))) continue;
                return provider;
            }
        }
        if (checkConfiguredProperties) {
            for (JpaImplementationProvider provider : providers) {
                if (!provider.isConfiguredFor(unit)) continue;
                return provider;
            }
        }
        if (facet instanceof JpaFacet) {
            return JpaFrameworkSupportProvider.findProviderByName(((JpaFacetConfiguration)((JpaFacet)facet).getConfiguration()).getDefaultJPAProviderName());
        }
        for (PersistenceFacet persistenceFacet : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceFacets(unit)) {
            JpaImplementationProvider provider;
            if (!(persistenceFacet instanceof JpaFacet) || (provider = JpaFrameworkSupportProvider.findProviderByName(((JpaFacetConfiguration)((JpaFacet)persistenceFacet).getConfiguration()).getDefaultJPAProviderName())) == null) continue;
            return provider;
        }
        return null;
    }

    public static PsiType getAttributeTypeOrDefault(PersistentAttribute attributeBase) {
        PsiType type = attributeBase.getPsiType();
        return type != null ? type : AttributeType.getAttributeType((PersistentAttribute)attributeBase).getDefaultPsiType(attributeBase);
    }

    @Nullable
    public static JavaTypeInfo getSubstitutedTypeInfo(PersistentAttribute attribute, PersistenceModelBrowser browser, Boolean forceCalcMapKey) {
        PsiMember psiMember = attribute.getPsiMember();
        if (psiMember == null) {
            return null;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiMember.getProject());
        PsiType type = PropertyUtilBase.getPropertyType((PsiMember)psiMember);
        JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)type);
        PsiClassType mapKeyType = null;
        if (!Boolean.FALSE.equals(forceCalcMapKey)) {
            if (typeInfo.containerType != JavaContainerType.MAP) {
                if (Boolean.TRUE.equals(forceCalcMapKey)) {
                    return null;
                }
            } else {
                GenericValue mapKeyClassValue = attribute.getAttributeModelHelper().getMapKeyClass();
                PsiClass mapKeyClass = (PsiClass)mapKeyClassValue.getValue();
                if (mapKeyClass != null && !(mapKeyClass instanceof PsiTypeParameter)) {
                    mapKeyType = elementFactory.createType(mapKeyClass);
                }
            }
        }
        PsiType targetType = null;
        if (attribute instanceof PersistentRelationshipAttribute) {
            PersistentRelationshipAttribute relationshipAttribute = (PersistentRelationshipAttribute)attribute;
            GenericValue targetClassValue = relationshipAttribute.getTargetEntityClass();
            PsiClass targetClass = (PsiClass)targetClassValue.getValue();
            if (targetClass != null) {
                targetType = elementFactory.createType(targetClass);
                PersistentObject persistentObject = (PersistentObject)browser.queryPersistentObjects(targetClass, PersistenceClassRoleEnum.ENTITY).findFirst();
                if (!Boolean.FALSE.equals(forceCalcMapKey) && typeInfo.containerType == JavaContainerType.MAP) {
                    PsiType psiType;
                    GenericValue mapKeyValue = relationshipAttribute.getAttributeModelHelper().getMapKey();
                    PersistentAttribute keyAttr = (PersistentAttribute)mapKeyValue.getValue();
                    Object object = keyAttr != null ? keyAttr.getPsiType() : (psiType = persistentObject instanceof PersistentEntityBase && mapKeyValue instanceof JamAttributeElement && ((JamAttributeElement)mapKeyValue).getPsiElement() == null && ((JamAttributeElement)mapKeyValue).getParentAnnotationElement().getPsiElement() != null ? PersistenceCommonUtil.getPrimaryKeyClass((PersistentEntityBase)((PersistentEntityBase)persistentObject), (PersistenceModelBrowser)browser) : null);
                    if (psiType != null) {
                        mapKeyType = psiType;
                    }
                }
            }
        } else if (attribute instanceof PersistentCollectionAttribute) {
            GenericValue typeValue = ((PersistentCollectionAttribute)attribute).getComponentType();
            targetType = (PsiType)typeValue.getValue();
        }
        if (mapKeyType != null || targetType != null) {
            if (mapKeyType != null && typeInfo.containerType == JavaContainerType.MAP && typeInfo.parameters.length > 1) {
                typeInfo.parameters[1] = mapKeyType;
            }
            if (targetType != null) {
                if (JavaContainerType.isCollectionOrMap((JavaContainerType)typeInfo.containerType) && typeInfo.parameters.length > 0) {
                    typeInfo.parameters[0] = targetType;
                } else {
                    typeInfo = new JavaTypeInfo(typeInfo.containerType, targetType, new PsiType[0]);
                }
            }
        }
        return typeInfo;
    }

    @NotNull
    public static GenericDomValue<String> toGenericStringValue(@NotNull Class<?> caller, final @NotNull Getter<? extends GenericDomValue<?>> valueWrapper) {
        if (caller == null) {
            JpaUtil.$$$reportNull$$$0(23);
        }
        if (valueWrapper == null) {
            JpaUtil.$$$reportNull$$$0(24);
        }
        Class[] interfaces = new Class[]{valueWrapper.get() instanceof GenericAttributeValue ? GenericAttributeValue.class : GenericDomValue.class};
        Object result = Proxy.newProxyInstance(caller.getClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                GenericDomValue delegate = (GenericDomValue)valueWrapper.get();
                if (args != null && args.length == 1 && "setValue".equals(method.getName())) {
                    delegate.setStringValue((String)args[0]);
                    return null;
                }
                if (args == null && "getValue".equals(method.getName())) {
                    return delegate.getStringValue();
                }
                return method.invoke((Object)delegate, args);
            }
        });
        GenericDomValue genericDomValue = (GenericDomValue)result;
        if (genericDomValue == null) {
            JpaUtil.$$$reportNull$$$0(25);
        }
        return genericDomValue;
    }

    public static Collection<PsiMember> getAccessingMethodsFor(PsiElement psiElement) {
        SmartList foundMembers = new SmartList();
        if (psiElement == null) {
            return foundMembers;
        }
        JvmPsiConversionHelper helper = JvmPsiConversionHelper.getInstance((Project)psiElement.getProject());
        for (JvmElement jvmElement : JvmDeclarationSearch.getElementsByIdentifier((PsiElement)psiElement)) {
            if (!(jvmElement instanceof JvmMethod)) continue;
            foundMembers.add(helper.convertMethod((JvmMethod)jvmElement));
        }
        return foundMembers;
    }

    public static Collection<PsiMember> getCorrespondingFieldsFor(UParameter uParameter) {
        UClass containingClass = UastUtils.getContainingUClass((UElement)uParameter);
        String parameterName = uParameter.getName();
        if (containingClass == null || parameterName == null) {
            return ContainerUtil.emptyList();
        }
        return Arrays.stream(containingClass.getFields()).filter(field -> parameterName.equals(field.getName())).map(field -> (PsiMember)field.getJavaPsi()).collect(Collectors.toList());
    }

    public static Collection<PsiClass> getEntityListenerClasses(@NotNull Project project) {
        if (project == null) {
            JpaUtil.$$$reportNull$$$0(26);
        }
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> new CachedValueProvider.Result(JpaUtil.calculateEntityListenerClasses(project), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static UserResponse.AttributeInfo getTestUserResponse() {
        return new UserResponse.AttributeInfo("testName", (PsiType)PsiType.LONG, false, false);
    }

    private static Collection<PsiClass> calculateEntityListenerClasses(Project project) {
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet();
        for (String anno : JpaAnnotationConstants.ENTITY_LISTENERS_ANNO.all()) {
            PsiClass annoPsiClass = JavaPsiFacade.getInstance((Project)project).findClass(anno, GlobalSearchScope.allScope((Project)project));
            if (annoPsiClass == null || !annoPsiClass.isAnnotationType()) continue;
            for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)annoPsiClass, (SearchScope)GlobalSearchScope.projectScope((Project)project)).findAll()) {
                for (JamClassAttributeElement element : EntityListenerImpl.ENTITY_LISTENERS_CLASSES.getJam(PersistentObjectImpl.getJavaeeAnnotationRef(JpaAnnotationConstants.ENTITY_LISTENERS_ANNO, psiMember, anno.startsWith(JavaeeType.JAVAX.pkg) ? JavaeeType.JAVAX : JavaeeType.JAKARTA))) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)element.getValue());
                }
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/util/JpaUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistenceUnit";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caller";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueWrapper";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJpaVersion";
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/util/JpaUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnits";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryParams";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseXmlFiles";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toGenericStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areJpa20ClassesAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isExcludeUnlistedClasses";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPersistenceUnitProperty";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setPersistenceUnitProperty";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isHibernateProvider";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isEclipseLinkProvider";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toGenericStringValue";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getEntityListenerClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

