/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.providers;

import com.intellij.jam.JavaLibraryUtils;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProviderBase;
import com.intellij.jpa.JpaLibraryCoordinates;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import icons.JavaUltimateIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateProvider
extends JpaImplementationProviderBase {
    @NonNls
    public static final String PROVIDER_JPA_21 = "org.hibernate.jpa.HibernatePersistenceProvider";
    @NonNls
    public static final String PROVIDER_JPA_20 = "org.hibernate.ejb.HibernatePersistence";
    @NonNls
    public static final String HIBERNATE_PREFIX = "hibernate.";
    @NonNls
    public static final String DRIVER = "hibernate.connection.driver_class";
    @NonNls
    public static final String URL = "hibernate.connection.url";
    @NonNls
    public static final String USER = "hibernate.connection.username";
    @NonNls
    public static final String PASSWORD = "hibernate.connection.password";

    public HibernateProvider() {
        super("Hibernate", PROVIDER_JPA_21, DRIVER, URL, USER, PASSWORD);
    }

    @Nullable
    public Icon getProviderIcon() {
        return JavaUltimateIcons.Javaee.Hibernate;
    }

    @Override
    @Nullable
    protected String getPropertyAlias(String propertyName) {
        return propertyName.substring(HIBERNATE_PREFIX.length());
    }

    @Override
    public void setDefaultProperties(@NotNull PersistenceUnit unit) {
        if (unit == null) {
            HibernateProvider.$$$reportNull$$$0(0);
        }
        super.setDefaultProperties(unit);
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.archive.autodetection", null, "class");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.show_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.format_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.format_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.hbm2ddl.auto", null, "update");
    }

    @Nullable
    public Pair<String, String> getUserDefinedNamingStrategyProperty(@NonNls PersistenceFacet facet, @NotNull PersistencePackage unit) {
        Module module;
        PsiClass namingStrategyPsiClass;
        String namingStrategyClass;
        if (unit == null) {
            HibernateProvider.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(namingStrategyClass = facet.getNamingStrategy(unit))) && (namingStrategyPsiClass = JavaPsiFacade.getInstance((Project)(module = facet.getModule()).getProject()).findClass(namingStrategyClass, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            String propertyName = InheritanceUtil.isInheritor((PsiClass)namingStrategyPsiClass, (String)"org.hibernate.boot.model.naming.ImplicitNamingStrategy") ? "hibernate.implicit_naming_strategy" : "hibernate.physical_naming_strategy";
            return Pair.create((Object)propertyName, (Object)namingStrategyClass);
        }
        return null;
    }

    @Override
    public String getProviderClassName(@Nullable Module module) {
        return HibernateProvider.getProvider(module);
    }

    @NotNull
    public static String getProvider(@Nullable Module module) {
        if (JavaLibraryUtils.hasLibraryClass((Module)module, (String)PROVIDER_JPA_21)) {
            return PROVIDER_JPA_21;
        }
        return PROVIDER_JPA_20;
    }

    @NotNull
    public List<JpaLibraryCoordinates> getAutoDetectionCoordinates() {
        List<JpaLibraryCoordinates> list = Arrays.asList(new JpaLibraryCoordinates("org.hibernate", "hibernate-core"), new JpaLibraryCoordinates("org.hibernate.orm", "hibernate-core"));
        if (list == null) {
            HibernateProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/providers/HibernateProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/providers/HibernateProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoDetectionCoordinates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProperties";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedNamingStrategyProperty";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

