/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.generation.ORMToAnnotationsConverter;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.manipulators.AbstractPersistenceAction;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceMappingsManipulator;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValueUtil;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MappingsManipulatorBase<T extends PersistenceMappings>
extends AbstractPersistenceManipulator<T>
implements PersistenceMappingsManipulator<T> {
    public MappingsManipulatorBase(T target) {
        super(target);
    }

    static PsiClass getOrCreateAnnotatedClass(@NotNull String className, @NotNull PsiDirectory targetDirectory, @Nullable String annotationText) {
        if (className == null) {
            MappingsManipulatorBase.$$$reportNull$$$0(0);
        }
        if (targetDirectory == null) {
            MappingsManipulatorBase.$$$reportNull$$$0(1);
        }
        IdeDocumentHistory.getInstance((Project)targetDirectory.getProject()).includeCurrentPlaceAsChangePlace();
        try {
            PsiModifierList modifierList;
            PsiClass psiClass = MappingsManipulatorBase.getExistingClass(className, targetDirectory);
            if (psiClass == null) {
                psiClass = JavaDirectoryService.getInstance().createClass(targetDirectory, className);
            }
            if ((modifierList = psiClass.getModifierList()) != null && annotationText != null) {
                PsiAnnotation existingAnnotation;
                PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createAnnotationFromText(annotationText, null);
                PsiAnnotation psiAnnotation = existingAnnotation = annotation.getQualifiedName() != null ? modifierList.findAnnotation(annotation.getQualifiedName()) : null;
                if (existingAnnotation != null) {
                    existingAnnotation.replace((PsiElement)annotation);
                } else {
                    modifierList.addAfter((PsiElement)annotation, null);
                }
            }
            PsiClass aClass = (PsiClass)JavaCodeStyleManager.getInstance((Project)psiClass.getProject()).shortenClassReferences((PsiElement)psiClass);
            PostprocessReformattingAspect.getInstance((Project)aClass.getProject()).doPostponedFormatting();
            return aClass;
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    static PsiClass getExistingClass(String className, PsiDirectory targetDirectory) {
        PsiFile file = targetDirectory.findFile(className + "." + StdFileTypes.JAVA.getDefaultExtension());
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            PsiJavaFile javaFile = (PsiJavaFile)file;
            for (PsiClass curClass : javaFile.getClasses()) {
                if (!Objects.equals(curClass.getName(), className)) continue;
                return curClass;
            }
        }
        return null;
    }

    @NotNull
    protected <T extends PersistentObject> Pair<T, PsiClass> addPersistentObject(PersistencePackage unit, Class<T> aClass, JamClassMeta<?> jamMeta, Pair<PsiDirectory, String> pair, @Nullable String annotationName) {
        String rootAnnotation = StringUtil.isNotEmpty((String)annotationName) ? annotationName : JamCommonUtil.getFirstRootAnnotation(jamMeta);
        PsiClass psiClass = MappingsManipulatorBase.getOrCreateAnnotatedClass((String)pair.getSecond(), (PsiDirectory)pair.getFirst(), rootAnnotation == null ? null : "@" + rootAnnotation);
        Pair pair2 = Pair.create((Object)((PersistentObject)this.getOrCreateModelObject(unit, aClass, jamMeta, psiClass)), (Object)psiClass);
        if (pair2 == null) {
            MappingsManipulatorBase.$$$reportNull$$$0(2);
        }
        return pair2;
    }

    @NotNull
    protected <T extends PersistenceListener> Pair<T, PsiClass> addPersistenceListener(PersistencePackage unit, Class<T> aClass, JamClassMeta<?> jamMeta, Pair<PsiDirectory, String> pair) {
        String rootAnnotation = JamCommonUtil.getFirstRootAnnotation(jamMeta);
        PsiClass psiClass = MappingsManipulatorBase.getOrCreateAnnotatedClass((String)pair.getSecond(), (PsiDirectory)pair.getFirst(), rootAnnotation == null ? null : "@" + rootAnnotation);
        Pair pair2 = Pair.create((Object)((PersistenceListener)this.getOrCreateModelObject(unit, aClass, jamMeta, psiClass)), (Object)psiClass);
        if (pair2 == null) {
            MappingsManipulatorBase.$$$reportNull$$$0(3);
        }
        return pair2;
    }

    protected <T extends PersistentObject> T addPersistentObject(PsiDirectory directory, PersistencePackage unit, Class<T> aClass, JamClassMeta<?> jamMeta, String shortClassName, @Nullable String annotationName) throws IncorrectOperationException {
        return (T)((PersistentObject)this.addPersistentObject(unit, aClass, jamMeta, (Pair<PsiDirectory, String>)Pair.create((Object)directory, (Object)shortClassName), annotationName).getFirst());
    }

    @Nullable
    protected abstract <T> T getOrCreateModelObject(PersistencePackage var1, Class<T> var2, JamClassMeta<?> var3, PsiClass var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/model/manipulators/MappingsManipulatorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/model/manipulators/MappingsManipulatorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addPersistentObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addPersistenceListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateAnnotatedClass";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class MyActionBase<V extends CommonModelElement>
    extends AbstractPersistenceAction<MappingsManipulatorBase<? extends PersistenceMappings>> {
        protected PersistenceFacet myFacet;
        protected PersistencePackage myUnit;
        protected Pair<PsiDirectory, String> myPair;

        public MyActionBase(MappingsManipulatorBase<?> manipulator, String actionName, Icon icon, @Nls String objectType) {
            super(manipulator, actionName, objectType, icon);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            this.myFacet = (PersistenceFacet)e.getData(PersistenceDataKeys.PERSISTENCE_FACET);
            this.myUnit = (PersistencePackage)e.getData(PersistenceDataKeys.PERSISTENCE_UNIT);
            this.getPresentation().setEnabled(this.myUnit != null && !JamCommonUtil.isInLibrary((CommonModelElement)this.myUnit));
        }

        public boolean preInvoke(UserResponse response) {
            Module module = ((PersistenceMappings)((MappingsManipulatorBase)this.getManipulator()).getManipulatorTarget()).getModule();
            assert (module != null);
            this.myPair = response.getClassName(module, JpaMessages.message((String)"dialog.title.new.typename", (Object[])new Object[]{this.getPresentation().getText()}), "newEJBpersistence_create");
            if (this.myPair != null && this.myPair.getFirst() != null) {
                ORMToAnnotationsConverter.ensureJpaApiLibraryExists(module);
                return true;
            }
            return false;
        }

        public void addAffectedElements(@NotNull Collection<PsiElement> affectedElements) {
            if (affectedElements == null) {
                MyActionBase.$$$reportNull$$$0(0);
            }
            PersistenceMappings mappings = (PersistenceMappings)((MappingsManipulatorBase)this.getManipulator()).getManipulatorTarget();
            ContainerUtil.addIfNotNull(affectedElements, (Object)mappings.getIdentifyingPsiElement());
            ContainerUtil.addIfNotNull(affectedElements, (Object)MappingsManipulatorBase.getExistingClass((String)this.myPair.getSecond(), (PsiDirectory)this.myPair.getFirst()));
            boolean domMode = mappings instanceof DomElement;
            if (!domMode || !GenericValueUtil.containsValue((Collection)this.myUnit.getModelHelper().getMappingFiles(PersistenceMappings.class), (Object)mappings)) {
                ContainerUtil.addIfNotNull(affectedElements, (Object)this.myUnit.getIdentifyingPsiElement());
            }
        }

        public void invokeAction(@NotNull Collection<PsiElement> result) {
            Pair<V, PsiClass> pair;
            if (result == null) {
                MyActionBase.$$$reportNull$$$0(1);
            }
            if ((pair = this.createClassAndModelObject()).getFirst() != null) {
                result.add(((CommonModelElement)pair.getFirst()).getIdentifyingPsiElement());
            }
            result.add((PsiElement)pair.getSecond());
        }

        protected abstract Pair<V, PsiClass> createClassAndModelObject();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affectedElements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jpa/model/manipulators/MappingsManipulatorBase$MyActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAffectedElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MyObjectAction<V extends PersistentObject>
    extends MyActionBase<V> {
        protected final Class<V> myClazz;
        protected final JamClassMeta<?> myJamMeta;

        public MyObjectAction(MappingsManipulatorBase manipulator, String actionName, Icon icon, Class<V> clazz, JamClassMeta<?> jamMeta, @Nls String objectType) {
            super(manipulator, actionName, icon, objectType);
            this.myClazz = clazz;
            this.myJamMeta = jamMeta;
        }

        @Override
        protected Pair<V, PsiClass> createClassAndModelObject() {
            return ((MappingsManipulatorBase)this.getManipulator()).addPersistentObject(this.myUnit, this.myClazz, this.myJamMeta, (Pair<PsiDirectory, String>)this.myPair, null);
        }

        protected PsiElement getTargetElement() {
            return ((PersistenceMappings)((MappingsManipulatorBase)this.getManipulator()).getManipulatorTarget()).getIdentifyingPsiElement();
        }

        public int getGroupId() {
            return 40;
        }
    }

    protected static class MyListenerAction<V extends PersistenceListener>
    extends MyActionBase<V> {
        protected final Class<V> myClazz;
        protected final JamClassMeta<?> myJamMeta;
        protected PsiClass myNewClass;

        public MyListenerAction(MappingsManipulatorBase manipulator, String actionName, Icon icon, Class<V> clazz, JamClassMeta<?> jamMeta, @Nls String objectType) {
            super(manipulator, actionName, icon, objectType);
            this.myClazz = clazz;
            this.myJamMeta = jamMeta;
        }

        @Override
        protected Pair<V, PsiClass> createClassAndModelObject() {
            Pair<V, PsiClass> pair = ((MappingsManipulatorBase)this.getManipulator()).addPersistenceListener(this.myUnit, this.myClazz, this.myJamMeta, (Pair<PsiDirectory, String>)this.myPair);
            this.myNewClass = (PsiClass)pair.getSecond();
            return pair;
        }

        public int getGroupId() {
            return 30;
        }

        public boolean postInvoke(PersistenceAction action, UserResponse response) {
            response.askUserToSetupListener(action, this.myFacet, this.myNewClass);
            return true;
        }

        protected PsiElement getTargetElement() {
            return null;
        }
    }
}

