/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.implicit;

import com.intellij.javaee.model.common.persistence.mapping.EntityMappings;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.PersistenceUnitPropertiesProvider;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFrameworkSupportProvider;
import com.intellij.jpa.model.implicit.UnitPropertiesUtilsKt;
import com.intellij.jpa.providers.HibernateProvider;
import com.intellij.openapi.util.Key;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.helpers.PersistenceUnitModelHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualPersistenceUnitModelHelper
implements PersistenceUnitModelHelper {
    private static final Key<String> PROPERTY_PROFILE_KEY = Key.create((String)"virtual.unit.property.profile");
    private Map<String, Properties> myPropertyProfiles;
    private final JpaFacet myFacet;

    public VirtualPersistenceUnitModelHelper(JpaFacet facet) {
        this.myFacet = facet;
        this.myPropertyProfiles = new HashMap<String, Properties>();
    }

    public GenericValue<Boolean> getExcludeUnlistedClasses() {
        return ReadOnlyGenericValue.getInstance((Object)Boolean.FALSE);
    }

    @Nullable
    public String getPersistenceProviderName() {
        JpaImplementationProvider provider = JpaFrameworkSupportProvider.findProviderByName(((JpaFacetConfiguration)this.myFacet.getConfiguration()).getDefaultJPAProviderName());
        return provider != null ? provider.getProviderClassName(this.myFacet.getModule()) : HibernateProvider.getProvider(this.myFacet.getModule());
    }

    @Nullable
    public PersistenceMappings getAdditionalMapping() {
        return null;
    }

    @NotNull
    public <V extends PersistenceMappings> List<? extends GenericValue<V>> getMappingFiles(Class<V> mappingsClass) {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<? extends PersistenceListener> getPersistentListeners() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiFile>> getJarFiles() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiClass>> getClasses() {
        EntityMappings mappings = this.myFacet.getAnnotationEntityMappings();
        if (mappings == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = ContainerUtil.map((Collection)mappings.getEntities(), entity -> entity.getClazz());
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiPackage>> getPackages() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public GenericValue<String> getDataSourceName() {
        return null;
    }

    public Set<String> getPropertiesSources() {
        this.updatePropertyProfiles();
        return this.myPropertyProfiles.keySet();
    }

    private void updatePropertyProfiles() {
        this.myPropertyProfiles = StreamEx.of((Collection)PersistenceUnitPropertiesProvider.EP_NAME.getExtensionList()).flatMapToEntry(it -> it.getPropertyProfiles(this.myFacet.getModule())).toMap();
        if (this.getActivePropertyProfile() == null) {
            this.setActivePropertyProfile(null);
        }
    }

    @NotNull
    public Properties getPersistenceUnitProperties() {
        this.updatePropertyProfiles();
        Properties properties = this.useProviderSpecificKeys(this.myPropertyProfiles.get(this.getActivePropertyProfile()));
        if (properties == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(6);
        }
        return properties;
    }

    public void setActivePropertyProfile(@Nullable String profileLocation) {
        String activeProfile = null;
        if (profileLocation == null) {
            Optional defaultProfile = this.myPropertyProfiles.entrySet().stream().findFirst();
            if (defaultProfile.isPresent()) {
                activeProfile = (String)((Map.Entry)defaultProfile.get()).getKey();
            }
        } else {
            activeProfile = profileLocation;
        }
        this.myFacet.putUserData(PROPERTY_PROFILE_KEY, (Object)activeProfile);
    }

    public String getActivePropertyProfile() {
        return (String)this.myFacet.getUserData(PROPERTY_PROFILE_KEY);
    }

    private Properties useProviderSpecificKeys(Properties properties) {
        Properties result = new Properties();
        if (properties == null) {
            return result;
        }
        Function<String, String> mapper = VirtualPersistenceUnitModelHelper.chooseProviderMapping(this.getPersistenceProviderName());
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            String stringKey = (String)key;
            result.setProperty(mapper.apply(stringKey), properties.getProperty(stringKey));
        }
        return result;
    }

    private static Function<String, String> chooseProviderMapping(String providerName) {
        if (providerName == null) {
            return Function.identity();
        }
        switch (providerName) {
            case "org.hibernate.ejb.HibernatePersistence": 
            case "org.hibernate.jpa.HibernatePersistenceProvider": {
                return UnitPropertiesUtilsKt::toHibernateNotation;
            }
            case "org.apache.openjpa.persistence.PersistenceProviderImpl": {
                return UnitPropertiesUtilsKt::toOpenJpaNotation;
            }
            case "oracle.toplink.essentials.PersistenceProvider": {
                return UnitPropertiesUtilsKt::toToplinkNotation;
            }
            case "org.eclipse.persistence.jpa.PersistenceProvider": {
                return UnitPropertiesUtilsKt::toEclipseLinkNotation;
            }
        }
        return Function.identity();
    }

    public Collection<Object> getCacheDependencies() {
        return ContainerUtil.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jpa/model/implicit/VirtualPersistenceUnitModelHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentListeners";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnitProperties";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

