/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.implicit;

import com.intellij.jpa.PersistenceUnitPropertiesProvider;
import com.intellij.jpa.model.implicit.ApplicationPropertiesProvider$findPossiblePropertyFilesCandidates$;
import com.intellij.jpa.model.implicit.FrameworkSpecificUnitOptions;
import com.intellij.jpa.model.implicit.UnitPropertiesUtilsKt;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jpa/model/implicit/ApplicationPropertiesProvider;", "Lcom/intellij/jpa/PersistenceUnitPropertiesProvider;", "()V", "findPossiblePropertyFilesCandidates", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "module", "Lcom/intellij/openapi/module/Module;", "findPropertyByKeyPattern", "Lcom/intellij/lang/properties/IProperty;", "keyPattern", "Lkotlin/text/Regex;", "propertiesFile", "getPropertiesModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getPropertyProfiles", "", "", "Ljava/util/Properties;", "intellij.javaee.jpa.impl"})
final class ApplicationPropertiesProvider
implements PersistenceUnitPropertiesProvider {
    @NotNull
    public Map<String, Properties> getPropertyProfiles(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        Object object = CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<HashMap<String, Properties>>(this, module, project2){
            final /* synthetic */ ApplicationPropertiesProvider this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<HashMap<String, Properties>> compute() {
                boolean bl = false;
                HashMap<K, V> result = new HashMap<K, V>();
                for (PropertiesFile propertiesFile : ApplicationPropertiesProvider.access$findPossiblePropertyFilesCandidates(this.this$0, this.$module)) {
                    ProgressManager.checkCanceled();
                    Properties properties = new Properties();
                    for (Regex key : FrameworkSpecificUnitOptions.INSTANCE.getAllKeyValuesRegexSet().keySet()) {
                        IProperty foundProperty = ApplicationPropertiesProvider.access$findPropertyByKeyPattern(this.this$0, key, propertiesFile);
                        if (foundProperty == null) continue;
                        String string = foundProperty.getKey();
                        if (string == null || (string = UnitPropertiesUtilsKt.toJpaNotation(string)) == null) {
                            continue;
                        }
                        String foundKey = string;
                        String string2 = foundProperty.getValue();
                        String valueWithDefaultParams = string2 != null ? UnitPropertiesUtilsKt.substituteDefaultUrlValues(string2, this.$module) : null;
                        ((Map)properties).put(foundKey, valueWithDefaultParams);
                    }
                    if (properties.isEmpty()) continue;
                    Map map = result;
                    PsiFile psiFile2 = propertiesFile.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"propertiesFile.containingFile");
                    String string = psiFile2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"propertiesFile.containingFile.name");
                    map.put(string, properties);
                }
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{ApplicationPropertiesProvider.access$getPropertiesModificationTracker(this.this$0, this.$project)});
            }
            {
                this.this$0 = applicationPropertiesProvider;
                this.$module = module;
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026onTracker(project))\n    }");
        return (Map)object;
    }

    private final Sequence<PropertiesFile> findPossiblePropertyFilesCandidates(Module module) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project2, (Collection)FileTypeIndex.getFiles((FileType)((FileType)PropertiesFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module)));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.filesS\u2026pendenciesScope(module)))");
        GlobalSearchScope propertyFilesScope = globalSearchScope;
        for (String marker : FrameworkSpecificUnitOptions.INSTANCE.getMarkerKeysSet()) {
            ProgressManager.checkCanceled();
            PsiSearchHelper.getInstance((Project)project2).processAllFilesWithWord(marker, propertyFilesScope, (Processor)collectProcessor, true);
        }
        Collection collection = collectProcessor.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectProcessor.results");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)collection);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findPossiblePropertyFilesCandidates$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return sequence;
    }

    private final IProperty findPropertyByKeyPattern(Regex keyPattern, PropertiesFile propertiesFile) {
        Iterator iterator = propertiesFile.getProperties().iterator();
        while (iterator.hasNext()) {
            IProperty property;
            IProperty iProperty = property = (IProperty)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"property");
            String string = iProperty.getKey();
            if (string == null) continue;
            CharSequence charSequence = string;
            boolean bl = false;
            boolean matches = keyPattern.matches(charSequence);
            if (!matches) continue;
            return property;
        }
        return null;
    }

    private final ModificationTracker getPropertiesModificationTracker(Project project) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        ModificationTracker modificationTracker = psiManager.getModificationTracker().forLanguage((Language)PropertiesLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"PsiManager.getInstance(p\u2026pertiesLanguage.INSTANCE)");
        return modificationTracker;
    }

    public static final /* synthetic */ Sequence access$findPossiblePropertyFilesCandidates(ApplicationPropertiesProvider $this, Module module) {
        return $this.findPossiblePropertyFilesCandidates(module);
    }

    public static final /* synthetic */ IProperty access$findPropertyByKeyPattern(ApplicationPropertiesProvider $this, Regex keyPattern, PropertiesFile propertiesFile) {
        return $this.findPropertyByKeyPattern(keyPattern, propertiesFile);
    }

    public static final /* synthetic */ ModificationTracker access$getPropertiesModificationTracker(ApplicationPropertiesProvider $this, Project project) {
        return $this.getPropertiesModificationTracker(project);
    }
}

