/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.javaee.model.common.persistence.JpaAnnotationConstants;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.requests.SimpleAnnotatedMethodRequest;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.ParametersKt;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJvmSubstitutor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

public class JpaEntityListenerWarningsInspection
extends AbstractUastJpaInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.jpa.inspections.JpaEntityListenerWarningsInspection");

    @NotNull
    public String getShortName() {
        return "JpaEntityListenerWarningsInspection";
    }

    @Override
    protected void checkClass(UClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        if (role.getEntityListener() == null) {
            return;
        }
        JpaEntityListenerWarningsInspection.checkNoListenerMethodsDefinedWarning(aClass, holder);
    }

    private static void checkNoListenerMethodsDefinedWarning(UClass aClass, ProblemsHolder holder) {
        Optional anyAnnotatedMethod = JpaInspectionUtil.findEntityListenerMethods(aClass).findAny();
        if (anyAnnotatedMethod.isPresent()) {
            return;
        }
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)aClass);
        if (sourcePsi == null) {
            return;
        }
        holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("entity.listener.class.has.no.annotated.methods", aClass.getName()), new LocalQuickFix[]{JpaEntityListenerWarningsInspection.createMethodsFix(aClass)});
    }

    private static LocalQuickFix createMethodsFix(final UClass aClass) {
        return new IntentionAndQuickFixAction(){

            @NotNull
            public String getName() {
                String string = this.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            @IntentionFamilyName
            public String getFamilyName() {
                String string = JpaHighlightingMessages.message("intention.family.generate.entity.listener.methods", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                JpaEntityListenerWarningsInspection.createEntityListenerMethods(aClass, project, file, editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void createEntityListenerMethods(UClass aClass, Project project, PsiFile file, Editor editor) {
        if (file == null || editor == null) {
            return;
        }
        PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)aClass.getJavaPsi().getManager(), (GlobalSearchScope)aClass.getJavaPsi().getResolveScope());
        Map<String, UMethod> existingMethods = JpaEntityListenerWarningsInspection.findExistingListenerMethods(aClass, javaLangObject);
        for (EntityListenerMethodType type : EntityListenerMethodType.values()) {
            if (existingMethods.get(StringUtil.decapitalize((String)type.getTypeName())) != null) continue;
            JpaEntityListenerWarningsInspection.runAction((IntentionAction)ContainerUtil.getFirstItem(JpaEntityListenerWarningsInspection.createMethodAction(aClass, type, javaLangObject)), project, editor, file);
        }
        UClass updatedUClass = (UClass)UastContextKt.toUElement((PsiElement)aClass.getSourcePsi(), UClass.class);
        if (updatedUClass != null) {
            aClass = updatedUClass;
        } else {
            LOG.error("Wasn't able to update uClass", new Attachment[]{new Attachment(file.getName(), file.getText())});
        }
        existingMethods = JpaEntityListenerWarningsInspection.findExistingListenerMethods(aClass, javaLangObject);
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)file, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO);
        for (EntityListenerMethodType type : EntityListenerMethodType.values()) {
            PsiMethod psiMethod;
            UMethod method = existingMethods.get(StringUtil.decapitalize((String)type.getTypeName()));
            if (method == null || method.findAnnotation(type.getMethodAnnotation().fqn(javaeeType)) != null || (psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)method, PsiMethod.class)) == null) continue;
            JpaEntityListenerWarningsInspection.runAction((IntentionAction)ContainerUtil.getFirstItem((List)JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)psiMethod, (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)type.getMethodAnnotation().fqn(javaeeType), (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]))), project, editor, file);
        }
    }

    private static Map<String, UMethod> findExistingListenerMethods(UClass aClass, PsiClassType objectType) {
        return ((StreamEx)StreamEx.of((Object[])aClass.getMethods()).filter(method -> method.getUastParameters().size() == 1 && TypeConversionUtil.isAssignable((PsiType)objectType, (PsiType)((UParameter)method.getUastParameters().get(0)).getType()))).toMap(method -> method.getName(), method -> method);
    }

    private static void runAction(IntentionAction action, Project project, Editor editor, PsiFile file) {
        if (action == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            action.invoke(project, editor, file);
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
            if (templateState != null) {
                templateState.gotoEnd(false);
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(PsiDocumentManager.getInstance((Project)project).getDocument(file));
        });
    }

    private static List<IntentionAction> createMethodAction(UClass aClass, EntityListenerMethodType type, PsiClassType objectType) {
        return JvmElementActionFactories.createMethodActions((JvmClass)aClass.getJavaPsi(), (CreateMethodRequest)new SimpleAnnotatedMethodRequest(StringUtil.decapitalize((String)type.getTypeName()), Collections.singletonList(JvmModifier.PUBLIC), (JvmType)PsiType.VOID, AnnotationRequestsKt.annotationRequest((String)type.getMethodAnnotation().fqn((PsiElement)aClass.getPsi()), (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]), ParametersKt.expectedParameter((JvmType)objectType, (String[])new String[]{"o"}), (JvmSubstitutor)new PsiJvmSubstitutor(aClass.getJavaPsi().getProject(), PsiSubstitutor.EMPTY)));
    }
}

