/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodContainer;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.highlighting.RemoveQuickFix;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastVisibility;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jpa/inspections/JpaEntityListenerInspection;", "Lcom/intellij/jpa/inspections/AbstractUastJpaInspection;", "()V", "checkClass", "", "aClass", "Lorg/jetbrains/uast/UClass;", "role", "Lcom/intellij/persistence/roles/PersistenceClassRole;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkEntityListenerMethodSignature", "uMethod", "Lorg/jetbrains/uast/UMethod;", "checkListenerMethods", "getShortName", "", "reportMultipleAnnotationsOfSameType", "method", "type", "Lcom/intellij/javaee/model/common/persistence/mapping/EntityListenerMethodType;", "intellij.javaee.jpa.impl"})
public final class JpaEntityListenerInspection
extends AbstractUastJpaInspection {
    @NotNull
    public String getShortName() {
        return "JpaEntityListenerInspection";
    }

    @Override
    protected void checkClass(@NotNull UClass aClass, @NotNull PersistenceClassRole role, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (role.getType() == PersistenceClassRoleEnum.ENTITY_LISTENER) {
            JpaInspectionUtil.checkNoArgConstructorExists(aClass, holder, UastVisibility.PUBLIC);
        }
        if (role.getEntityListener() instanceof EntityListenerMethodContainer || role.getPersistentObject() instanceof EntityListenerMethodContainer) {
            this.checkListenerMethods(aClass, role, holder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkListenerMethods(UClass aClass, PersistenceClassRole role, ProblemsHolder holder) {
        Map map = JpaInspectionUtil.findEntityListenerMethods(aClass).grouping();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"JpaInspectionUtil.findEn\u2026aClass)\n      .grouping()");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            List methods;
            Map.Entry element$iv;
            Map.Entry $dstr$type$methods = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$type$methods;
            boolean bl3 = false;
            EntityListenerMethodType entityListenerMethodType = (EntityListenerMethodType)entry.getKey();
            entry = $dstr$type$methods;
            bl3 = false;
            List list = methods = (List)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"methods");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UMethod it = (UMethod)element$iv2;
                boolean bl4 = false;
                if (methods.size() > 1) {
                    void type;
                    UMethod uMethod = it;
                    Intrinsics.checkNotNullExpressionValue((Object)uMethod, (String)"it");
                    void v3 = type;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"type");
                    this.reportMultipleAnnotationsOfSameType(uMethod, (EntityListenerMethodType)v3, aClass, holder);
                }
                UMethod uMethod = it;
                Intrinsics.checkNotNullExpressionValue((Object)uMethod, (String)"it");
                this.checkEntityListenerMethodSignature(uMethod, role, holder);
            }
        }
    }

    private final void reportMultipleAnnotationsOfSameType(UMethod method, EntityListenerMethodType type, UClass aClass, ProblemsHolder holder) {
        block0: {
            PsiElement psiElement = UDeclarationKt.getAnchorPsi((UDeclaration)((UDeclaration)method));
            if (psiElement == null) break block0;
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement2;
            boolean bl3 = false;
            String string = JpaHighlightingMessages.message("more.than.one.method.defined.for.entity.listener.method.type", type.getTypeName(), aClass.getJavaPsi().getName());
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            String string2 = type.getMethodAnnotation().fqn((PsiElement)aClass.getJavaPsi());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.methodAnnotation.fqn(aClass.javaPsi)");
            UAnnotation uAnnotation = method.findAnnotation(string2);
            localQuickFixArray[0] = new RemoveQuickFix(uAnnotation != null ? uAnnotation.getJavaPsi() : null);
            holder.registerProblem(it, string, localQuickFixArray);
        }
    }

    private final void checkEntityListenerMethodSignature(UMethod uMethod, PersistenceClassRole role, ProblemsHolder holder) {
        JpaInspectionUtil.checkMethodReturnType(uMethod, holder, (PsiType)PsiType.VOID);
        if (role.getType() == PersistenceClassRoleEnum.ENTITY_LISTENER) {
            PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
            PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)uMethod.getJavaPsi().getManager(), (GlobalSearchScope)uMethod.getJavaPsi().getResolveScope());
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"PsiType.getJavaLangObjec\u2026hod.javaPsi.resolveScope)");
            PsiClassType objectType = psiClassType;
            List parameters = uMethod.getUastParameters();
            if (parameters.size() == 1 && TypeConversionUtil.isAssignable((PsiType)((PsiType)objectType), (PsiType)((UParameter)parameters.get(0)).getType())) {
                PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)TypeConversionUtil.erasure((PsiType)((UParameter)parameters.get(0)).getType()));
                for (PersistenceClassRole classRole : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
                    if (!browser.acceptsRole(classRole)) continue;
                    PersistenceClassRole persistenceClassRole = classRole;
                    Intrinsics.checkNotNullExpressionValue((Object)persistenceClassRole, (String)"classRole");
                    if (persistenceClassRole.getType() != PersistenceClassRoleEnum.ENTITY && classRole.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS) continue;
                    return;
                }
            }
            JpaInspectionUtil.checkMethodParameters(uMethod, holder, (PsiType)objectType);
        } else {
            JpaInspectionUtil.checkMethodParameters(uMethod, holder, new PsiType[0]);
        }
    }
}

