/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.JamClassAttributeElement;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.common.persistence.JpaAnnotationConstants;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentCollectionAttribute;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public class JpaAttributeTypeInspection
extends AbstractUastJpaInspection {
    @NotNull
    public String getShortName() {
        return "JpaAttributeTypeInspection";
    }

    @Override
    protected void checkClass(UClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        PersistentObject object = role.getPersistentObject();
        if (object != null) {
            JpaAttributeTypeInspection.checkIdClassAnnotation(holder, object);
            JpaAttributeTypeInspection.checkObjectMembers(aClass, object, role, holder);
        }
    }

    private static void checkIdClassAnnotation(ProblemsHolder holder, PersistentObject object) {
        GenericValue value;
        JamClassAttributeElement element;
        if (object instanceof PersistentEntityBase && (element = (JamClassAttributeElement)ModelMergerUtil.getImplementation((Object)(value = ((PersistentEntityBase)object).getIdClassValue()), JamClassAttributeElement.class)) != null) {
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)element.getValue(), UClass.class);
            if (uClass == null) {
                return;
            }
            JpaInspectionUtil.checkClassExtends(uClass.getJavaPsi(), "java.io.Serializable", true, JpaAttributeTypeInspection.getGenericValueAnchor(element), holder);
        }
    }

    private static void checkObjectMembers(UClass aClass, PersistentObject object, PersistenceClassRole role, ProblemsHolder holder) {
        if (role.getPersistentObject() == null) {
            return;
        }
        StreamEx.of((Object[])((UDeclaration[])aClass.getFields())).append((Object[])aClass.getMethods()).forEach(declaration -> JpaAttributeTypeInspection.checkObjectMember(declaration, object, role, holder));
    }

    private static void checkObjectMember(UDeclaration memberDeclaration, PersistentObject object, PersistenceClassRole role, ProblemsHolder holder) {
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
        PsiElement javaPsi = memberDeclaration.getJavaPsi();
        if (!(javaPsi instanceof PsiMember)) {
            return;
        }
        PsiMember psiMember = (PsiMember)javaPsi;
        List attributes = browser.getPersistenceAttributes(object, psiMember);
        ModelValidator validator = role.getFacet().getModelValidator(role.getPersistenceUnit());
        for (PersistentAttribute attribute : attributes) {
            JpaAttributeTypeInspection.checkAttributeJavaType(memberDeclaration, psiMember, attribute, validator, browser, holder);
        }
    }

    private static void checkAttributeJavaType(UDeclaration memberDeclaration, PsiMember psiMember, PersistentAttribute attribute, ModelValidator validator, PersistenceModelBrowser browser, ProblemsHolder holder) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"org.hibernate.annotations.Type", (int)0)) {
            return;
        }
        AttributeType attributeType = AttributeType.getAttributeType((PersistentAttribute)attribute);
        UTypeReferenceExpression uTypeReferenceExpression = JpaInspectionUtil.getMemberTypeReference(memberDeclaration);
        PsiType type = JpaInspectionUtil.getMemberType(memberDeclaration);
        PsiElement memberTypeElement = uTypeReferenceExpression == null ? null : uTypeReferenceExpression.getSourcePsi();
        PsiElement anchor = UDeclarationKt.getAnchorPsi((UDeclaration)memberDeclaration);
        if (anchor == null) {
            return;
        }
        JavaTypeInfo typeInfo = JpaAttributeTypeInspection.checkTypeAnnotationsAndSubstitute(psiMember, type, attributeType, attribute, browser, holder);
        if (typeInfo != null) {
            boolean isLob = attribute.getAttributeModelHelper().isLob();
            String errorMessage = validator.getAttributeTypeProblem(typeInfo, (PersistentAttributeType)attributeType, isLob);
            if (errorMessage != null) {
                JpaAttributeTypeInspection.registerProblem(holder, memberTypeElement == null ? anchor : memberTypeElement, errorMessage);
            } else if (attribute instanceof PersistentRelationshipAttribute) {
                PersistentRelationshipAttribute relationAttribute = (PersistentRelationshipAttribute)attribute;
                browser.queryTheOtherSideAttributes(relationAttribute, false).forEach(targetAttribute -> {
                    String message = validator.getRelationshipProblem(relationAttribute, targetAttribute);
                    if (message != null) {
                        JpaAttributeTypeInspection.registerProblem(holder, anchor, message);
                        return false;
                    }
                    return true;
                });
            } else if (attribute.getAttributeModelHelper().isIdAttribute()) {
                JpaInspectionUtil.checkClassExtends(PsiTypesUtil.getPsiClass((PsiType)type), "java.io.Serializable", true, memberTypeElement, holder);
            }
        }
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @Nullable PsiElement element, @NotNull @Nls String message) {
        if (holder == null) {
            JpaAttributeTypeInspection.$$$reportNull$$$0(0);
        }
        if (message == null) {
            JpaAttributeTypeInspection.$$$reportNull$$$0(1);
        }
        if (element != null && element.isValid() && element.isPhysical()) {
            holder.registerProblem(element, message, new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static JavaTypeInfo checkTypeAnnotationsAndSubstitute(PsiMember psiMember, PsiType type, AttributeType attributeType, PersistentAttribute attribute, PersistenceModelBrowser browser, ProblemsHolder holder) {
        PsiClassType boxedType;
        PsiClass targetClass;
        GenericValue typeValue;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiMember.getProject());
        JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)type, (PsiClass)JpaAttributeTypeInspection.getConvertClass(psiMember));
        PsiClassType mapKeyType = null;
        GenericValue mapKeyClassValue = attribute.getAttributeModelHelper().getMapKeyClass();
        PsiClass mapKeyClass = (PsiClass)mapKeyClassValue.getValue();
        if (mapKeyClass != null && !(mapKeyClass instanceof PsiTypeParameter)) {
            if (!JpaAttributeTypeInspection.checkContainerComponentType(typeInfo, mapKeyClassValue, mapKeyClass, PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY, holder)) {
                return null;
            }
            mapKeyType = elementFactory.createType(mapKeyClass);
        }
        PsiType targetType = null;
        if (attribute instanceof PersistentRelationshipAttribute) {
            PersistentRelationshipAttribute relationshipAttribute = (PersistentRelationshipAttribute)attribute;
            GenericValue targetClassValue = relationshipAttribute.getTargetEntityClass();
            PsiClass targetClass2 = (PsiClass)targetClassValue.getValue();
            if (targetClass2 != null) {
                PsiType psiType;
                GenericValue mapKeyValue;
                PersistentAttribute keyAttr;
                PsiElement anchor;
                targetType = elementFactory.createType(targetClass2);
                if (!JpaAttributeTypeInspection.checkContainerComponentType(typeInfo, targetClassValue, targetClass2, JavaContainerType.isCollectionOrMap((JavaContainerType)typeInfo.containerType) ? PersistentAttributeType.AttributeComponent.COLLECTION_VALUE : PersistentAttributeType.AttributeComponent.SINGLE, holder)) {
                    return null;
                }
                PersistentObject persistentObject = (PersistentObject)browser.queryPersistentObjects(targetClass2, PersistenceClassRoleEnum.ENTITY).findFirst();
                if (persistentObject == null && (anchor = JpaAttributeTypeInspection.getGenericValueAnchor(targetClassValue)) != null) {
                    holder.registerProblem(anchor, JpaHighlightingMessages.message("attribute.should.be.entity", attributeType.getTypeName()), new LocalQuickFix[0]);
                }
                Object object = (keyAttr = (PersistentAttribute)(mapKeyValue = relationshipAttribute.getAttributeModelHelper().getMapKey()).getValue()) != null ? keyAttr.getPsiType() : (psiType = persistentObject instanceof PersistentEntityBase && mapKeyValue instanceof JamAttributeElement && ((JamAttributeElement)mapKeyValue).getPsiElement() == null && ((JamAttributeElement)mapKeyValue).getParentAnnotationElement().getPsiElement() != null ? PersistenceCommonUtil.getPrimaryKeyClass((PersistentEntityBase)((PersistentEntityBase)persistentObject), (PersistenceModelBrowser)browser) : null);
                if (psiType != null) {
                    if (!JpaAttributeTypeInspection.checkContainerComponentType(typeInfo, mapKeyValue, PsiTypesUtil.getPsiClass((PsiType)psiType), PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY, holder)) {
                        return null;
                    }
                    mapKeyType = psiType;
                }
                if (mapKeyValue instanceof JamAttributeElement && ((JamAttributeElement)mapKeyValue).getPsiElement() != null) {
                    JpaAttributeTypeInspection.registerAnnotationProblem(mapKeyClassValue, JpaHighlightingMessages.message("attribute.mapkeyclass.with.mapkey.conflict", new Object[0]), holder);
                }
            }
        } else if (attribute instanceof PersistentCollectionAttribute && (targetType = (PsiType)(typeValue = ((PersistentCollectionAttribute)attribute).getComponentType()).getValue()) != null && (targetClass = targetType instanceof PsiPrimitiveType ? ((boxedType = ((PsiPrimitiveType)targetType).getBoxedType((PsiElement)psiMember)) == null ? null : boxedType.resolve()) : PsiTypesUtil.getPsiClass((PsiType)targetType)) != null && !JpaAttributeTypeInspection.checkContainerComponentType(typeInfo, typeValue, targetClass, JavaContainerType.isCollectionOrMap((JavaContainerType)typeInfo.containerType) ? PersistentAttributeType.AttributeComponent.COLLECTION_VALUE : PersistentAttributeType.AttributeComponent.SINGLE, holder)) {
            return null;
        }
        if (mapKeyType != null || targetType != null) {
            if (mapKeyType != null && typeInfo.containerType == JavaContainerType.MAP && typeInfo.parameters.length > 1) {
                typeInfo.parameters[1] = mapKeyType;
            }
            if (targetType != null) {
                if (JavaContainerType.isCollectionOrMap((JavaContainerType)typeInfo.containerType) && typeInfo.parameters.length > 0) {
                    typeInfo.parameters[0] = targetType;
                } else {
                    typeInfo = new JavaTypeInfo(typeInfo.containerType, targetType, new PsiType[0]);
                }
            }
        }
        return typeInfo;
    }

    @Nullable
    private static PsiClass getConvertClass(@NotNull PsiMember member) {
        PsiAnnotation convertAnno;
        if (member == null) {
            JpaAttributeTypeInspection.$$$reportNull$$$0(2);
        }
        return (convertAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, Arrays.asList(JpaAnnotationConstants.CONVERT_ANNO.all()))) != null ? (PsiClass)AnnotationModelUtil.getPsiClassValue((PsiAnnotation)convertAnno, (String)"converter", null).getValue() : null;
    }

    private static boolean checkContainerComponentType(JavaTypeInfo typeInfo, GenericValue<?> value, PsiClass valueClass, PersistentAttributeType.AttributeComponent component, ProblemsHolder holder) {
        PsiElement anchor;
        if (component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY && typeInfo.containerType != JavaContainerType.MAP || component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE && typeInfo.containerType == null) {
            JpaAttributeTypeInspection.registerAnnotationProblem(value, JpaHighlightingMessages.message("attribute.with.wrong.collection.type", new Object[0]), holder);
            return false;
        }
        PsiClass realClass = PsiTypesUtil.getPsiClass((PsiType)(component == PersistentAttributeType.AttributeComponent.SINGLE ? typeInfo.baseType : typeInfo.parameters[PersistentAttributeType.AttributeComponent.COLLECTION_VALUE == component ? 0 : 1]));
        if (!(realClass == null || valueClass == null || realClass instanceof PsiTypeParameter || realClass.getManager().areElementsEquivalent((PsiElement)realClass, (PsiElement)valueClass) || valueClass.isInheritor(realClass, true) || (anchor = JpaAttributeTypeInspection.getGenericValueAnchor(value)) == null)) {
            holder.registerProblem(anchor, JpaHighlightingMessages.message("attribute.types.should.be.compatible", valueClass.getQualifiedName(), realClass.getQualifiedName()), new LocalQuickFix[0]);
        }
        return true;
    }

    private static boolean registerAnnotationProblem(GenericValue<?> value, @Nls String errorMessage, ProblemsHolder holder) {
        if (!(value instanceof JamClassAttributeElement)) {
            return false;
        }
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElementOfExpectedTypes((PsiElement)((JamClassAttributeElement)value).getParentAnnotationElement().getPsiElement(), (Class[])new Class[]{UAnnotation.class});
        if (uAnnotation == null || uAnnotation.getSourcePsi() == null) {
            return false;
        }
        holder.registerProblem(uAnnotation.getSourcePsi(), errorMessage, new LocalQuickFix[0]);
        return true;
    }

    @Nullable
    private static PsiElement getGenericValueAnchor(GenericValue<?> value) {
        if (value instanceof JamAttributeElement) {
            JamAttributeElement attributeElement = (JamAttributeElement)value;
            PsiAnnotationMemberValue element = attributeElement.getPsiElement();
            if (element == null || element instanceof PsiCompiledElement) {
                return null;
            }
            UElement uElement = UastContextKt.toUElement((PsiElement)element);
            return uElement == null ? null : uElement.getSourcePsi();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/inspections/JpaAttributeTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConvertClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

