/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamElement;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.common.persistence.mapping.Basic;
import com.intellij.jpa.JpaVersion;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.highlighting.RemoveQuickFix;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.model.annotations.mapping.AttributeBaseImpl;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class JpaAttributeMemberSignatureInspection
extends AbstractUastJpaInspection {
    @NotNull
    public String getShortName() {
        return "JpaAttributeMemberSignatureInspection";
    }

    @Override
    protected void checkClass(UClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        if (role.getPersistentObject() == null) {
            return;
        }
        StreamEx.of((Object[])aClass.getFields()).append((Object[])aClass.getMethods()).forEach(member -> JpaAttributeMemberSignatureInspection.checkObjectMember(member, role, holder));
    }

    private static void checkObjectMember(UDeclaration memberDeclaration, PersistenceClassRole role, ProblemsHolder holder) {
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)memberDeclaration);
        if (sourcePsi == null) {
            return;
        }
        PersistentObject object = role.getPersistentObject();
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
        List attributes = browser.getPersistenceAttributes(object, (PsiMember)memberDeclaration.getJavaPsi());
        Collection<LocalQuickFix> quickFixes = JpaAttributeMemberSignatureInspection.checkMoreThanOneAttributeConfigured(ContainerUtil.filter((Collection)attributes, attribute -> !(attribute instanceof AttributeBaseImpl.BasicAttr)));
        if (!quickFixes.isEmpty()) {
            holder.registerProblem(sourcePsi, JpaAttributeMemberSignatureInspection.getErrorMessageForDeclaration(memberDeclaration), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
        if (!attributes.isEmpty()) {
            JpaAttributeMemberSignatureInspection.checkAttributeMembers(memberDeclaration, holder, role);
        }
        for (PersistentAttribute attribute2 : attributes) {
            JpaAttributeMemberSignatureInspection.checkAttributeType(memberDeclaration, holder, role, attribute2);
        }
    }

    @Nls
    private static String getErrorMessageForDeclaration(UDeclaration declaration) {
        if (declaration instanceof UMethod) {
            return JpaHighlightingMessages.message("more.than.one.attribute.configured.for.method", ((UMethod)declaration).getName());
        }
        return JpaHighlightingMessages.message("more.than.one.attribute.configured.for.field", ((UField)declaration).getName());
    }

    private static Collection<LocalQuickFix> checkMoreThanOneAttributeConfigured(List<PersistentAttribute> attributes) {
        THashMap valueMap = new THashMap(1);
        boolean[] problemFound = new boolean[]{false};
        ContainerUtil.process(attributes, (Processor)ModelMergerUtil.createFilteringProcessor(arg_0 -> JpaAttributeMemberSignatureInspection.lambda$checkMoreThanOneAttributeConfigured$2((Map)valueMap, problemFound, arg_0)));
        if (problemFound[0]) {
            ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
            Processor processor = attributeBase -> {
                PsiElement targetElement;
                Object object = attributeBase instanceof AttributeBaseImpl ? ((AttributeBaseImpl)((Object)attributeBase)).getAnnoRef().getPsiElement() : (targetElement = attributeBase instanceof DomElement ? ((DomElement)attributeBase).getXmlElement() : null);
                if (targetElement != null) {
                    quickFixes.add(new RemoveQuickFix(targetElement));
                }
                return true;
            };
            for (Object key : valueMap.keySet()) {
                Set set = (Set)valueMap.get(key);
                if (set.size() <= 1) continue;
                ContainerUtil.process((Iterable)set, (Processor)processor);
            }
            return quickFixes;
        }
        return Collections.emptyList();
    }

    private static void checkAttributeMembers(UDeclaration psiMember, ProblemsHolder holder, PersistenceClassRole role) {
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)psiMember);
        if (sourcePsi == null) {
            return;
        }
        if (psiMember instanceof UMethod) {
            UClass containingClass;
            UMethod uMethod = (UMethod)psiMember;
            if (!PropertyUtilBase.isSimplePropertyGetter((PsiMethod)uMethod.getJavaPsi())) {
                holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("attribute.member.should.be.field.or.getter", new Object[0]), new LocalQuickFix[0]);
            } else if (role.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS && (containingClass = UastUtils.getContainingUClass((UElement)uMethod)) != null) {
                PsiMethod propertySetter = PropertyUtilBase.findPropertySetter((PsiClass)containingClass.getJavaPsi(), (String)PropertyUtilBase.getPropertyNameByGetter((PsiMethod)uMethod.getJavaPsi()), (boolean)false, (boolean)true);
                PsiType substitutedType = JpaInspectionUtil.getMemberType((UDeclaration)UastContextKt.toUElement((PsiElement)propertySetter, UMethod.class));
                PsiType actualType = JpaInspectionUtil.getMemberType((UDeclaration)uMethod);
                if (propertySetter == null || substitutedType != null && actualType != null && !TypeConversionUtil.isAssignable((PsiType)substitutedType, (PsiType)actualType)) {
                    holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("attribute.definition.lacks.setter", new Object[0]), new LocalQuickFix[0]);
                }
            }
        } else if (!(psiMember instanceof UField)) {
            holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("attribute.member.should.be.field.or.getter", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkAttributeType(UDeclaration psiMember, ProblemsHolder holder, PersistenceClassRole role, PersistentAttribute attribute) {
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)psiMember);
        if (sourcePsi == null) {
            return;
        }
        PersistenceFacet facet = role.getFacet();
        if (!JpaUtil.isHibernateProvider(role) && facet instanceof JpaFacet && JpaUtil.getJpaVersion((JpaFacet)facet) == JpaVersion.JPA_1_0 && role.getType() == PersistenceClassRoleEnum.EMBEDDABLE && !(attribute instanceof Basic) && !(attribute instanceof PersistentTransientAttribute)) {
            String attributeTypeName = AttributeType.getAttributeType((PersistentAttribute)attribute).getTypeName();
            String attributeName = (String)attribute.getName().getValue();
            holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("attribute.type.not.valid.for.embeddable", attributeTypeName, attributeName), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ boolean lambda$checkMoreThanOneAttributeConfigured$2(Map valueMap, boolean[] problemFound, PersistentAttribute o) {
        Object key = o instanceof DomElement ? DomUtil.getParentOfType((DomElement)((DomElement)o), PersistentObject.class, (boolean)true) : (o instanceof JamElement ? Boolean.TRUE : null);
        if (key != null) {
            Set set = (Set)valueMap.get(key);
            if (set == null) {
                set = new THashSet(1);
                valueMap.put(key, set);
            } else if (!problemFound[0]) {
                problemFound[0] = true;
            }
            set.add(o);
        }
        return true;
    }
}

