/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.JpaQueryParameterReferenceProvider;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import java.text.MessageFormat;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

public class JpaQueryApiInspection
extends AbstractUastJpaInspection {
    @NonNls
    public static final String SHORT_NAME = "JpaQueryApiInspection";

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JpaQueryApiInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof PsiLanguageInjectionHost)) {
                    return;
                }
                UExpression uLiteralExpression = (UExpression)UastContextKt.toUElement((PsiElement)element, UExpression.class);
                if (uLiteralExpression != null) {
                    JpaQueryApiInspection.checkQueryApiReferences(uLiteralExpression, element, holder, isOnTheFly);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/highlighting/JpaQueryApiInspection$1", "visitElement"));
            }
        };
    }

    private static void checkQueryApiReferences(UExpression literalExpression, PsiElement host, ProblemsHolder holder, boolean isOnTheFly) {
        if (JpaQueryReferenceProvider.ALL_PATTERNS.accepts((Object)literalExpression, UastPatterns.withRequestedPsi((PsiElement)host)) || JpaQueryParameterReferenceProvider.ALL_PATTERNS.accepts((Object)literalExpression, UastPatterns.withRequestedPsi((PsiElement)host))) {
            boolean badResolve;
            PsiReference[] references = host.getReferences();
            JpaQueryReferenceProvider.QueryRelatedReference relatedReference = JpaUtil.findReferenceOfType(references, JpaQueryReferenceProvider.QueryRelatedReference.class);
            boolean bl = badResolve = relatedReference != null && relatedReference.resolve() == null;
            if (badResolve) {
                String message = MessageFormat.format(relatedReference.getUnresolvedMessagePattern(), relatedReference.getCanonicalText());
                holder.registerProblem(holder.getManager().createProblemDescriptor(relatedReference.getElement(), relatedReference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, relatedReference.getQuickFixes()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jpa/highlighting/JpaQueryApiInspection", "buildVisitor"));
    }
}

