/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaModelValidatorBase;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class JpaModelValidator
extends JpaModelValidatorBase {
    public JpaModelValidator(PersistenceModelBrowser browser) {
        super(browser);
    }

    @Override
    protected String getContainerTypeProblem(PersistentAttributeType type, JavaTypeInfo typeInfo) {
        String qName;
        if (typeInfo.containerType == null) {
            return null;
        }
        if (typeInfo.containerType == JavaContainerType.ARRAY) {
            return JpaHighlightingMessages.message("attribute.0.type.should.not.be.array", type.getTypeName());
        }
        PsiClass typeClass = PsiTypesUtil.getPsiClass((PsiType)typeInfo.baseType);
        String string = qName = typeClass == null ? null : typeClass.getQualifiedName();
        if (typeInfo.containerType == JavaContainerType.MAP) {
            if (qName == null || !"java.util.Map".equals(qName)) {
                return JpaHighlightingMessages.message("attribute.0.type.should.be.1", type.getTypeName(), "java.util.Map");
            }
        } else if (qName == null || !qName.equals("java.util.Collection") && !qName.equals("java.util.List") && !qName.equals("java.util.Set")) {
            return JpaHighlightingMessages.message("attribute.0.type.should.be.1", type.getTypeName(), Arrays.asList("java.util.Collection", "java.util.List", "java.util.Set"));
        }
        return null;
    }

    @Nullable
    @Nls
    public String getAttributeTypeProblem(JavaTypeInfo typeInfo, PersistentAttributeType attributeType, boolean isLob) {
        if (typeInfo.baseType instanceof PsiClassType && ((PsiClassType)typeInfo.baseType).resolve() == null) {
            return JpaHighlightingMessages.message("unable.to.resolve", typeInfo.baseType.getPresentableText());
        }
        if (isLob && this.doesAttributeReferenceMappedClasses(typeInfo)) {
            return JpaHighlightingMessages.message("attribute.should.not.reference.mapped.classes", attributeType.getTypeName());
        }
        return this.getAttributeTypeProblem(attributeType, typeInfo, isLob);
    }
}

