/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.model.common.persistence.JpaAnnotationConstants;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.actions.ParametersKt;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastVisibility;

public final class JpaInspectionUtil {
    public static final Logger LOG = Logger.getInstance((String)JpaInspectionUtil.class.getName());
    public static final String DEFAULT_PARAMETER_NAME = "o";

    private JpaInspectionUtil() {
    }

    public static LocalQuickFix convertToQuickFix(final IntentionAction quickFix) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = quickFix.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                try {
                    PsiElement element = descriptor.getPsiElement();
                    PsiFile containingFile = element.getContainingFile();
                    int offset = element.getTextRange().getStartOffset();
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, containingFile.getVirtualFile(), offset), false);
                    if (quickFix.isAvailable(project, editor, containingFile)) {
                        quickFix.invoke(project, editor, containingFile);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = quickFix.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/highlighting/JpaInspectionUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/highlighting/JpaInspectionUtil$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static <T extends PsiReference & EmptyResolveMessageProvider> boolean checkMemberAnnotations(UAnnotated annotationOwner, ProblemsHolder holder, Class<T> referenceClass) {
        Ref hasErrors = new Ref((Object)Boolean.FALSE);
        Processor processor = t -> {
            boolean badResolve;
            boolean bl = !t.isSoft() && (t instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)t).multiResolve(false).length == 0 : t.resolve() == null) ? true : (badResolve = false);
            if (badResolve) {
                String message = MessageFormat.format(((EmptyResolveMessageProvider)t).getUnresolvedMessagePattern(), t.getCanonicalText());
                holder.registerProblem(holder.getManager().createProblemDescriptor(t.getElement(), t.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), ((LocalQuickFixProvider)t).getQuickFixes()));
                hasErrors.set((Object)Boolean.TRUE);
                return true;
            }
            return true;
        };
        StreamEx.of((Collection)annotationOwner.getUAnnotations()).map(uAnnotation -> uAnnotation.getSourcePsi()).nonNull().flatMap(annotation -> JpaInspectionUtil.getAllInjectionHosts(annotation).stream()).forEach(literal -> JpaUtil.processReferencesOfType(literal.getReferences(), referenceClass, processor));
        return (Boolean)hasErrors.get() == false;
    }

    private static List<PsiLanguageInjectionHost> getAllInjectionHosts(PsiElement annotation) {
        SmartList hosts = new SmartList();
        annotation.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((List)hosts){
            final /* synthetic */ List val$hosts;
            {
                this.val$hosts = list;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    this.val$hosts.add((PsiLanguageInjectionHost)element);
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/highlighting/JpaInspectionUtil$2", "visitElement"));
            }
        });
        return hosts;
    }

    public static boolean checkMethodParameters(UMethod uMethod, ProblemsHolder holder, PsiType ... types) {
        boolean result = true;
        List parameters = uMethod.getUastParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            UParameter uParameter = (UParameter)parameters.get(i);
            PsiElement anchorSourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)uParameter);
            if (anchorSourcePsi == null) continue;
            PsiType parameterType = uParameter.getType();
            if (i < types.length) {
                PsiType type = types[i];
                if (parameterType.equals(type)) continue;
                holder.registerProblem(anchorSourcePsi, JpaHighlightingMessages.message("method.0.should.take.parameter.of.type.1.here", uMethod.getName(), type.getPresentableText()), JpaInspectionUtil.createChangeParameterByIndexFix(uMethod.getJavaPsi(), i, type));
                result = false;
                continue;
            }
            holder.registerProblem(anchorSourcePsi, JpaHighlightingMessages.message("method.0.should.take.1.parameters.only", uMethod.getName(), types.length), new LocalQuickFix[]{QuickFixFactory.getInstance().createRemoveUnusedParameterFix((PsiParameter)uParameter.getJavaPsi())});
            result = false;
        }
        if (parameters.size() < types.length) {
            PsiElement methodSourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)uMethod);
            if (methodSourcePsi == null) {
                return true;
            }
            holder.registerProblem(methodSourcePsi, JpaHighlightingMessages.message("method.0.should.take.parameter.of.type.1.here", uMethod.getName(), types[parameters.size()].getPresentableText()), JpaInspectionUtil.createChangeParameterByIndexFix(uMethod.getJavaPsi(), parameters.size(), types[parameters.size()]));
            result = false;
        }
        return result;
    }

    private static LocalQuickFix[] createChangeParameterByIndexFix(PsiMethod psiMethod, int parameterIndex, PsiType updatedType) {
        SmartPsiElementPointer elementPointer = SmartPointerManager.createPointer((PsiElement)psiMethod);
        return IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createChangeParametersActions((JvmMethod)psiMethod, (ChangeParametersRequest)MethodRequestsKt.updateMethodParametersRequest(() -> (JvmMethod)elementPointer.getElement(), existingParameters -> {
            if (parameterIndex < existingParameters.size()) {
                String parameterName = (String)((Object)((ExpectedParameter)existingParameters.get(parameterIndex)).getSemanticNames().stream().findFirst().orElse(DEFAULT_PARAMETER_NAME + parameterIndex));
                existingParameters.set(parameterIndex, ParametersKt.expectedParameter((JvmType)updatedType, (String[])new String[]{parameterName}));
            } else {
                existingParameters.add(parameterIndex, ParametersKt.expectedParameter((JvmType)updatedType, (String[])new String[]{DEFAULT_PARAMETER_NAME}));
            }
            return existingParameters;
        })), (PsiFile)psiMethod.getContainingFile()).toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public static boolean checkMethodReturnType(UMethod uMethod, ProblemsHolder holder, PsiType returnType) {
        if (!returnType.equals(uMethod.getReturnType())) {
            PsiElement anchor;
            UTypeReferenceExpression returnTypeReference = uMethod.getReturnTypeReference();
            PsiElement sourcePsi = returnTypeReference == null ? uMethod.getSourcePsi() : returnTypeReference.getSourcePsi();
            PsiElement psiElement = anchor = sourcePsi == null ? UDeclarationKt.getAnchorPsi((UDeclaration)uMethod) : sourcePsi;
            if (anchor == null) {
                return false;
            }
            holder.registerProblem(anchor, JpaHighlightingMessages.message("method.0.should.return.1", uMethod.getName(), returnType.getCanonicalText()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodReturnFix(uMethod.getJavaPsi(), returnType, false)});
            return false;
        }
        return true;
    }

    public static boolean checkNoArgConstructorExists(UClass aClass, ProblemsHolder holder, UastVisibility ... allowedModifiers) {
        List constructors = (List)((StreamEx)StreamEx.of((Object[])aClass.getMethods()).filter(method -> method.isConstructor())).collect(Collectors.toList());
        if (constructors.size() == 0) {
            return true;
        }
        boolean isNoArgConstructorPresent = StreamEx.of((Collection)constructors).findAny(constructor -> constructor.getUastParameters().isEmpty() && ContainerUtil.newHashSet((Object[])allowedModifiers).contains(constructor.getVisibility())).isPresent();
        if (isNoArgConstructorPresent) {
            return true;
        }
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)aClass);
        if (sourcePsi == null) {
            return true;
        }
        holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("class.0.should.have.1.no.arg.constructor", aClass.getName(), Arrays.asList(allowedModifiers)), IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createConstructorActions((JvmClass)aClass.getJavaPsi(), (CreateConstructorRequest)MethodRequestsKt.constructorRequest((Project)sourcePsi.getProject(), (List)ContainerUtil.emptyList())), (PsiFile)sourcePsi.getContainingFile()).toArray(LocalQuickFix.EMPTY_ARRAY));
        return false;
    }

    public static boolean checkClassExtends(PsiClass aClass, String baseClass, boolean shouldExtend, PsiElement anchor, ProblemsHolder holder) {
        if (anchor == null || aClass == null) {
            return false;
        }
        PsiClass aBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(baseClass, GlobalSearchScope.allScope((Project)aClass.getProject()));
        if (aBaseClass == null) {
            return false;
        }
        if (aClass.isInheritor(aBaseClass, true) != shouldExtend) {
            String message = aClass.isInterface() ? JpaHighlightingMessages.message(shouldExtend ? "interface.should.extend" : "interface.should.not.extend", aClass.getName(), baseClass) : (aBaseClass.isInterface() == aClass.isInterface() ? JpaHighlightingMessages.message(shouldExtend ? "class.should.extend" : "class.should.not.extend", aClass.getName(), baseClass) : JpaHighlightingMessages.message(shouldExtend ? "class.should.implement" : "class.should.not.implement", aClass.getName(), baseClass));
            holder.registerProblem(anchor, message, new LocalQuickFix[0]);
            return true;
        }
        return false;
    }

    public static EntryStream<EntityListenerMethodType, UMethod> findEntityListenerMethods(UClass uClass) {
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)uClass.getPsi(), (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO);
        return StreamEx.cartesianProduct((Collection)new SmartList((Object[])new List[]{Arrays.asList(EntityListenerMethodType.values()), Arrays.asList(uClass.getMethods())})).mapToEntry(objects -> (EntityListenerMethodType)objects.get(0), objects -> (UMethod)objects.get(1)).filterKeyValue((type, method) -> method.findAnnotation(type.getMethodAnnotation().fqn(javaeeType)) != null);
    }

    public static UTypeReferenceExpression findMemberTypeElement(UDeclaration memberDeclaration) {
        if (memberDeclaration instanceof UVariable) {
            return ((UVariable)memberDeclaration).getTypeReference();
        }
        if (memberDeclaration instanceof UMethod) {
            List uastParameters = ((UMethod)memberDeclaration).getUastParameters();
            if (uastParameters.size() == 0) {
                return ((UMethod)memberDeclaration).getReturnTypeReference();
            }
            if (uastParameters.size() == 1) {
                return ((UParameter)uastParameters.get(0)).getTypeReference();
            }
            return null;
        }
        return null;
    }

    public static UTypeReferenceExpression getMemberTypeReference(UDeclaration memberDeclaration) {
        UDeclaration typeDeclaration = JpaInspectionUtil.findActualMemberTypeDeclaration(memberDeclaration);
        if (typeDeclaration instanceof UVariable) {
            return ((UVariable)typeDeclaration).getTypeReference();
        }
        if (typeDeclaration instanceof UMethod) {
            return ((UMethod)typeDeclaration).getReturnTypeReference();
        }
        return null;
    }

    public static PsiType getMemberType(UDeclaration memberDeclaration) {
        UDeclaration typeDeclaration = JpaInspectionUtil.findActualMemberTypeDeclaration(memberDeclaration);
        if (typeDeclaration instanceof UVariable) {
            return ((UVariable)typeDeclaration).getType();
        }
        if (typeDeclaration instanceof UMethod) {
            return ((UMethod)typeDeclaration).getReturnType();
        }
        return null;
    }

    private static UDeclaration findActualMemberTypeDeclaration(UDeclaration memberDeclaration) {
        if (memberDeclaration instanceof UVariable) {
            return memberDeclaration;
        }
        if (memberDeclaration instanceof UMethod) {
            List uastParameters = ((UMethod)memberDeclaration).getUastParameters();
            if (uastParameters.size() == 0) {
                return memberDeclaration;
            }
            if (uastParameters.size() == 1) {
                return (UDeclaration)uastParameters.get(0);
            }
            return null;
        }
        return null;
    }
}

