/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.javaee.model.common.persistence.JavaeePersistenceConstants;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JpaImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final List<String> INJECTION_ANNOTATIONS = JpaImplicitUsageProvider.mapJavaeeClasses(JavaeePersistenceConstants.PERSISTENCE_CONTEXT_ANNO, JavaeePersistenceConstants.PERSISTENCE_UNIT_ANNO, JavaeePersistenceConstants.GENERATED_VALUE_ANNO);
    private static final List<String> LISTENER_ANNOTATIONS = JpaImplicitUsageProvider.mapJavaeeClasses(JavaeePersistenceConstants.POST_LOAD_ANNO, JavaeePersistenceConstants.POST_PERSIST_ANNO, JavaeePersistenceConstants.POST_REMOVE_ANNO, JavaeePersistenceConstants.POST_UPDATE_ANNO, JavaeePersistenceConstants.PRE_PERSIST_ANNO, JavaeePersistenceConstants.PRE_REMOVE_ANNO, JavaeePersistenceConstants.PRE_UPDATE_ANNO);

    @NotNull
    private static List<String> mapJavaeeClasses(JavaeeClass ... javaeeClasses) {
        ArrayList<String> annos = new ArrayList<String>();
        for (JavaeeClass javaeeClass : javaeeClasses) {
            annos.add(javaeeClass.javax());
            annos.add(javaeeClass.jakarta());
        }
        ArrayList<String> arrayList = annos;
        if (arrayList == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) && JpaImplicitUsageProvider.isAnnotated(element, INJECTION_ANNOTATIONS)) {
                return true;
            }
            if (JpaImplicitUsageProvider.isAnnotated((PsiElement)method, LISTENER_ANNOTATIONS)) {
                return true;
            }
            if (method.isConstructor()) {
                if (method.getParameterList().getParametersCount() == 0 && JpaUtil.hasRoles(method.getContainingClass())) {
                    return true;
                }
            } else if (PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method)) {
                PsiMethod getter = PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) ? PropertyUtilBase.findPropertyGetter((PsiClass)method.getContainingClass(), (String)PropertyUtilBase.getPropertyName((PsiMethod)method), (boolean)false, (boolean)true) : method;
                return !PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes((PsiMember)getter).isEmpty();
            }
        } else if (element instanceof PsiParameter) {
            PsiElement scope = ((PsiParameter)element).getDeclarationScope();
            return scope instanceof PsiMethod && JpaImplicitUsageProvider.isAnnotated(scope, LISTENER_ANNOTATIONS);
        }
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        PsiField psiField;
        PsiClass containingClass;
        if (element == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiField && JpaUtil.hasRoles(containingClass = (psiField = (PsiField)element).getContainingClass())) {
            return JpaImplicitUsageProvider.isFieldInitializedInScope(psiField, containingClass.getConstructors());
        }
        return JpaImplicitUsageProvider.isAnnotated(element, INJECTION_ANNOTATIONS);
    }

    private static boolean isAnnotated(PsiElement owner, List<String> annos) {
        return owner instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)owner), annos, (int)0);
    }

    private static boolean isFieldInitializedInScope(@NotNull PsiField field, PsiMethod[] constructors) {
        if (field == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return ((StreamEx)StreamEx.of((Object[])constructors).filter(constructor -> constructor.hasParameters() && constructor.getBody() != null)).allMatch(constructor -> HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)constructor.getBody()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/JpaImplicitUsageProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mapJavaeeClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/JpaImplicitUsageProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitUsage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitRead";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

