/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.JamNavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastUtils;

public final class JpaClassLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    @GutterName
    public String getName() {
        String string = JpaMessages.message((String)"jpa.gutter.name", (Object[])new Object[0]);
        if (string == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Javaee.PersistenceEntity;
        if (icon == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(4);
        }
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            JpaClassLineMarkerProvider.annotate(psiElement, result);
        }
    }

    public static void annotate(PsiElement element, Collection<? super LineMarkerInfo<?>> result) {
        UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)element);
        if (uParent == null) {
            return;
        }
        PsiElement psiParent = uParent.getJavaPsi();
        if (psiParent == null) {
            return;
        }
        if (uParent instanceof UClass) {
            PersistenceClassRole[] roles = JpaClassLineMarkerProvider.getPersistenceRolesFor(((UClass)uParent).getJavaPsi());
            if (roles.length != 0) {
                result.addAll(JpaClassLineMarkerProvider.createClassLineMarkerInfo((UClass)uParent, roles));
            }
        } else if (uParent instanceof UParameter) {
            List<PersistentAttribute> attributes = JpaClassLineMarkerProvider.collectAttributesFromAccessingMethods(element);
            if (attributes.isEmpty()) {
                attributes = JpaClassLineMarkerProvider.collectAttributesFromCorrespondingFields((UParameter)uParent);
            }
            if (!attributes.isEmpty()) {
                ContainerUtil.addIfNotNull(result, JpaClassLineMarkerProvider.createAttributeLineMarkerInfo(uParent, attributes));
            }
        } else if (uParent instanceof UField || uParent instanceof UMethod) {
            UClass containingClass = UastUtils.getContainingUClass((UElement)uParent);
            if (containingClass == null) {
                return;
            }
            PsiClass containingPsiClass = containingClass.getJavaPsi();
            if (JpaClassLineMarkerProvider.getPersistenceRolesFor(containingPsiClass).length == 0) {
                return;
            }
            List<PersistentAttribute> attributes = JpaClassLineMarkerProvider.getPersistentAttributesFor((PsiMember)psiParent);
            if (attributes.isEmpty() && PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) == null) {
                attributes = JpaClassLineMarkerProvider.collectAttributesFromAccessingMethods(element);
            }
            if (!attributes.isEmpty()) {
                ContainerUtil.addIfNotNull(result, JpaClassLineMarkerProvider.createAttributeLineMarkerInfo(uParent, attributes));
            }
        }
    }

    private static PersistenceClassRole[] getPersistenceRolesFor(PsiClass psiClass) {
        return (PersistenceClassRole[])CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static List<PersistentAttribute> collectAttributesFromCorrespondingFields(UParameter uParameter) {
        return JpaUtil.getCorrespondingFieldsFor(uParameter).stream().findAny().map(field -> JpaClassLineMarkerProvider.getPersistentAttributesFor(field)).orElseGet(ContainerUtil::emptyList);
    }

    private static List<PersistentAttribute> collectAttributesFromAccessingMethods(PsiElement element) {
        return JpaUtil.getAccessingMethodsFor(element).stream().flatMap(method -> JpaClassLineMarkerProvider.getPersistentAttributesFor(method).stream()).collect(Collectors.toList());
    }

    private static List<PersistentAttribute> getPersistentAttributesFor(PsiMember member) {
        return PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member);
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<?> createAttributeLineMarkerInfo(UElement element, List<? extends PersistentAttribute> attributes) {
        UElement uAnchor;
        UElement uElement = uAnchor = element instanceof UDeclaration ? ((UDeclaration)element).getUastAnchor() : element;
        if (uAnchor == null) {
            return null;
        }
        PsiElement sourcePsi = uAnchor.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        Collection<CommonModelElement> targets = JpaClassLineMarkerProvider.collectAttributeTargets(element, attributes);
        PersistentAttribute source = attributes.get(0);
        JamNavigationGutterIconBuilder builder = JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)ElementPresentationManager.getIcon((Object)source), CommonModelElement.class);
        return JpaClassLineMarkerProvider.createMarker(sourcePsi, (JamNavigationGutterIconBuilder<CommonModelElement>)builder, targets, (CommonModelElement)source);
    }

    private static Collection<CommonModelElement> collectAttributeTargets(UElement uElement, List<? extends PersistentAttribute> attributes) {
        THashSet result = new THashSet();
        for (PersistentAttribute persistentAttribute : attributes) {
            DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)persistentAttribute, DomElement.class);
            ContainerUtil.addIfNotNull((Collection)result, (Object)((PersistentAttribute)domElement));
            UClass containingUClass = UastUtils.getContainingUClass((UElement)uElement);
            if (containingUClass == null) continue;
            JpaClassLineMarkerProvider.processAttributeTargets(containingUClass.getJavaPsi(), persistentAttribute, (PairProcessor<? super PersistentObject, ? super PersistentRelationshipAttribute>)((PairProcessor)(persistentObject, relationshipAttribute) -> {
                if (relationshipAttribute != null) {
                    result.add(relationshipAttribute);
                } else {
                    result.add(persistentObject);
                }
                return true;
            }));
        }
        return result;
    }

    private static void processAttributeTargets(PsiClass psiClass, PersistentAttribute attribute, PairProcessor<? super PersistentObject, ? super PersistentRelationshipAttribute> processor) {
        block5: {
            block4: {
                if (!(attribute instanceof PersistentRelationshipAttribute)) break block4;
                PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)psiClass);
                PersistentRelationshipAttribute relationshipAttribute = (PersistentRelationshipAttribute)attribute;
                for (PersistentObject object : browser.queryTargetPersistentObjects(relationshipAttribute).findAll()) {
                    PersistentEntity entity = (PersistentEntity)object;
                    Collection list = browser.queryTheOtherSideAttributes(relationshipAttribute, false).findAll();
                    if (list.isEmpty()) {
                        processor.process((Object)entity, null);
                        continue;
                    }
                    for (PersistentRelationshipAttribute targetAttribute : list) {
                        processor.process((Object)entity, (Object)targetAttribute);
                    }
                }
                break block5;
            }
            if (!(attribute instanceof PersistentEmbeddedAttribute)) break block5;
            PersistentEmbeddedAttribute embeddedAttribute = (PersistentEmbeddedAttribute)attribute;
            PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)psiClass);
            for (PersistentObject object : browser.queryTargetPersistentObjects(embeddedAttribute).findAll()) {
                processor.process((Object)object, null);
            }
        }
    }

    private static Collection<LineMarkerInfo<?>> createClassLineMarkerInfo(UClass uClass, PersistenceClassRole[] roles) {
        UElement anchor = uClass.getUastAnchor();
        if (anchor == null) {
            return Collections.emptyList();
        }
        PsiElement sourcePsi = anchor.getSourcePsi();
        if (sourcePsi == null) {
            return Collections.emptyList();
        }
        PersistenceClassRole role = roles[0];
        JamNavigationGutterIconBuilder builder = JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)role.getIcon(), CommonModelElement.class);
        Collection<? extends CommonModelElement> targets = JpaClassLineMarkerProvider.collectClassTargets(roles);
        if (targets.isEmpty()) {
            Project project = sourcePsi.getProject();
            return Collections.singletonList(JpaClassLineMarkerProvider.createLineMarker(sourcePsi, role.getIcon(), project));
        }
        PersistenceListener source = role.getPersistentObject() == null ? role.getEntityListener() : role.getPersistentObject();
        RelatedItemLineMarkerInfo<?> navigationMarker = JpaClassLineMarkerProvider.createMarker(sourcePsi, (JamNavigationGutterIconBuilder<CommonModelElement>)builder, targets, (CommonModelElement)source);
        return Collections.singletonList(navigationMarker);
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(PsiElement sourcePsi, Icon icon, Project project) {
        return new LineMarkerInfo(sourcePsi, sourcePsi.getTextRange(), icon, element -> JpaMessages.message((String)"jpa.open.persistence.tool.window", (Object[])new Object[0]), (e, elt) -> {
            ToolWindow toolWindow = JpaClassLineMarkerProvider.getToolWindow(project);
            if (toolWindow != null) {
                toolWindow.activate(null);
            }
        }, GutterIconRenderer.Alignment.RIGHT, JpaMessages.messagePointer((String)"jpa.open.persistence.tool.window", (Object[])new Object[0]));
    }

    @Nullable
    public static ToolWindow getToolWindow(Project project) {
        return ToolWindowManager.getInstance((Project)project).getToolWindow("Persistence");
    }

    @NotNull
    private static RelatedItemLineMarkerInfo<?> createMarker(PsiElement sourcePsi, JamNavigationGutterIconBuilder<CommonModelElement> builder, Collection<? extends CommonModelElement> targets, CommonModelElement source) {
        String tooltipTitle;
        if (targets.isEmpty() && (tooltipTitle = JamNavigationGutterIconBuilder.getElementString((CommonModelElement)source)) != null) {
            builder.setTooltipTitle(tooltipTitle);
        }
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.setTargets(targets).setAlignment(GutterIconRenderer.Alignment.RIGHT).setPopupTitle(JpaHighlightingMessages.message("title.popup.choose.psi.target", new Object[0])).createLineMarkerInfo(sourcePsi);
        if (relatedItemLineMarkerInfo == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(5);
        }
        return relatedItemLineMarkerInfo;
    }

    private static Collection<? extends CommonModelElement> collectClassTargets(PersistenceClassRole[] roles) {
        THashSet result = new THashSet();
        for (PersistenceClassRole role : roles) {
            Object element = role.getPersistentObject() != null ? role.getPersistentObject() : role.getEntityListener();
            DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class);
            if (domElement == null) continue;
            result.add((Object)((CommonModelElement)domElement));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

