/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DasUtil;
import com.intellij.ide.util.PackageUtil;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.generation.JpaMappingGenerator;
import com.intellij.jpa.generation.ORMToAnnotationsConverter;
import com.intellij.jpa.generation.ui.DatabaseRelationshipData;
import com.intellij.jpa.generation.ui.DatabaseSchemaImportDialog;
import com.intellij.jpa.model.annotations.mapping.JamEntityMappings;
import com.intellij.jpa.model.common.MergedPersistenceMappings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistenceMappingsManipulator;
import com.intellij.persistence.model.manipulators.PersistenceUnitManipulator;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.model.manipulators.PersistentRelationshipAttributeManipulator;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReferenceHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSchemaImporter
implements JpaMappingGenerator {
    @NonNls
    public static final String ENTITY_PREFIX = "";
    @NonNls
    public static final String ENTITY_SUFFIX = "Entity";
    @NonNls
    public static final String PRIMARY_KEY_SUFFIX = "PK";
    public static final Logger LOG = Logger.getInstance((String)DatabaseSchemaImporter.class.getName());
    private DatabaseSchemaImportDialog myDialog;
    private PersistenceFacet myFacet;
    private final THashMap<String, PsiDirectory> myDirectories = new THashMap();

    @Override
    public String getTitle() {
        return JpaMessages.message((String)"action.name.generate.persistence.unit.by.database.schema", (Object[])new Object[0]);
    }

    @Override
    public JpaMappingGenerator clone() {
        return new DatabaseSchemaImporter();
    }

    @Override
    public boolean beforeGenerate(DataContext dataContext) {
        this.myFacet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.getData(dataContext);
        this.myDialog = new DatabaseSchemaImportDialog(this.myFacet, unit != null ? (String)unit.getName().getValue() : null);
        this.myDialog.show();
        if (this.myDialog.getExitCode() != 0) {
            return false;
        }
        if (ModelMergerUtil.getImplementation((Object)this.getPersistenceMappings(), JamEntityMappings.class) != null) {
            ORMToAnnotationsConverter.ensureJpaApiLibraryExists(this.myFacet.getModule());
        }
        return this.ensurePackagesAreCreated();
    }

    @Override
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistenceFacet facetContext = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET_CONTEXT.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.getData(dataContext);
        if (facet == null || facetContext == null && unit == null) {
            return false;
        }
        return unit == null || !JamCommonUtil.isInLibrary((CommonModelElement)unit);
    }

    protected DbDataSource getDataSource() {
        return this.myDialog.getDatasource();
    }

    protected MappingInfo getInfo(Object obj) {
        return this.myDialog.getInfo(obj);
    }

    protected List<DatabaseRelationshipData.Role> getRelationships(DasTable tableData) {
        return this.myDialog.getRelationships(tableData);
    }

    protected PersistencePackage getPersistenceUnit() {
        return this.myDialog.getPersistenceUnit();
    }

    protected PersistenceMappings getPersistenceMappings() {
        return this.myDialog.getPersistenceMapping();
    }

    protected boolean isGenerateColumnProperties() {
        return this.myDialog.isGenerateColumnProperties();
    }

    private boolean isGenerateSeparateXmlPerEntity() {
        return this.myDialog.isGenerateSeparateXmlPerEntity();
    }

    @Override
    public VirtualFile[] generate() {
        ArrayList affectedElements = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> this.addAffectedElements(affectedElements));
        Ref indicatorRef = Ref.create(null);
        List<Runnable> runnableList = this.buildEntityMappings((Ref<ProgressIndicator>)indicatorRef);
        PersistenceHelper.getHelper().runCompositeWriteCommandAction(this.myFacet.getModule().getProject(), JpaMessages.message((String)"command.generate.persistence.mappings", (Object[])new Object[]{this.getTitle()}), affectedElements, indicatorRef, runnableList.toArray(new Runnable[0]));
        return VirtualFile.EMPTY_ARRAY;
    }

    public boolean ensurePackagesAreCreated() {
        for (DasTable table : DasUtil.getTables((DasDataSource)this.getDataSource())) {
            String className;
            String packageName;
            MappingInfo tableInfo = this.getInfo(table);
            if (!tableInfo.enabled || this.myDirectories.containsKey((Object)(packageName = StringUtil.getPackageName((String)(className = this.getQualifiedName(tableInfo.type)))))) continue;
            try {
                PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage((Module)this.myFacet.getModule(), (String)packageName, null, (boolean)false);
                if (directory == null) {
                    return false;
                }
                this.myDirectories.put((Object)packageName, (Object)directory);
            }
            catch (IncorrectOperationException e) {
                return false;
            }
        }
        return true;
    }

    public void addAffectedElements(Collection<PsiElement> result) {
        ContainerUtil.addIfNotNull(result, (Object)this.getPersistenceUnit().getIdentifyingPsiElement());
        for (PersistenceMappings mappings : ModelMergerUtil.getFilteredImplementations((Object)this.getPersistenceMappings())) {
            ContainerUtil.addIfNotNull(result, (Object)mappings.getIdentifyingPsiElement());
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myFacet.getModule().getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)this.myFacet.getModule());
        for (DasTable tableData : DasUtil.getTables((DasDataSource)this.getDataSource())) {
            MappingInfo tableInfo = this.getInfo(tableData);
            if (!tableInfo.enabled) continue;
            String className = this.getQualifiedName(tableInfo.type);
            ContainerUtil.addIfNotNull(result, (Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(className, scope));
            boolean compositeId = this.calculateNumberOfIdAttributes(tableData) > 1;
            if (!compositeId) continue;
            String pkClassName = this.getQualifiedName(DatabaseSchemaImporter.getDefaultPrimaryKeyType(tableInfo.type));
            ContainerUtil.addIfNotNull(result, (Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(pkClassName, scope));
        }
    }

    public List<Runnable> buildEntityMappings(Ref<ProgressIndicator> indicatorRef) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        PersistencePackage unit = this.getPersistenceUnit();
        PersistenceMappings mappings = this.getPersistenceMappings();
        RawConnectionConfig connectionInfo = this.getDataSource().getConnectionConfig();
        Credentials credentials = DatabaseCredentials.getInstance().getCredentials((DasDataSource)this.getDataSource());
        this.buildEntityMappings(unit, mappings, indicatorRef, result);
        result.add(() -> {
            PersistenceUnitManipulator unitManipulator = (PersistenceUnitManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)unit, PersistenceUnitManipulator.class);
            if (unitManipulator != null) {
                for (PersistenceMappings persistenceMappings : ModelMergerUtil.getFilteredImplementations((Object)mappings)) {
                    unitManipulator.ensureMappingIncluded(persistenceMappings);
                }
                if (connectionInfo != null) {
                    Library library;
                    PsiClass existingClass;
                    unitManipulator.setConnectionProperties(this.getDataSource().getProject(), connectionInfo, credentials);
                    String driverClass = connectionInfo.getDriverClass();
                    if (StringUtil.isNotEmpty((String)driverClass) && (existingClass = JavaPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).findClass(driverClass, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myFacet.getModule()))) == null && (library = LibraryUtil.findLibraryByClass((String)driverClass, (Project)this.myFacet.getModule().getProject())) != null) {
                        ModuleRootModificationUtil.addDependency((Module)this.myFacet.getModule(), (Library)library);
                    }
                }
            }
            if (unit != null && this.myFacet.getDataSourceId(unit) == null) {
                this.myFacet.setDataSourceId(unit, this.getDataSource().getUniqueId());
            }
        });
        return result;
    }

    public void buildEntityMappings(PersistencePackage unit, PersistenceMappings mappings, Ref<ProgressIndicator> indicatorRef, ArrayList<Runnable> result) {
        MappingInfo tableInfo;
        ArrangementEngine rearranger = ArrangementEngine.getInstance();
        boolean generateColumnProperties = this.isGenerateColumnProperties();
        boolean singleXmlPerEntity = this.isGenerateSeparateXmlPerEntity();
        Map.Entry choosenXmlFormat = singleXmlPerEntity ? this.myFacet.getSupportedDomMappingFormats().entrySet().iterator().next() : null;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)unit.getPsiManager().getProject()).getElementFactory();
        THashMap entityMap = new THashMap();
        Ref accessModeRef = Ref.create(null);
        result.add(() -> {
            PropertyMemberType mappingAccess = mappings == null ? null : mappings.getModelHelper().getDeclaredAccess();
            PropertyMemberType unitAccess = this.myFacet.getPersistenceUnitDefaults(unit).getAccess();
            accessModeRef.set((Object)(mappingAccess != null ? mappingAccess : (unitAccess != null ? unitAccess : PropertyMemberType.GETTER)));
        });
        for (DasTable tableData : DasUtil.getTables((DasDataSource)this.getDataSource())) {
            tableInfo = this.getInfo(tableData);
            if (!tableInfo.enabled) continue;
            boolean compositeId = this.calculateNumberOfIdAttributes(tableData) > 1;
            Ref entityManipulatorRef = Ref.create(null);
            ArrayList idAttributes = new ArrayList();
            result.add(() -> {
                try {
                    ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                    if (indicator != null) {
                        indicator.setText(JpaMessages.message((String)"message.generating.1", (Object[])new Object[]{this.getQualifiedName(tableInfo.type)}));
                    }
                    String fqName = this.getQualifiedName(tableInfo.type);
                    PsiDirectory psiDirectory = (PsiDirectory)this.myDirectories.get((Object)StringUtil.getPackageName((String)fqName));
                    PersistenceMappings currentMappings = DatabaseSchemaImporter.getCurrentMappings(mappings, singleXmlPerEntity, choosenXmlFormat, psiDirectory, tableInfo.type, this.myFacet);
                    PersistenceMappingsManipulator mappingsManipulator = (PersistenceMappingsManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)currentMappings, PersistenceMappingsManipulator.class);
                    if (mappingsManipulator == null) {
                        return;
                    }
                    PersistentEntity entity = mappingsManipulator.addEntity(this.myFacet.getModule(), psiDirectory, unit, PsiNameHelper.getShortClassName((String)fqName), tableInfo.name);
                    PersistentObjectManipulator entityManipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)entity, PersistentObjectManipulator.class);
                    if (entityManipulator == null) {
                        return;
                    }
                    entityManipulator.setTable(tableData);
                    entityMap.put((Object)tableInfo, (Object)entityManipulator);
                    entityManipulator.setGenerateColumnProperties(generateColumnProperties);
                    entityManipulatorRef.set((Object)entityManipulator);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            });
            ArrayList fields = new ArrayList();
            for (DasColumn fieldData : DasUtil.getColumns((DasObject)tableData)) {
                MappingInfo fieldInfo = this.getInfo(fieldData);
                if (!fieldInfo.enabled) continue;
                result.add(() -> {
                    try {
                        PersistentAttribute attribute;
                        ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                        if (indicator != null) {
                            indicator.setText(JpaMessages.message((String)"message.generating.1", (Object[])new Object[]{this.getQualifiedName(tableInfo.type)}));
                            indicator.setText2(JpaMessages.message((String)"message.adding.1", (Object[])new Object[]{fieldInfo.name}));
                        }
                        if (entityManipulatorRef.isNull()) {
                            return;
                        }
                        PersistentObjectManipulator entityManipulator = (PersistentObjectManipulator)entityManipulatorRef.get();
                        PersistentEntity entity = (PersistentEntity)entityManipulator.getManipulatorTarget();
                        PsiClass context = (PsiClass)entity.getClazz().getValue();
                        PropertyMemberType accessMode = (PropertyMemberType)accessModeRef.get();
                        if (DasUtil.isPrimary((DasColumn)fieldData)) {
                            attribute = entityManipulator.addIdAttribute(compositeId, fieldInfo.name, elementFactory.createTypeFromText(fieldInfo.type, (PsiElement)context), accessMode, Collections.singleton(fieldData));
                            idAttributes.add(attribute);
                        } else {
                            attribute = entityManipulator.addAttribute(fieldInfo.name, elementFactory.createTypeFromText(fieldInfo.type, (PsiElement)context), accessMode, Collections.singleton(fieldData));
                        }
                        ContainerUtil.addIfNotNull((Collection)fields, (Object)PropertyUtilBase.findPropertyFieldByMember((PsiMember)attribute.getPsiMember()));
                    }
                    catch (IncorrectOperationException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            result.add(() -> {
                if (!fields.isEmpty()) {
                    ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                    if (indicator != null) {
                        indicator.setText(JpaMessages.message((String)"message.generating.1", (Object[])new Object[]{this.getQualifiedName(tableInfo.type)}));
                        @NonNls String equalsHashCode = "equals() / hashCode()";
                        indicator.setText2(JpaMessages.message((String)"message.adding.1", (Object[])new Object[]{"equals() / hashCode()"}));
                    }
                    if (entityManipulatorRef.isNull()) {
                        return;
                    }
                    PersistentObjectManipulator entityManipulator = (PersistentObjectManipulator)entityManipulatorRef.get();
                    PsiClass psiClass = (PsiClass)((PersistentEntity)entityManipulator.getManipulatorTarget()).getClazz().getValue();
                    if (psiClass != null) {
                        ORMToAnnotationsConverter.ensureEqualsAndHashCodeImplemented(psiClass, fields);
                    }
                }
            });
            if (!compositeId) continue;
            result.add(() -> {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                if (indicator != null) {
                    indicator.setText(JpaMessages.message((String)"message.generating.1", (Object[])new Object[]{this.getQualifiedName(tableInfo.type)}));
                    indicator.setText2(JpaMessages.message((String)"message.generating.1", (Object[])new Object[]{DatabaseSchemaImporter.getDefaultPrimaryKeyType(tableInfo.type)}));
                }
                if (entityManipulatorRef.isNull()) {
                    return;
                }
                PersistentObjectManipulator entityManipulator = (PersistentObjectManipulator)entityManipulatorRef.get();
                try {
                    entityManipulator.setIdClass(this.getQualifiedName(DatabaseSchemaImporter.getDefaultPrimaryKeyType(tableInfo.type)));
                    PsiClass aClass = entityManipulator.ensureIdClassExists(idAttributes);
                    if (aClass == null) {
                        return;
                    }
                    DatabaseSchemaImporter.shortenReferencesAndRearrange(aClass, rearranger, indicator);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        for (DasTable tableData : DasUtil.getTables((DasDataSource)this.getDataSource())) {
            tableInfo = this.getInfo(tableData);
            if (!tableInfo.enabled) continue;
            for (DatabaseRelationshipData.Role relationData : this.getRelationships(tableData)) {
                MappingInfo relationInfo = this.getInfo(relationData);
                if (!relationInfo.enabled || relationInfo.name.length() == 0) continue;
                MappingInfo relationInfoOpposite = this.getInfo(relationData.getOppositeRole());
                MappingInfo targetEntityInfo = this.getInfo(relationData.getOppositeRole().getTable());
                result.add(() -> {
                    PersistentObjectManipulator entityManipulator;
                    ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                    if (indicator != null) {
                        indicator.setText(JpaMessages.message((String)"message.generating.1", (Object[])new Object[]{this.getQualifiedName(tableInfo.type)}));
                        indicator.setText2(JpaMessages.message((String)"message.adding.1", (Object[])new Object[]{relationInfo.name}));
                    }
                    if ((entityManipulator = (PersistentObjectManipulator)entityMap.get((Object)tableInfo)) == null) {
                        return;
                    }
                    PersistentEntity targetEntity = (PersistentEntity)((PersistentObjectManipulator)entityMap.get((Object)targetEntityInfo)).getManipulatorTarget();
                    RelationshipType relationshipType = RelationshipType.getRelationshipType((relationData.getContainerType() != null ? 1 : 0) != 0, (relationData.getOppositeRole().getContainerType() != null ? 1 : 0) != 0);
                    boolean isRelationshipSource = relationData == relationData.getRelationship().getSource();
                    boolean isRelationshipOwner = isRelationshipSource && relationshipType != RelationshipType.ONE_TO_MANY || !isRelationshipSource && relationshipType == RelationshipType.MANY_TO_ONE;
                    PropertyMemberType accessMode = (PropertyMemberType)accessModeRef.get();
                    assert (targetEntity != null) : "target entity null";
                    try {
                        DasTable dsJoinTable;
                        PersistentRelationshipAttribute attribute = entityManipulator.addRelationshipAttribute((PersistentEntityBase)targetEntity, relationshipType, relationData.getContainerType(), relationInfo.name, relationInfoOpposite.name, !isRelationshipOwner, true, null, Collections.emptyList(), accessMode);
                        PersistentRelationshipAttributeManipulator attributeManipulator = (PersistentRelationshipAttributeManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)attribute, PersistentRelationshipAttributeManipulator.class);
                        if (attributeManipulator == null) {
                            return;
                        }
                        DasColumn mapKey = relationData.getMapKey();
                        if (mapKey != null) {
                            attributeManipulator.setMapKeyColumn(this.getInfo((Object)mapKey).name, mapKey, !isRelationshipOwner);
                        }
                        if ((dsJoinTable = relationData.getRelationship().getJoinTable()) != null) {
                            LinkedHashMap<DasColumn, DasColumn> sourceColumns = new LinkedHashMap<DasColumn, DasColumn>();
                            LinkedHashMap<DasColumn, DasColumn> targetColumns = new LinkedHashMap<DasColumn, DasColumn>();
                            for (DatabaseRelationshipData.Join join : relationData.getRelationship().getJoins()) {
                                if (join.getSource() != null) {
                                    sourceColumns.put(join.getSourceJoin(), join.getSource());
                                }
                                if (join.getTarget() == null) continue;
                                targetColumns.put(join.getTargetJoin(), join.getTarget());
                            }
                            attributeManipulator.setJoinTable(!isRelationshipOwner, dsJoinTable, isRelationshipSource ? sourceColumns : targetColumns, isRelationshipSource ? targetColumns : sourceColumns);
                        } else {
                            LinkedHashMap<DasColumn, DasColumn> sourceColumns = new LinkedHashMap<DasColumn, DasColumn>();
                            for (DatabaseRelationshipData.Join join : relationData.getRelationship().getJoins()) {
                                if (isRelationshipSource && join.getSource() != null) {
                                    sourceColumns.put(join.getSource(), join.getTarget());
                                    continue;
                                }
                                if (isRelationshipSource || join.getTarget() == null) continue;
                                sourceColumns.put(join.getTarget(), join.getSource());
                            }
                            attributeManipulator.setJoinColumns(!isRelationshipOwner, sourceColumns);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        for (DasTable tableData : DasUtil.getTables((DasDataSource)this.getDataSource())) {
            tableInfo = this.getInfo(tableData);
            if (!tableInfo.enabled) continue;
            result.add(() -> {
                PersistentObjectManipulator manipulator = (PersistentObjectManipulator)entityMap.get((Object)tableInfo);
                if (manipulator == null) {
                    return;
                }
                PsiClass aClass = (PsiClass)((PersistentEntity)manipulator.getManipulatorTarget()).getClazz().getValue();
                if (aClass == null) {
                    return;
                }
                DatabaseSchemaImporter.shortenReferencesAndRearrange(aClass, rearranger, (ProgressIndicator)indicatorRef.get());
            });
        }
    }

    private static void shortenReferencesAndRearrange(@NotNull PsiClass aClass, @NotNull ArrangementEngine rearranger, @Nullable ProgressIndicator indicator) {
        if (aClass == null) {
            DatabaseSchemaImporter.$$$reportNull$$$0(0);
        }
        if (rearranger == null) {
            DatabaseSchemaImporter.$$$reportNull$$$0(1);
        }
        PsiFile file = aClass.getContainingFile();
        Project project = file.getProject();
        String name = aClass.getName();
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)aClass);
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        Document document = Objects.requireNonNull(docManager.getDocument(file));
        docManager.doPostponedOperationsAndUnblockDocument(document);
        if (indicator != null) {
            indicator.setText2(JpaMessages.message((String)"message.rearranging.1", (Object[])new Object[]{name}));
        }
        rearranger.arrange(file, Collections.singleton(file.getTextRange()));
    }

    @Nullable
    static PersistenceMappings getCurrentMappings(PersistenceMappings mappings, boolean singleXmlPerEntity, Map.Entry<ConfigFileMetaData, Class<? extends PersistenceMappings>> choosenXmlFormat, PsiDirectory psiDirectory, String shortName, PersistenceFacet facet) {
        PersistenceMappings currentMappings;
        if (singleXmlPerEntity) {
            ConfigFileMetaData metaData = choosenXmlFormat.getKey();
            String mappingName = shortName + "." + metaData.getFileName().substring(metaData.getFileName().indexOf(".") + 1);
            String url = DatabaseSchemaImporter.findSuitableConfigDirectory(psiDirectory).getUrl() + "/" + mappingName;
            VirtualFile file = ConfigFileFactory.getInstance().createFile(psiDirectory.getProject(), url, metaData.getDefaultVersion(), true);
            PsiFile createdPsiFile = file == null ? null : psiDirectory.getManager().findFile(file);
            PersistenceMappings fileMappings = (PersistenceMappings)JamCommonUtil.getRootElement((PsiFile)createdPsiFile, choosenXmlFormat.getValue());
            currentMappings = fileMappings == null ? mappings : (mappings == null ? fileMappings : new MergedPersistenceMappings(facet, Arrays.asList(mappings, fileMappings)));
        } else {
            currentMappings = mappings;
        }
        return currentMappings;
    }

    private static VirtualFile findSuitableConfigDirectory(PsiDirectory psiDirectory) {
        PsiFileReferenceHelper helper = PsiFileReferenceHelper.getInstance();
        FileTargetContext item = (FileTargetContext)ContainerUtil.getFirstItem((Collection)helper.getTargetContexts(psiDirectory.getProject(), psiDirectory.getVirtualFile(), true));
        if (item != null && !TestSourcesFilter.isTestSources((VirtualFile)item.getFileSystemItem().getVirtualFile(), (Project)psiDirectory.getProject())) {
            return item.getFileSystemItem().getVirtualFile();
        }
        return psiDirectory.getVirtualFile();
    }

    private int calculateNumberOfIdAttributes(DasTable tableData) {
        int idAttributeNumber = 0;
        for (DasColumn fieldData : DasUtil.getColumns((DasObject)tableData)) {
            MappingInfo fieldInfo = this.getInfo(fieldData);
            if (!fieldInfo.enabled || !DasUtil.isPrimary((DasColumn)fieldData)) continue;
            ++idAttributeNumber;
        }
        return idAttributeNumber;
    }

    private String getQualifiedName(String type) {
        String packageName = this.myDialog.getPackageName();
        return type.indexOf(46) == -1 && packageName.length() > 0 ? packageName + "." + type : type;
    }

    public static String getDefaultPrimaryKeyType(String entityName) {
        return entityName + PRIMARY_KEY_SUFFIX;
    }

    @NonNls
    public static String getPrettyName(String name, boolean capitalize, PsiNameHelper psiNameHelper) {
        String s = ORMToAnnotationsConverter.fixPropertyName(name == null ? "unnamed" : name, psiNameHelper);
        StringBuilder sb = new StringBuilder(s.length());
        for (String partAsIs : NameUtil.nameToWords((String)s)) {
            if (partAsIs.contains("_")) continue;
            String part = StringUtil.toLowerCase((String)partAsIs);
            sb.append(sb.length() == 0 && !capitalize ? part : StringUtil.capitalize((String)part));
        }
        String prettyName = sb.toString();
        return prettyName.length() > 0 ? prettyName : (capitalize ? "Value" : "value");
    }

    public static String getPrettyFieldName(DasColumn fieldData, PsiNameHelper psiNameHelper) {
        return DatabaseSchemaImporter.getPrettyName(fieldData.getName(), false, psiNameHelper);
    }

    public static List<DatabaseRelationshipData> calculateDefaultRelationships(Iterable<? extends DasTable> tables, Map<DasTable, List<DatabaseRelationshipData.Role>> relationsMap, PsiNameHelper psiNameHelper) {
        THashMap globalNamesMap = new THashMap();
        for (DasTable dasTable : tables) {
            HashSet<String> hashSet = new HashSet<String>();
            for (DasColumn tableFieldData : DasUtil.getColumns((DasObject)dasTable)) {
                hashSet.add(DatabaseSchemaImporter.getPrettyFieldName(tableFieldData, psiNameHelper));
            }
            List<DatabaseRelationshipData.Role> roles = relationsMap.get(dasTable);
            if (roles != null) {
                for (DatabaseRelationshipData.Role role : roles) {
                    hashSet.add(role.getAttribute());
                }
            }
            globalNamesMap.put((Object)dasTable, hashSet);
        }
        ArrayList<DatabaseRelationshipData> result = new ArrayList<DatabaseRelationshipData>();
        for (DasTable dasTable : tables) {
            int count = 0;
            for (DasForeignKey key : DasUtil.getForeignKeys((DasTable)dasTable)) {
                @NonNls Object relationName = StringUtil.isNotEmpty((String)key.getName()) ? key.getName() : "ref" + ++count;
                ContainerUtil.addIfNotNull(result, (Object)DatabaseSchemaImporter.calculateRelationship(psiNameHelper, (THashMap<DasTable, Set<String>>)globalNamesMap, dasTable, (String)relationName, key));
            }
        }
        for (DatabaseRelationshipData databaseRelationshipData : result) {
            DatabaseSchemaImporter.addToMap(relationsMap, databaseRelationshipData.getSource().getTable(), databaseRelationshipData.getSource());
            DatabaseSchemaImporter.addToMap(relationsMap, databaseRelationshipData.getTarget().getTable(), databaseRelationshipData.getTarget());
        }
        return result;
    }

    @Nullable
    public static DatabaseRelationshipData calculateRelationship(PsiNameHelper psiNameHelper, THashMap<DasTable, Set<String>> globalNamesMap, DasTable sourceTable, String relationName, DasForeignKey foreignKey) {
        boolean bidirectional;
        boolean switchOwner;
        DasTable targetTable = foreignKey.getRefTable();
        if (targetTable == null) {
            LOG.warn("relationship \"" + relationName + "\" is not properly configured, referenced table '" + foreignKey.getRefTableName() + "' not found.");
            return null;
        }
        boolean allSourceArePrimary = true;
        boolean allTargetsArePrimary = true;
        THashSet sourceFields = new THashSet();
        THashSet targetFields = new THashSet();
        MultiRef.It colIt = foreignKey.getColumnsRef().iterate();
        MultiRef.It refIt = foreignKey.getRefColumns().iterate();
        while (colIt.hasNext() && refIt.hasNext()) {
            colIt.next();
            refIt.next();
            DasColumn sourceColumn = (DasColumn)colIt.resolve();
            DasColumn targetColumn = (DasColumn)refIt.resolve();
            if (targetColumn == null || sourceColumn == null) {
                LOG.warn("relationship \"" + relationName + "\" is not properly configured");
                return null;
            }
            if (!DasUtil.isPrimary((DasColumn)targetColumn)) {
                allTargetsArePrimary = false;
            }
            if (!DasUtil.isPrimary((DasColumn)sourceColumn)) {
                allSourceArePrimary = false;
            }
            sourceFields.add((Object)sourceColumn);
            targetFields.add((Object)targetColumn);
        }
        List<DasColumn> targetKeys = DatabaseSchemaImporter.getPrimaryKeys(targetTable);
        List<DasColumn> sourceKeys = DatabaseSchemaImporter.getPrimaryKeys(sourceTable);
        DatabaseRelationshipData relation = new DatabaseRelationshipData();
        DatabaseRelationshipData.Role source = relation.getSource();
        DatabaseRelationshipData.Role target = relation.getTarget();
        if (allTargetsArePrimary && targetKeys.size() == targetFields.size()) {
            switchOwner = false;
            bidirectional = true;
            if (allSourceArePrimary && sourceKeys.size() == sourceFields.size()) {
                source.setContainerType(null);
                target.setContainerType(null);
            } else {
                source.setContainerType(null);
                target.setContainerType(JavaContainerType.COLLECTION);
            }
        } else {
            switchOwner = true;
            bidirectional = false;
            source.setContainerType(null);
            target.setContainerType(JavaContainerType.COLLECTION);
        }
        source.setTable(switchOwner ? targetTable : sourceTable);
        target.setTable(switchOwner ? sourceTable : targetTable);
        colIt = foreignKey.getColumnsRef().iterate();
        refIt = foreignKey.getRefColumns().iterate();
        while (colIt.hasNext() && refIt.hasNext()) {
            colIt.next();
            refIt.next();
            DasColumn sourceColumn = (DasColumn)colIt.resolve();
            DasColumn targetColumn = (DasColumn)refIt.resolve();
            DatabaseRelationshipData.Join join = switchOwner ? new DatabaseRelationshipData.Join(targetColumn, null, null, sourceColumn) : new DatabaseRelationshipData.Join(sourceColumn, null, null, targetColumn);
            relation.getJoins().add(join);
        }
        DatabaseSchemaImporter.configureUniqueReferenceName(relationName, source, globalNamesMap, psiNameHelper);
        if (bidirectional) {
            DatabaseSchemaImporter.configureUniqueReferenceName(relationName, target, globalNamesMap, psiNameHelper);
        }
        return relation;
    }

    public static void configureUniqueReferenceName(String relationName, DatabaseRelationshipData.Role role, Map<DasTable, Set<String>> globalNamesMap, PsiNameHelper psiNameHelper) {
        Object ending;
        boolean isMany = role.getContainerType() != null;
        DasTable sourceTable = role.getTable();
        DasTable targetTable = role.getOppositeRole().getTable();
        String baseName = DatabaseSchemaImporter.getPrettyName(targetTable.getName(), false, psiNameHelper);
        boolean isUnique = DatabaseSchemaImporter.isUniqueReference(sourceTable, targetTable);
        @NonNls String DELIMITER = "By";
        if (role.getRelationship().getJoins().size() == 1) {
            DatabaseRelationshipData.Join join = role.getRelationship().getJoins().get(0);
            DasColumn tableFieldData = role.getRelationship().getSource() == role ? join.getSource() : join.getTarget();
            ending = "By" + DatabaseSchemaImporter.getPrettyName(tableFieldData.getName(), true, psiNameHelper);
        } else {
            ending = isUnique ? ENTITY_PREFIX : "By" + DatabaseSchemaImporter.getPrettyName(relationName, true, psiNameHelper);
        }
        String result = (isMany ? StringUtil.pluralize((String)baseName) : baseName) + (String)ending;
        role.setAttribute(DatabaseSchemaImporter.makeNameUnique(result, globalNamesMap.get(sourceTable)));
    }

    public static boolean isUniqueReference(DasTable sourceTable, DasTable targetTable) {
        int count = 0;
        for (DasForeignKey key : DasUtil.getForeignKeys((DasTable)sourceTable)) {
            if (key.getRefTable() != targetTable) continue;
            ++count;
        }
        return count <= 1;
    }

    public static String makeNameUnique(String name, Set<? super String> uniqueNames) {
        Object uniqueName = name;
        int cnt = 0;
        while (uniqueNames.contains(uniqueName)) {
            uniqueName = name + "_" + cnt;
            ++cnt;
        }
        uniqueNames.add((String)uniqueName);
        return uniqueName;
    }

    public static List<DasColumn> getPrimaryKeys(DasTable targetTable) {
        ArrayList<DasColumn> primaryKeys = new ArrayList<DasColumn>();
        for (DasColumn tableFieldData : DasUtil.getColumns((DasObject)targetTable)) {
            if (!DasUtil.isPrimary((DasColumn)tableFieldData)) continue;
            primaryKeys.add(tableFieldData);
        }
        return primaryKeys;
    }

    public static <K, V> void addToMap(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(value);
    }

    public static <K, V> void removeFromMap(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list != null) {
            list.remove(value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rearranger";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/generation/DatabaseSchemaImporter";
        objectArray[2] = "shortenReferencesAndRearrange";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MappingInfo {
        @Nls
        public String errorMessage;
        public boolean enabled;
        public String name;
        public String type;

        public MappingInfo(boolean enabled, String name, String type) {
            this.enabled = enabled;
            this.name = name;
            this.type = type;
        }
    }
}

