/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet.ui;

import com.intellij.DynamicBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.ui.ConfigFilesEditor;
import com.intellij.javaee.ui.DeploymentDescriptorsOwner;
import com.intellij.javaee.ui.DeploymentDescriptorsOwnerBase;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFrameworkSupportProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaGeneralEditorTab
extends FacetEditorTab {
    private JPanel myMainPanel;
    private JPanel myDescriptorsPanel;
    private JComboBox<JpaImplementationProvider> myProviderComboBox;
    private ConfigFilesEditor myConfigFilesEditor;
    private DeploymentDescriptorsOwnerBase myDescriptorsOwner;
    private ConfigFileInfoSet myFileInfoSet;
    private final JpaFacetConfiguration myConfiguration;
    private final FacetLibrariesValidator myLibrariesValidator;

    public JpaGeneralEditorTab(JpaFacetConfiguration configuration, FacetEditorContext editorContext, FacetLibrariesValidator validator) {
        this.myConfiguration = configuration;
        this.myLibrariesValidator = validator;
        this.$$$setupUI$$$();
        JpaFrameworkSupportProvider.setupJpaProvidersCombobox(this.myProviderComboBox);
        this.createDescriptorsEditor(editorContext);
    }

    private void createDescriptorsEditor(FacetEditorContext editorContext) {
        this.myDescriptorsOwner = new DeploymentDescriptorsOwnerBase(editorContext){

            public boolean canBeParentForDescriptors(VirtualFile dir) {
                return true;
            }
        };
        ConfigFileMetaData[] metaData = new ConfigFileMetaData[]{JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA};
        JpaFacet facet = (JpaFacet)editorContext.getFacet();
        this.myFileInfoSet = ((JpaFacetConfiguration)facet.getConfiguration()).getDescriptorsConfiguration();
        Module module = editorContext.getModule();
        File defaultParent = new File(module.getModuleFilePath()).getAbsoluteFile().getParentFile();
        this.myConfigFilesEditor = new ConfigFilesEditor(metaData, this.myFileInfoSet, defaultParent, editorContext.isNewFacet(), (DeploymentDescriptorsOwner)this.myDescriptorsOwner, false);
        this.myDescriptorsPanel.setLayout(new BorderLayout());
        this.myDescriptorsPanel.add((Component)this.myConfigFilesEditor.createComponent(), "Center");
    }

    @Nls
    public String getDisplayName() {
        return JpaMessages.message((String)"tab.title.jpa.general.settings", (Object[])new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            JpaGeneralEditorTab.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public boolean isModified() {
        String arg2;
        if (this.myConfigFilesEditor.isModified()) {
            return true;
        }
        JpaImplementationProvider provider = (JpaImplementationProvider)this.myProviderComboBox.getSelectedItem();
        String string = arg2 = provider == null ? null : provider.getProviderName();
        if (!Objects.equals(this.myConfiguration.getDefaultJPAProviderName(), arg2)) {
            return true;
        }
        return this.myLibrariesValidator.isLibrariesAdded();
    }

    public void apply() {
        this.myConfigFilesEditor.applyChanges();
        JpaImplementationProvider provider = (JpaImplementationProvider)this.myProviderComboBox.getSelectedItem();
        this.myConfiguration.setDefaultJPAProviderName(provider == null ? null : provider.getProviderName());
    }

    public void reset() {
        this.myProviderComboBox.setSelectedItem(JpaFrameworkSupportProvider.findProviderByName(this.myConfiguration.getDefaultJPAProviderName()));
    }

    public void onFacetInitialized(@NotNull Facet facet) {
        if (facet == null) {
            JpaGeneralEditorTab.$$$reportNull$$$0(1);
        }
        this.myDescriptorsOwner.createAndDeleteFiles(facet.getModule().getProject());
        ((JpaFacetConfiguration)((JpaFacet)facet).getConfiguration()).getDescriptorsConfiguration().setConfigFileInfos(Arrays.asList(this.myFileInfoSet.getConfigFileInfos()));
        this.myLibrariesValidator.onFacetInitialized(facet);
    }

    public void disposeUIResources() {
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.module.facet.hibernate.jpa";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/facet/ui/JpaGeneralEditorTab";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/facet/ui/JpaGeneralEditorTab";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onFacetInitialized";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptorsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JpaBundle", JpaGeneralEditorTab.class).getString("border.facet.descriptors"), (int)0, (int)0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myProviderComboBox = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JpaBundle", JpaGeneralEditorTab.class).getString("label.facet.default.jpa.provider"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

