/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.database.psi.DbPsiFacade;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.common.persistence.mapping.EntityMappings;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.mapping.AccessType;
import com.intellij.javaee.model.xml.persistence.mapping.PersistenceUnitDefaults;
import com.intellij.jpa.JpaInspectionToolProvider;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.highlighting.HibernateModelValidator;
import com.intellij.jpa.highlighting.JpaModelValidator;
import com.intellij.jpa.model.VirtualPersistenceUnit;
import com.intellij.jpa.model.annotations.mapping.EntityMappingsImpl;
import com.intellij.jpa.model.common.MergedPersistenceMappings;
import com.intellij.jpa.model.xml.impl.converters.PersistentUnitFileConverterImpl;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.util.JpaCommonUtil;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileAdapter;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.GenericValueUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaFacetImpl
extends JpaFacet {
    private EntityMappingsImpl myAnnotationsPersistenceRoot;
    private CachedValue<List<XmlFile>> myMyCachedXmls;
    private final ConfigFileContainer myDescriptorsContainer;
    private final UnitSettingMap myUnitNamingStrategyMap;
    private final UnitDataSourceMap myUnitDataSourceMap;
    private static final Key<CachedValue<Condition<PsiClass>>> ANNO_MAPPINGS_CONDITION = Key.create((String)"ANNO_MAPPINGS_CONDITION");
    private static final Key<CachedValue<PersistencePackageDefaults>> PERSISTENCE_UNIT_DEFAULTS = Key.create((String)"PERSISTENCE_UNIT_DEFAULTS");

    public JpaFacetImpl(@NotNull FacetType<JpaFacet, JpaFacetConfiguration> facetType, @NotNull Module module, String name, @NotNull JpaFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            JpaFacetImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            JpaFacetImpl.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            JpaFacetImpl.$$$reportNull$$$0(2);
        }
        super(facetType, module, name, configuration, underlyingFacet);
        this.myUnitDataSourceMap = new UnitDataSourceMap(configuration.getUnitToDataSourceMap(), (PersistenceFacet)this);
        this.myDescriptorsContainer = ConfigFileFactory.getInstance().createConfigFileContainer(this.getModule().getProject(), configuration.getDescriptorsConfiguration().getMetaDataProvider(), configuration.getDescriptorsConfiguration());
        this.myDescriptorsContainer.addListener((ConfigFileListener)new ConfigFileAdapter(){

            protected void configChanged(ConfigFile configFile) {
                FacetManager.getInstance((Module)JpaFacetImpl.this.getModule()).facetConfigurationChanged((Facet)JpaFacetImpl.this);
            }
        });
        this.myUnitNamingStrategyMap = new UnitSettingMap(configuration.getUnitToNamingStrategyMap(), (PersistenceFacet)this);
        Disposer.register((Disposable)this, (Disposable)this.myDescriptorsContainer);
    }

    public void initFacet() {
        JavaeeUtil.installDomAndJamListeners((Facet)this, (ConfigFileContainer)this.myDescriptorsContainer);
    }

    @Nullable
    public ConfigFile getMainDeploymentDescriptor() {
        return this.myDescriptorsContainer.getConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA);
    }

    public ConfigFile getDefaultORMDescriptor() {
        return this.myDescriptorsContainer.getConfigFile(JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA);
    }

    public ConfigFile[] getDescriptors() {
        return this.myDescriptorsContainer.getConfigFiles();
    }

    @Nullable
    public Persistence getPersistenceRoot() {
        XmlFile xmlFile = this.getPersistenceXmlInModule();
        if (xmlFile != null) {
            return (Persistence)CachedValuesManager.getCachedValue((PsiElement)xmlFile, () -> CachedValueProvider.Result.createSingleDependency((Object)((Persistence)JamCommonUtil.getRootElement((PsiFile)xmlFile, Persistence.class)), (Object)xmlFile));
        }
        return null;
    }

    @Nullable
    public Persistence getMergedPersistenceRoot() {
        List<XmlFile> list = this.getPersistenceXmls();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            LinkedHashSet roots = new LinkedHashSet();
            for (XmlFile xmlFile : list) {
                ContainerUtil.addIfNotNull(roots, (Object)((Persistence)JamCommonUtil.getRootElement((PsiFile)xmlFile, Persistence.class)));
            }
            return (Persistence)DomService.getInstance().createModelMerger().mergeModels(Persistence.class, roots);
        }
        return (Persistence)JamCommonUtil.getRootElement((PsiFile)((PsiFile)list.get(0)), Persistence.class);
    }

    @Nullable
    public EntityMappings getAnnotationEntityMappings() {
        this.refreshModel();
        return this.myAnnotationsPersistenceRoot;
    }

    @NotNull
    public List<PersistencePackage> getPersistenceUnits() {
        List list = (List)CachedValuesManager.getManager((Project)this.getModule().getProject()).getCachedValue((UserDataHolder)this, () -> {
            ArrayList<PersistencePackage> packages = new ArrayList<PersistencePackage>();
            packages.addAll(this.getExplicitPersistenceUnits());
            packages.addAll(this.getExtensionPersistenceUnits());
            if (packages.isEmpty()) {
                ContainerUtil.addIfNotNull(packages, (Object)((Object)this.getImplicitPersistenceUnit()));
            }
            return CachedValueProvider.Result.create(packages, (Object[])new Object[]{FacetFinder.getInstance((Project)this.getModule().getProject()).getAllFacetsOfTypeModificationTracker(JpaFacet.ID)});
        });
        if (list == null) {
            JpaFacetImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<PersistencePackage> getExplicitPersistenceUnits() {
        ArrayList<PersistencePackage> packages = new ArrayList<PersistencePackage>();
        Persistence persistenceRoot = this.getMergedPersistenceRoot();
        if (persistenceRoot != null) {
            packages.addAll(persistenceRoot.getPersistenceUnits());
        }
        ArrayList<PersistencePackage> arrayList = packages;
        if (arrayList == null) {
            JpaFacetImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private VirtualPersistenceUnit getImplicitPersistenceUnit() {
        return new VirtualPersistenceUnit(this);
    }

    private static Object @NotNull [] getDependencies(@NotNull Project project) {
        if (project == null) {
            JpaFacetImpl.$$$reportNull$$$0(5);
        }
        Object[] objectArray = new Object[]{ProjectRootManager.getInstance((Project)project), FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(JpaFacet.ID), PsiModificationTracker.MODIFICATION_COUNT};
        if (objectArray == null) {
            JpaFacetImpl.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    @NotNull
    private List<PersistencePackage> getExtensionPersistenceUnits() {
        List list = ContainerUtil.concat((Iterable)PersistencePackagesProvider.EP_NAME.getExtensionList(), provider -> provider.getPersistencePackages((PersistenceFacet)this));
        if (list == null) {
            JpaFacetImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    public String getNamingStrategy(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(8);
        }
        return this.myUnitNamingStrategyMap.getSettingValue(unit);
    }

    public void setNamingStrategy(@NotNull PersistencePackage unit, String namingStrategy) {
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(9);
        }
        this.myUnitNamingStrategyMap.setSettingValue(unit, namingStrategy);
        FacetManager.getInstance((Module)this.getModule()).facetConfigurationChanged((Facet)this);
    }

    @NotNull
    public PersistenceMappings getEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(10);
        }
        assert (unit.isValid()) : String.format("Received invalid PersistencePackage [class: %s, name: %s]", unit.getClass(), unit.getName());
        this.refreshModel();
        Collection xmlMappings = PersistenceCommonUtil.getDomEntityMappings(com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class, (PersistencePackage)unit, (PersistenceFacet)this);
        EntityMappings annoMappings = this.getAnnotationEntityMappings(unit);
        if (annoMappings != null && xmlMappings.isEmpty()) {
            EntityMappings entityMappings = annoMappings;
            if (entityMappings == null) {
                JpaFacetImpl.$$$reportNull$$$0(11);
            }
            return entityMappings;
        }
        ArrayList<PersistenceMappings> allMappings = new ArrayList<PersistenceMappings>(xmlMappings);
        if (annoMappings != null) {
            allMappings.add(0, (PersistenceMappings)annoMappings);
        }
        return allMappings.isEmpty() ? (PersistenceMappings)DomManager.getDomManager((Project)this.getModule().getProject()).createMockElement(com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class, this.getModule(), true) : new MergedPersistenceMappings((PersistenceFacet)this, allMappings);
    }

    @Nullable
    public EntityMappings getAnnotationEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(12);
        }
        return this.myAnnotationsPersistenceRoot != null ? this.myAnnotationsPersistenceRoot.createCustomMappings((Condition<PsiClass>)((Condition)JpaFacetImpl.getAnnoMappingsCondition((PersistenceFacet)this, unit).getValue())) : null;
    }

    @NotNull
    public static CachedValue<Condition<PsiClass>> getAnnoMappingsCondition(PersistenceFacet facet, PersistencePackage unit) {
        CachedValue value = (CachedValue)unit.getUserData(ANNO_MAPPINGS_CONDITION);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)facet.getModule().getProject()).createCachedValue(() -> {
                Condition<PsiClass> result = unit instanceof PersistenceUnit ? JpaFacetImpl.createAnnoMappingsCondition((PersistenceUnit)unit, facet.getModule()) : JpaFacetImpl.createAnnoMappingsConditionDefault(unit);
                return new CachedValueProvider.Result(result, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            unit.putUserData(ANNO_MAPPINGS_CONDITION, (Object)value);
        }
        CachedValue cachedValue = value;
        if (cachedValue == null) {
            JpaFacetImpl.$$$reportNull$$$0(13);
        }
        return cachedValue;
    }

    private static Condition<PsiClass> createAnnoMappingsConditionDefault(PersistencePackage unit) {
        Collection classNames = GenericValueUtil.getClassStringCollection((Collection)unit.getModelHelper().getClasses(), (Collection)new THashSet());
        Collection packageNames = GenericValueUtil.getStringCollection((Collection)unit.getModelHelper().getPackages(), (Collection)new THashSet());
        Collection jarFiles = GenericValueUtil.getStringCollection((Collection)unit.getModelHelper().getJarFiles(), (Collection)new THashSet());
        if (EntityMappingsImpl.allEmpty(classNames, packageNames, jarFiles)) {
            if (Boolean.TRUE.equals(unit.getModelHelper().getExcludeUnlistedClasses().getValue())) {
                return Conditions.alwaysFalse();
            }
            return Conditions.alwaysTrue();
        }
        return EntityMappingsImpl.createUnitMappingsCondition(null, classNames, jarFiles, packageNames);
    }

    private static Condition<PsiClass> createAnnoMappingsCondition(PersistenceUnit unit, Module module) {
        Condition<PsiClass> result;
        boolean listedClasses = JpaUtil.isExcludeUnlistedClasses(unit);
        if (listedClasses || unit.getModule() == null) {
            Collection jarFiles;
            Collection classNames;
            if (listedClasses) {
                classNames = GenericValueUtil.getClassStringCollection((Collection)unit.getClasses(), (Collection)new THashSet());
                jarFiles = GenericValueUtil.getStringCollection((Collection)unit.getJarFiles(), (Collection)new THashSet());
                for (String jarFile : new ArrayList(jarFiles)) {
                    jarFiles.remove(jarFile);
                    jarFiles.add(jarFile.substring(jarFile.lastIndexOf(47) + 1));
                }
            } else {
                classNames = null;
                jarFiles = null;
            }
            result = EntityMappingsImpl.createUnitMappingsCondition(listedClasses ? null : JpaCommonUtil.getORMClassesSearchScope((Project)module.getProject(), (Module)module, (PsiFile)unit.getXmlTag().getContainingFile()), classNames, jarFiles, null);
        } else {
            result = Conditions.alwaysTrue();
        }
        return result;
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myDescriptorsContainer;
    }

    @NotNull
    public List<com.intellij.javaee.model.xml.persistence.mapping.EntityMappings> getDefaultEntityMappings(@NotNull PersistencePackage unit) {
        com.intellij.javaee.model.xml.persistence.mapping.EntityMappings defORMDescriptor;
        ConfigFile ormDescriptor;
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(14);
        }
        if ((ormDescriptor = this.getDefaultORMDescriptor()) == null) {
            PsiFile containingFile = unit.getContainingFile();
            VirtualFile xmlVf = containingFile == null ? null : containingFile.getVirtualFile();
            defORMDescriptor = PersistentUnitFileConverterImpl.findEntityMappings(JavaeeUtil.getDefaultDescriptorPath((ConfigFileMetaData)JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA), xmlVf, PsiManager.getInstance((Project)this.getModule().getProject()), this.getModule());
        } else {
            defORMDescriptor = (com.intellij.javaee.model.xml.persistence.mapping.EntityMappings)JamCommonUtil.getRootElement((PsiFile)ormDescriptor.getXmlFile(), com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class);
        }
        if (defORMDescriptor != null) {
            List<com.intellij.javaee.model.xml.persistence.mapping.EntityMappings> list = Collections.singletonList(defORMDescriptor);
            if (list == null) {
                JpaFacetImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<com.intellij.javaee.model.xml.persistence.mapping.EntityMappings> list = Collections.emptyList();
        if (list == null) {
            JpaFacetImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public Class<PersistenceUnit> getPersistenceUnitClass() {
        return PersistenceUnit.class;
    }

    @NotNull
    public Map<ConfigFileMetaData, Class<? extends PersistenceMappings>> getSupportedDomMappingFormats() {
        Map<ConfigFileMetaData, Class<? extends PersistenceMappings>> map = Collections.singletonMap(JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA, com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class);
        if (map == null) {
            JpaFacetImpl.$$$reportNull$$$0(17);
        }
        return map;
    }

    public String getDataSourceId(@NotNull PersistencePackagePointer unit) {
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(18);
        }
        return this.myUnitDataSourceMap.getSettingValue(unit.getElementName());
    }

    public String getDataSourceId(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(19);
        }
        return this.myUnitDataSourceMap.getDataSourceID(unit);
    }

    public void setDataSourceId(@NotNull PersistencePackage unit, String dataSourceID) {
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(20);
        }
        this.myUnitDataSourceMap.setDataSourceID(unit, dataSourceID);
        FacetManager.getInstance((Module)this.getModule()).facetConfigurationChanged((Facet)this);
    }

    public Language getQlLanguage() {
        return JpaUtil.isHibernateProvider(this) ? JpqlLanguage.HQL : (JpaUtil.isEclipseLinkProvider(this) ? JpqlLanguage.EQL : JpqlLanguage.JPQL);
    }

    @NotNull
    public ModelValidator getModelValidator(@Nullable PersistencePackage unit) {
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)this, (PersistencePackage)unit, null);
        return unit instanceof PersistenceUnit && JpaUtil.isHibernateProvider((PersistenceFacet)this, unit) ? new HibernateModelValidator(browser) : new JpaModelValidator(browser);
    }

    public Class @NotNull [] getInspectionToolClasses() {
        Class[] classArray = new JpaInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            JpaFacetImpl.$$$reportNull$$$0(21);
        }
        return classArray;
    }

    @NotNull
    public PersistencePackageDefaults getPersistenceUnitDefaults(@NotNull PersistencePackage unit) {
        if (unit == null) {
            JpaFacetImpl.$$$reportNull$$$0(22);
        }
        assert (unit.isValid());
        CachedValue cachedValue = (CachedValue)unit.getUserData(PERSISTENCE_UNIT_DEFAULTS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)unit.getPsiManager().getProject()).createCachedValue(() -> {
                Collection mappings = PersistenceCommonUtil.getDomEntityMappings(com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class, (PersistencePackage)unit, (PersistenceFacet)this);
                String _schema = null;
                String _catalog = null;
                PropertyMemberType _access = null;
                for (Object mapping : mappings) {
                    PersistenceUnitDefaults defaults = mapping.getPersistenceUnitMetadata().getPersistenceUnitDefaults();
                    if (!DomUtil.hasXml((DomElement)defaults)) continue;
                    _schema = (String)defaults.getSchema().getValue();
                    _catalog = (String)defaults.getCatalog().getValue();
                    AccessType type = (AccessType)defaults.getAccess().getValue();
                    _access = type == null ? null : (type == AccessType.FIELD ? PropertyMemberType.FIELD : PropertyMemberType.GETTER);
                    break;
                }
                HashSet<ModificationTracker> dependencies = new HashSet<ModificationTracker>();
                dependencies.add(this.getModificationTracker());
                ContainerUtil.addIfNotNull(dependencies, (Object)unit.getContainingFile());
                for (com.intellij.javaee.model.xml.persistence.mapping.EntityMappings mapping : mappings) {
                    ContainerUtil.addIfNotNull(dependencies, (Object)mapping.getContainingFile());
                }
                final String schema = _schema;
                final String catalog = _catalog;
                final PropertyMemberType access = _access;
                PersistencePackageDefaults result = new PersistencePackageDefaults(){

                    @Nullable
                    public String getSchema() {
                        return schema;
                    }

                    @Nullable
                    public String getCatalog() {
                        return catalog;
                    }

                    @Nullable
                    public PropertyMemberType getAccess() {
                        return access;
                    }
                };
                return new CachedValueProvider.Result((Object)result, dependencies.toArray());
            }, false);
            unit.putUserData(PERSISTENCE_UNIT_DEFAULTS, (Object)cachedValue);
        }
        PersistencePackageDefaults persistencePackageDefaults = (PersistencePackageDefaults)cachedValue.getValue();
        if (persistencePackageDefaults == null) {
            JpaFacetImpl.$$$reportNull$$$0(23);
        }
        return persistencePackageDefaults;
    }

    private void refreshModel() {
        List<PersistencePackage> allPersistenceUnits = this.getPersistenceUnits();
        if (!allPersistenceUnits.isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myAnnotationsPersistenceRoot == null) {
                this.myAnnotationsPersistenceRoot = new EntityMappingsImpl(this.getModule());
            }
        } else if (this.myAnnotationsPersistenceRoot != null) {
            this.myAnnotationsPersistenceRoot = null;
        }
    }

    public List<XmlFile> getPersistenceXmls() {
        ArrayList<XmlFile> persistenceXmls = new ArrayList<XmlFile>();
        ContainerUtil.addIfNotNull(persistenceXmls, (Object)this.getPersistenceXmlInModule());
        ContainerUtil.addAllNotNull(persistenceXmls, this.findPersistenceXmlsInLibraries());
        return persistenceXmls;
    }

    @Nullable
    public XmlFile getPersistenceXmlInModule() {
        XmlFile xmlFile;
        ConfigFile persistenceDescriptor = this.getMainDeploymentDescriptor();
        if (persistenceDescriptor != null && (xmlFile = persistenceDescriptor.getXmlFile()) != null) {
            return xmlFile;
        }
        return null;
    }

    public List<XmlFile> findPersistenceXmlsInLibraries() {
        Module module = this.getModule();
        if (this.myMyCachedXmls == null) {
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)module.getProject());
            this.myMyCachedXmls = cachedValuesManager.createCachedValue(() -> {
                VirtualFile[] files;
                ArrayList<XmlFile> resourceFiles = new ArrayList<XmlFile>();
                for (VirtualFile file : files = OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots()) {
                    PsiFile psiFile2;
                    String tagNS;
                    VirtualFile candidate = file.findFileByRelativePath(JavaeeUtil.getDefaultDescriptorPath((ConfigFileMetaData)JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA));
                    if (candidate == null || (tagNS = JavaeeUtil.getRootTagNS((PsiFile)(psiFile2 = PsiManager.getInstance((Project)module.getProject()).findFile(candidate)), (String)"persistence")) == null || !tagNS.isEmpty() && !"http://java.sun.com/xml/ns/persistence".equals(tagNS)) continue;
                    resourceFiles.add((XmlFile)psiFile2);
                }
                Object[] objects = resourceFiles.toArray();
                return new CachedValueProvider.Result(resourceFiles, ArrayUtil.append((Object[])objects, (Object)ProjectRootManager.getInstance((Project)module.getProject())));
            }, false);
        }
        return (List)this.myMyCachedXmls.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/facet/JpaFacetImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/facet/JpaFacetImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnits";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitPersistenceUnits";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPersistenceUnits";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityMappings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnoMappingsCondition";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultEntityMappings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDomMappingFormats";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnitDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamingStrategy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setNamingStrategy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEntityMappings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationEntityMappings";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEntityMappings";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceId";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setDataSourceId";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceUnitDefaults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnitSettingMap {
        private final Map<String, String> myConfigurationMap;
        private final PersistenceFacet myFacet;
        private final Map<PersistencePackage, String> myUnitNameMapping = new ConcurrentHashMap<PersistencePackage, String>();
        private volatile long myModCount = -1L;

        public UnitSettingMap(Map<String, String> configurationMap, PersistenceFacet facet) {
            this.myConfigurationMap = configurationMap;
            this.myFacet = facet;
        }

        @Nullable
        public String getSettingValue(@NotNull PersistencePackage unit) {
            if (unit == null) {
                UnitSettingMap.$$$reportNull$$$0(0);
            }
            this.refreshPersistenceUnits();
            return this.myConfigurationMap.get(this.getAndCacheName(unit));
        }

        @Nullable
        public String getSettingValue(@NotNull String unitName) {
            if (unitName == null) {
                UnitSettingMap.$$$reportNull$$$0(1);
            }
            this.refreshPersistenceUnits();
            return this.myConfigurationMap.get(unitName);
        }

        public synchronized void setSettingValue(@NotNull PersistencePackage unit, @Nullable String dataSourceID) {
            String unitName;
            if (unit == null) {
                UnitSettingMap.$$$reportNull$$$0(2);
            }
            if (StringUtil.isNotEmpty((String)(unitName = this.getAndCacheName(unit)))) {
                this.myConfigurationMap.put(unitName, dataSourceID);
            }
        }

        private void refreshPersistenceUnits() {
            if (this.myModCount != this.myFacet.getModificationTracker().getModificationCount()) {
                this.refreshImpl();
            }
        }

        private synchronized void refreshImpl() {
            this.myModCount = this.myFacet.getModificationTracker().getModificationCount();
            ArrayList<PersistencePackage> unitsToRemove = new ArrayList<PersistencePackage>();
            ArrayList namesToRemove = new ArrayList();
            for (PersistencePackage unit : this.myUnitNameMapping.keySet()) {
                if (unit.isValid()) continue;
                unitsToRemove.add(unit);
                ContainerUtil.addIfNotNull(namesToRemove, (Object)this.myUnitNameMapping.get(unit));
            }
            for (PersistencePackage unit : this.myFacet.getPersistenceUnits()) {
                String prevValue;
                String prevName = this.myUnitNameMapping.get(unit);
                String unitName = this.getAndCacheName(unit);
                String string = prevValue = StringUtil.isEmpty((String)prevName) ? null : this.myConfigurationMap.get(prevName);
                if (!StringUtil.isNotEmpty((String)unitName)) continue;
                if (prevName != null && !unitName.equals(prevName)) {
                    this.myConfigurationMap.remove(prevName);
                }
                namesToRemove.remove(unitName);
                this.myConfigurationMap.put(unitName, (String)ObjectUtils.chooseNotNull((Object)prevValue, (Object)this.getValueInner(unit)));
            }
            this.myUnitNameMapping.keySet().removeAll(unitsToRemove);
            this.myConfigurationMap.keySet().removeAll(namesToRemove);
        }

        @NotNull
        private String getAndCacheName(@NotNull PersistencePackage unit) {
            String s;
            if (unit == null) {
                UnitSettingMap.$$$reportNull$$$0(3);
            }
            if ((s = this.myUnitNameMapping.get(unit)) == null && StringUtil.isNotEmpty((String)(s = PersistencePackageAsVirtualFileImpl.getElementName(unit)))) {
                this.myUnitNameMapping.put(unit, s);
            }
            String string = s;
            if (string == null) {
                UnitSettingMap.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        private String getValueInner(@NotNull PersistencePackage unit) {
            String value;
            if (unit == null) {
                UnitSettingMap.$$$reportNull$$$0(5);
            }
            if (StringUtil.isEmpty((String)(value = this.myConfigurationMap.get(this.getAndCacheName(unit))))) {
                value = this.getDefaultSettingValue(unit);
            }
            return value;
        }

        @Nullable
        protected String getDefaultSettingValue(@NotNull PersistencePackage unit) {
            if (unit == null) {
                UnitSettingMap.$$$reportNull$$$0(6);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unitName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/facet/JpaFacetImpl$UnitSettingMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/facet/JpaFacetImpl$UnitSettingMap";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAndCacheName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSettingValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSettingValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getAndCacheName";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueInner";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultSettingValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class UnitDataSourceMap
    extends UnitSettingMap {
        public UnitDataSourceMap(Map<String, String> configurationMap, PersistenceFacet facet) {
            super(configurationMap, facet);
        }

        public String getDataSourceID(@NotNull PersistencePackage unit) {
            if (unit == null) {
                UnitDataSourceMap.$$$reportNull$$$0(0);
            }
            return this.getSettingValue(unit);
        }

        public void setDataSourceID(@NotNull PersistencePackage unit, String dataSourceID) {
            if (unit == null) {
                UnitDataSourceMap.$$$reportNull$$$0(1);
            }
            this.setSettingValue(unit, dataSourceID);
        }

        @Override
        @Nullable
        protected String getDefaultSettingValue(@NotNull PersistencePackage unit) {
            GenericValue value;
            String name;
            if (unit == null) {
                UnitDataSourceMap.$$$reportNull$$$0(2);
            }
            String string = name = (value = unit.getModelHelper().getDataSourceName()) != null ? (String)value.getValue() : null;
            if (name == null) {
                return null;
            }
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)unit.getPsiManager().getProject());
            return (String)JBIterable.from((Iterable)facade.getDataSources()).filter(o -> name.equals(o.getName())).map(o -> o.getUniqueId()).first();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "unit";
            objectArray2[1] = "com/intellij/jpa/facet/JpaFacetImpl$UnitDataSourceMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDataSourceID";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDataSourceID";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDefaultSettingValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

