/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public abstract class JpaDataSourceDetectorBase<F extends Facet>
extends DataSourceDetector {
    private final FacetTypeId<F> myFacetTypeId;

    protected JpaDataSourceDetectorBase(@NotNull FacetTypeId<F> facetTypeId) {
        if (facetTypeId == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(0);
        }
        this.myFacetTypeId = facetTypeId;
    }

    protected abstract Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> getProviders();

    protected static PairConsumer<DataSourceDetector.Builder, Properties> provider(String urlProp, String userProp, String passwordProp, String driverProp) {
        return (builder, properties) -> {
            JpaDataSourceDetectorBase.collect((Setter<String>)((Setter)arg_0 -> ((DataSourceDetector.Builder)builder).withUrl(arg_0)), properties, urlProp);
            JpaDataSourceDetectorBase.collect((Setter<String>)((Setter)arg_0 -> ((DataSourceDetector.Builder)builder).withUser(arg_0)), properties, userProp);
            JpaDataSourceDetectorBase.collect((Setter<String>)((Setter)arg_0 -> ((DataSourceDetector.Builder)builder).withPassword(arg_0)), properties, passwordProp);
            JpaDataSourceDetectorBase.collect((Setter<String>)((Setter)arg_0 -> ((DataSourceDetector.Builder)builder).withDriverClass(arg_0)), properties, driverProp);
        };
    }

    private static void collect(@NotNull Setter<String> setter, @NotNull Properties properties, @NotNull String keys) {
        if (setter == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(2);
        }
        if (keys == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(3);
        }
        for (String key : StringUtil.split((String)keys, (String)",", (boolean)true, (boolean)true)) {
            String property = properties.getProperty(key.trim());
            if (property == null) continue;
            setter.set((Object)property);
        }
    }

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        if (module == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(5);
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)module.getProject());
        Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(this.myFacetTypeId);
        for (Facet facet : facets) {
            for (PersistencePackage unit : ((PersistenceFacet)facet).getPersistenceUnits()) {
                PsiElement origin = unit instanceof DomElement ? ((DomElement)unit).getXmlElement() : unit.getIdentifyingPsiElement();
                PersistencePackageAsVirtualFileImpl file = PersistencePackageAsVirtualFileImpl.findFile(unit, (PersistenceFacet)facet);
                if (file == null) continue;
                String unitName = file.getElementName();
                DbDataSource existingDataSource = dbPsiFacade.findDataSource(((PersistenceFacet)facet).getDataSourceId(unit));
                String existingDataSourceName = existingDataSource == null ? null : existingDataSource.getName();
                DataSourceDetector.Callback callback = JpaDataSourceDetectorBase.newCallback(file);
                Properties properties = unit.getModelHelper().getPersistenceUnitProperties();
                Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> providers = this.getProviders();
                for (String provider : providers.keySet()) {
                    String dataSourceName = unitName + "/" + provider;
                    if (onTheFly && existingDataSourceName != null && !Objects.equals(existingDataSourceName, dataSourceName)) continue;
                    providers.get(provider).consume((Object)builder.withName(dataSourceName), (Object)properties);
                    builder.withComment(provider).withOrigin((Object)origin).withCallback(callback).commit();
                }
            }
        }
    }

    @NotNull
    private static DataSourceDetector.Callback newCallback(final @NotNull PersistencePackageAsVirtualFileImpl file) {
        if (file == null) {
            JpaDataSourceDetectorBase.$$$reportNull$$$0(6);
        }
        return new DataSourceDetector.Callback(){

            public void onCreated(@NotNull DasDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                PersistenceFacet facet = (PersistenceFacet)ObjectUtils.tryCast((Object)file.findFacet(), PersistenceFacet.class);
                PersistencePackage unit = file.findElement();
                if (unit != null && facet != null && facet.getDataSourceId(unit) == null) {
                    facet.setDataSourceId(unit, dataSource.getUniqueId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/jpa/JpaDataSourceDetectorBase$1", "onCreated"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetTypeId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/JpaDataSourceDetectorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDataSources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "newCallback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

