/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.JpaDataSourceDetectorBase;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairConsumer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class JpaDataSourceDetector
extends JpaDataSourceDetectorBase<JpaFacet> {
    private final Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> myProviders = new LinkedHashMap<String, PairConsumer<DataSourceDetector.Builder, Properties>>();

    @NotNull
    public static PairConsumer<DataSourceDetector.Builder, Properties> providerHibernate() {
        PairConsumer<DataSourceDetector.Builder, Properties> pairConsumer = JpaDataSourceDetector.provider("connection.url, hibernate.connection.url", "connection.username, hibernate.connection.username", "connection.password, hibernate.connection.password", "connection.driver_class, hibernate.connection.driver_class");
        if (pairConsumer == null) {
            JpaDataSourceDetector.$$$reportNull$$$0(0);
        }
        return pairConsumer;
    }

    public JpaDataSourceDetector() {
        super(JpaFacet.ID);
        this.myProviders.put("Hibernate", JpaDataSourceDetector.providerHibernate());
        this.myProviders.put("EclipseLink", JpaDataSourceDetector.provider("eclipselink.jdbc.url", "eclipselink.jdbc.user", "eclipselink.jdbc.password", "eclipselink.jdbc.driver"));
        this.myProviders.put("glassfish", JpaDataSourceDetector.provider("jdbc.connection.string", "jdbc.user", "jdbc.password", "jdbc.driver"));
        this.myProviders.put("OpenJPA", JpaDataSourceDetector.provider("openjpa.ConnectionURL", "openjpa.ConnectionUserName", "openjpa.ConnectionPassword", "openjpa.ConnectionDriverName"));
        this.myProviders.put("TopLink", JpaDataSourceDetector.provider("toplink.jdbc.url", "toplink.jdbc.user", "toplink.jdbc.password", "toplink.jdbc.driver"));
    }

    @Override
    protected Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> getProviders() {
        return this.myProviders;
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            JpaDataSourceDetector.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
        return virtualFile != null && JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName().equals(virtualFile.getName()) && !fileIndex.isInTestSourceContent(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaDataSourceDetector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "providerHibernate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaDataSourceDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

