/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.jpa.AbstractQlModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultQlModel
extends AbstractQlModel {
    private final boolean myHibernate;
    private final Module myModule;
    private final SmartPsiElementPointer<XmlFile> myFilePointer;

    public DefaultQlModel(boolean hibernate, PsiFile psiFile2) {
        super(psiFile2.getProject());
        this.myHibernate = hibernate;
        this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile2);
        this.myFilePointer = psiFile2 instanceof XmlFile ? SmartPointerManager.getInstance((Project)psiFile2.getProject()).createSmartPsiElementPointer((PsiElement)((XmlFile)psiFile2)) : null;
    }

    public DefaultQlModel(boolean hibernate, Module module) {
        super(module.getProject());
        this.myHibernate = hibernate;
        this.myModule = module;
        this.myFilePointer = null;
    }

    @Override
    protected void processPersistenceMappings(PairProcessor<PersistenceMappings, PersistenceModelBrowser> processor) {
        boolean skipMappings;
        XmlFile xmlFile = this.myFilePointer == null ? null : (XmlFile)this.myFilePointer.getElement();
        DomFileElement fileElement = xmlFile == null ? null : DomManager.getDomManager((Project)xmlFile.getProject()).getFileElement(xmlFile, DomElement.class);
        PersistenceMappings mappings = fileElement != null && fileElement.getRootElement() instanceof PersistenceMappings ? (PersistenceMappings)fileElement.getRootElement() : null;
        boolean bl = skipMappings = mappings == null;
        if (this.myModule != null) {
            for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)this.myModule)) {
                for (PersistencePackage unit : facet.getPersistenceUnits()) {
                    PersistenceMappings entityMappings = facet.getEntityMappings(unit);
                    skipMappings = skipMappings || ModelMergerUtil.getImplementations((Object)entityMappings).contains(mappings);
                    PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)facet, (PersistencePackage)unit, null);
                    processor.process((Object)entityMappings, (Object)browser);
                }
            }
        }
        if (!skipMappings) {
            processor.process((Object)mappings, (Object)PersistenceCommonUtil.createSameUnitsModelBrowser((DomElement)((DomElement)mappings)));
        }
    }

    @Override
    protected boolean isHibernate() {
        return this.myHibernate;
    }

    @Override
    @NotNull
    protected List<? extends PersistenceFacet> getPersistenceFacets() {
        if (this.myModule == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DefaultQlModel.$$$reportNull$$$0(0);
            }
            return list;
        }
        List list = PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)this.myModule);
        if (list == null) {
            DefaultQlModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/DefaultQlModel", "getPersistenceFacets"));
    }
}

